/*
 * Decompiled with CFR 0.152.
 */
package com.tom.vivecraftcompat.overlay;

import com.mojang.logging.LogUtils;
import com.tom.vivecraftcompat.overlay.OverlayAccess;
import com.tom.vivecraftcompat.overlay.OverlayEnable;
import com.tom.vivecraftcompat.overlay.OverlayManager;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.client.event.RenderGuiLayerEvent;
import net.neoforged.neoforge.client.gui.GuiLayerManager;
import net.neoforged.neoforge.common.NeoForge;
import org.slf4j.Logger;

public class HudOverlayScreen
extends Screen {
    public static final Logger LOGGER = LogUtils.getLogger();
    public List<ResourceLocation> overlays = new ArrayList<ResourceLocation>();
    private final String id;
    private String name;
    public boolean outline;
    public OverlayManager.Layer layer;
    public OverlayEnable enable = OverlayEnable.ALWAYS;

    public HudOverlayScreen(String id) {
        super((Component)Component.literal((String)""));
        this.id = id;
    }

    public void render(GuiGraphics poseStack, int pMouseX, int pMouseY, float pt) {
        if (this.minecraft.player == null || this.minecraft.gameMode == null || this.minecraft.level == null || !this.isEnabled()) {
            return;
        }
        if (this.outline) {
            poseStack.fill(0, 0, this.width, 1, -65536);
            poseStack.fill(0, 0, 1, this.height, -65536);
            poseStack.fill(this.width - 1, 0, this.width, this.height, -65536);
            poseStack.fill(0, this.height - 1, this.width, this.height, -65536);
        }
        DeltaTracker dt = this.minecraft.getTimer();
        this.overlays.forEach(id -> {
            GuiLayerManager.NamedLayer entry = OverlayAccess.getLayerMap().get(id);
            if (entry != null) {
                try {
                    if (!((RenderGuiLayerEvent.Pre)NeoForge.EVENT_BUS.post((Event)new RenderGuiLayerEvent.Pre(poseStack, dt, entry.name(), entry.layer()))).isCanceled()) {
                        entry.layer().render(poseStack, dt);
                        NeoForge.EVENT_BUS.post((Event)new RenderGuiLayerEvent.Post(poseStack, dt, entry.name(), entry.layer()));
                    }
                }
                catch (Exception e) {
                    LOGGER.error("Error rendering overlay '{}'", (Object)entry.name(), (Object)e);
                }
            }
        });
    }

    public String toString() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public String getId() {
        return this.id;
    }

    public boolean isEnabled() {
        return this.enable.test(this.minecraft);
    }
}

