/*
 * Decompiled with CFR 0.152.
 */
package me.itzme1on.alcocraftplus.core.recipes;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import me.itzme1on.alcocraftplus.core.registries.RecipesRegistry;
import me.itzme1on.alcocraftplus.core.utils.StreamCodecUtil;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class KegRecipes
implements Recipe<RecipeInput> {
    private final ItemStack output;
    private final NonNullList<Ingredient> recipeItems;

    public KegRecipes(ItemStack output, NonNullList<Ingredient> recipeItems) {
        this.output = output;
        this.recipeItems = recipeItems;
    }

    public boolean matches(RecipeInput inventory, Level level) {
        if (inventory == null) {
            return false;
        }
        if (inventory.size() != this.recipeItems.size()) {
            return false;
        }
        NonNullList remainingIngredients = NonNullList.create();
        remainingIngredients.addAll(this.recipeItems);
        for (int i = 0; i < inventory.size(); ++i) {
            ItemStack itemInContainer = inventory.getItem(i);
            if (itemInContainer.isEmpty()) continue;
            boolean foundMatch = false;
            for (int j = 0; j < remainingIngredients.size(); ++j) {
                if (!((Ingredient)remainingIngredients.get(j)).test(itemInContainer)) continue;
                remainingIngredients.remove(j);
                foundMatch = true;
                break;
            }
            if (foundMatch) continue;
            return false;
        }
        return remainingIngredients.isEmpty();
    }

    @NotNull
    public NonNullList<Ingredient> getIngredients() {
        return this.recipeItems;
    }

    @NotNull
    public ItemStack assemble(RecipeInput input, HolderLookup.Provider registries) {
        return this.output.copy();
    }

    public boolean canCraftInDimensions(int width, int height) {
        return width * height >= 4;
    }

    @NotNull
    public ItemStack getResultItem(HolderLookup.Provider provider) {
        return this.output.copy();
    }

    @NotNull
    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)RecipesRegistry.KEG_RECIPE_SERIALIZER.get();
    }

    @NotNull
    public RecipeType<?> getType() {
        return (RecipeType)RecipesRegistry.KEG_RECIPE_TYPE.get();
    }

    public boolean isSpecial() {
        return true;
    }

    public static class Serializer
    implements RecipeSerializer<KegRecipes> {
        public static final MapCodec<KegRecipes> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Ingredient.CODEC_NONEMPTY.listOf().fieldOf("ingredients").flatXmap(list -> {
            Object[] ingredients = (Ingredient[])list.toArray(Ingredient[]::new);
            if (ingredients.length == 0) {
                return DataResult.error(() -> "No ingredients for shapeless recipe");
            }
            return DataResult.success((Object)NonNullList.of((Object)Ingredient.EMPTY, (Object[])ingredients));
        }, DataResult::success).forGetter(KegRecipes::getIngredients), (App)ItemStack.CODEC.optionalFieldOf("result").forGetter(recipe -> Optional.of(recipe.output)), (App)ItemStack.CODEC.optionalFieldOf("output").forGetter(recipe -> Optional.empty())).apply((Applicative)instance, (ingredients, resultOpt, outputOpt) -> new KegRecipes(resultOpt.orElseGet(() -> outputOpt.orElse(ItemStack.EMPTY)), (NonNullList<Ingredient>)ingredients)));
        public static final StreamCodec<RegistryFriendlyByteBuf, KegRecipes> STREAM_CODEC = StreamCodec.composite(StreamCodecUtil.nonNullList(Ingredient.CONTENTS_STREAM_CODEC, Ingredient.EMPTY), KegRecipes::getIngredients, (StreamCodec)ItemStack.STREAM_CODEC, recipe -> recipe.output, (ingredients, result) -> new KegRecipes((ItemStack)result, (NonNullList<Ingredient>)ingredients));

        @NotNull
        public MapCodec<KegRecipes> codec() {
            return CODEC;
        }

        @NotNull
        public StreamCodec<RegistryFriendlyByteBuf, KegRecipes> streamCodec() {
            return STREAM_CODEC;
        }
    }
}

