/*
 * Decompiled with CFR 0.152.
 */
package me.itzme1on.alcocraftplus.core.effects;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.animal.Wolf;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.CollisionContext;

public class FreezeEffect
extends MobEffect {
    public FreezeEffect(MobEffectCategory category, int color) {
        super(category, color);
    }

    public boolean applyEffectTick(LivingEntity entity, int amplifier) {
        Level level = entity.level();
        if (level.isClientSide()) {
            return true;
        }
        if (entity.onGround()) {
            BlockPos pos = entity.blockPosition();
            BlockState iceState = Blocks.FROSTED_ICE.defaultBlockState();
            int radius = 2 + amplifier;
            BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos();
            for (int x = -radius; x <= radius; ++x) {
                for (int z = -radius; z <= radius; ++z) {
                    BlockState blockState;
                    BlockPos below = pos.offset(x, -1, z);
                    if (!(below.distSqr((Vec3i)pos) <= (double)(radius * radius)) || (blockState = level.getBlockState(below)).getBlock() != Blocks.WATER || (Integer)blockState.getValue((Property)LiquidBlock.LEVEL) != 0 || !level.getBlockState(mutablePos.set((Vec3i)below).above()).isAir() || !iceState.canSurvive((LevelReader)level, below) || !level.isUnobstructed(iceState, below, CollisionContext.empty())) continue;
                    level.setBlockAndUpdate(below, iceState);
                    level.scheduleTick(below, Blocks.FROSTED_ICE, Mth.nextInt((RandomSource)entity.getRandom(), (int)60, (int)120));
                }
            }
        }
        if (entity.tickCount % 10 == 0) {
            double slownessRadius = 5.0 + (double)amplifier;
            AABB aabb = new AABB(entity.getX() - slownessRadius, entity.getY() - slownessRadius, entity.getZ() - slownessRadius, entity.getX() + slownessRadius, entity.getY() + slownessRadius, entity.getZ() + slownessRadius);
            for (LivingEntity nearby : level.getEntitiesOfClass(LivingEntity.class, aabb)) {
                if (nearby == entity || !(nearby instanceof Enemy) && (!(nearby instanceof Wolf) || ((TamableAnimal)nearby).isTame())) continue;
                nearby.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SLOWDOWN, 60, Math.max(0, 1 + amplifier)));
            }
        }
        return true;
    }

    public boolean shouldApplyEffectTickThisTick(int duration, int amplifier) {
        return true;
    }
}

