/*
 * Decompiled with CFR 0.152.
 */
package me.itzme1on.alcocraftplus.client.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import dev.architectury.hooks.fluid.FluidStackHooks;
import me.itzme1on.alcocraftplus.client.gui.handler.KegGuiHandler;
import me.itzme1on.alcocraftplus.core.utils.ColorUtil;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;

public class KegGui
extends AbstractContainerScreen<KegGuiHandler> {
    private static final ResourceLocation TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"alcocraftplus", (String)"textures/gui/keg_gui.png");
    private static final ResourceLocation BG = ResourceLocation.fromNamespaceAndPath((String)"alcocraftplus", (String)"textures/gui/dark_bg.png");
    private static final Fluid DEFAULT_FLUID = Fluids.WATER;
    private static final int[] BUBBLE_LENGTHS = new int[]{0, 6, 11, 16, 20, 24, 28};
    private static final int BACKGROUND_INSET = 3;
    private static final int FLUID_X_OFFSET = 3;
    private static final int FLUID_Y_OFFSET = 3;
    private static final int BUBBLE_X_OFFSET = 150;
    private static final int BUBBLE_Y_OFFSET = 17;
    private static final int BUBBLE_AREA_HEIGHT = 28;
    private static final int BUBBLE_ANIM_DURATION_TICKS = 100;
    private int bubbleAnimationTimer;

    public KegGui(KegGuiHandler menu, Inventory inventory, Component title) {
        super((AbstractContainerMenu)menu, inventory, title);
    }

    protected void renderBg(GuiGraphics guiGraphics, float partialTick, int mouseX, int mouseY) {
        RenderSystem.setShader(GameRenderer::getPositionShader);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int x = (this.width - this.imageWidth) / 2;
        int y = (this.height - this.imageHeight) / 2 - 2;
        int fluidX = (this.width - this.imageWidth) / 2 + 3;
        int fluidY = (this.height - this.imageHeight) / 2 + 3;
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)BG);
        guiGraphics.blit(BG, x + 3, y + 3, 0, 0, this.imageWidth - 6, this.imageHeight - 6);
        this.renderFluid(guiGraphics, fluidX, fluidY);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)TEXTURE);
        guiGraphics.blit(TEXTURE, x, y, 0, 0, this.imageWidth, this.imageHeight + 2);
        this.renderProgressBars(guiGraphics, x, y);
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float delta) {
        this.renderBackground(guiGraphics, mouseX, mouseY, delta);
        super.render(guiGraphics, mouseX, mouseY, delta);
        this.renderTooltip(guiGraphics, mouseX, mouseY);
        this.bubbleAnimationTimer = ((KegGuiHandler)this.menu).isCrafting(0) ? (this.bubbleAnimationTimer + 1) % 100 : 0;
    }

    private void renderProgressBars(GuiGraphics guiGraphics, int x, int y) {
        if (((KegGuiHandler)this.menu).isCrafting(0)) {
            int bubbleIndex = this.bubbleAnimationTimer * BUBBLE_LENGTHS.length / 100;
            if (bubbleIndex >= BUBBLE_LENGTHS.length) {
                bubbleIndex = 0;
            }
            int bubbleHeight = this.getBubbleHeight(bubbleIndex);
            guiGraphics.blit(TEXTURE, x + 150, y + 17 + 28 - bubbleHeight, 176, 28 - bubbleHeight, 11, bubbleHeight);
        }
    }

    protected void renderLabels(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        guiGraphics.drawString(this.font, this.title, this.titleLabelX, this.titleLabelY, ColorUtil.getColorFromRGB(215, 171, 121));
        guiGraphics.drawString(this.font, this.playerInventoryTitle, this.inventoryLabelX, this.inventoryLabelY, ColorUtil.getColorFromRGB(64, 64, 64), false);
        this.renderTimer(guiGraphics);
    }

    private void renderTimer(GuiGraphics guiGraphics) {
        int colorShadow = ColorUtil.getColorFromRGB(97, 69, 36);
        int colorText = ColorUtil.getColorFromRGB(215, 171, 121);
        int progress = ((KegGuiHandler)this.menu).getProgress();
        int maxProgress = ((KegGuiHandler)this.menu).getMaxProgress();
        if (!((KegGuiHandler)this.menu).isCrafting(0)) {
            guiGraphics.drawString(this.font, "00:00", 143, 47, colorShadow);
            guiGraphics.drawString(this.font, "00:00", 143, 47, colorText);
        } else if (maxProgress > 0) {
            int remainingProgress = maxProgress - progress;
            int timeInSeconds = remainingProgress / 20;
            String formattedTime = this.formatTime(timeInSeconds);
            guiGraphics.drawString(this.font, formattedTime, 143, 47, colorShadow);
            guiGraphics.drawString(this.font, formattedTime, 143, 47, colorText);
        } else {
            guiGraphics.drawString(this.font, "00:00", 143, 47, colorShadow);
            guiGraphics.drawString(this.font, "00:00", 143, 47, colorText);
        }
    }

    private void renderFluid(GuiGraphics guiGraphics, int x, int y) {
        int color;
        int beerLevel = ((KegGuiHandler)this.menu).getBeerLevel();
        int beerType = ((KegGuiHandler)this.menu).getBeerType();
        int waterLevel = ((KegGuiHandler)this.menu).getWaterLevel();
        int maxWaterLevel = 32;
        TextureAtlasSprite sprite = FluidStackHooks.getStillTexture((Fluid)DEFAULT_FLUID);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)InventoryMenu.BLOCK_ATLAS);
        if (beerLevel > 0) {
            color = this.getBeerColor(beerType);
            this.renderFluidArea(guiGraphics, x, y, beerLevel, maxWaterLevel, color, sprite);
        }
        if (waterLevel > 0 && beerLevel < maxWaterLevel) {
            color = this.getGuiFluidColor();
            this.renderFluidArea(guiGraphics, x, y, waterLevel, maxWaterLevel, color, sprite);
        }
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    private void renderFluidArea(GuiGraphics guiGraphics, int x, int y, int fluidLevel, int maxFluidLevel, int color, TextureAtlasSprite sprite) {
        int textureWidth = 16;
        int textureHeight = 16;
        RenderSystem.setShaderColor((float)((float)(color >> 16 & 0xFF) / 255.0f), (float)((float)(color >> 8 & 0xFF) / 255.0f), (float)((float)(color & 0xFF) / 255.0f), (float)1.0f);
        int denom = Math.max(1, maxFluidLevel / 4);
        int rows = Math.min(4, (int)Math.ceil((double)fluidLevel / (double)denom));
        for (int row = 0; row < rows; ++row) {
            for (int col = 0; col <= 8; ++col) {
                guiGraphics.blit(x + textureWidth * col, y + textureHeight * (3 - row), 0, textureWidth, textureHeight, sprite);
            }
        }
    }

    private int getGuiFluidColor() {
        if (DEFAULT_FLUID == Fluids.WATER || DEFAULT_FLUID == Fluids.FLOWING_WATER) {
            return ColorUtil.getColorFromRGB(63, 118, 228);
        }
        int c = FluidStackHooks.getColor((Fluid)DEFAULT_FLUID);
        int rgb = c & 0xFFFFFF;
        if (rgb == 0) {
            return ColorUtil.getColorFromRGB(255, 255, 255);
        }
        return rgb;
    }

    private int getBeerColor(int beerType) {
        return switch (beerType) {
            case 1 -> ColorUtil.getColorFromRGB(222, 167, 81);
            case 2 -> ColorUtil.getColorFromRGB(201, 125, 31);
            case 3 -> ColorUtil.getColorFromRGB(107, 30, 5);
            case 4 -> ColorUtil.getColorFromRGB(29, 5, 3);
            case 5 -> ColorUtil.getColorFromRGB(170, 14, 1);
            case 6 -> ColorUtil.getColorFromRGB(75, 165, 128);
            case 7 -> ColorUtil.getColorFromRGB(58, 70, 123);
            case 8 -> ColorUtil.getColorFromRGB(143, 181, 246);
            case 9 -> ColorUtil.getColorFromRGB(188, 137, 39);
            case 10 -> ColorUtil.getColorFromRGB(69, 201, 72);
            case 11 -> ColorUtil.getColorFromRGB(142, 102, 141);
            case 12 -> ColorUtil.getColorFromRGB(236, 231, 255);
            default -> ColorUtil.getColorFromRGB(255, 255, 255);
        };
    }

    private String formatTime(int time) {
        int minutes = time / 60;
        int seconds = time % 60;
        return String.format("%02d:%02d", minutes, seconds);
    }

    private int getBubbleHeight(int progress) {
        return BUBBLE_LENGTHS[progress % BUBBLE_LENGTHS.length];
    }
}

