/*
 * Decompiled with CFR 0.152.
 */
package net.caffeinemc.mods.lithium.mixin.ai.poi.fast_portals;

import com.mojang.serialization.Codec;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.SectionPos;
import net.minecraft.world.entity.ai.village.poi.PoiManager;
import net.minecraft.world.entity.ai.village.poi.PoiSection;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import net.minecraft.world.level.chunk.storage.ChunkIOErrorReporter;
import net.minecraft.world.level.chunk.storage.SectionStorage;
import net.minecraft.world.level.chunk.storage.SimpleRegionStorage;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;

@Mixin(value={PoiManager.class})
public abstract class PoiManagerMixin
extends SectionStorage<PoiSection> {
    @Shadow
    @Final
    private LongSet loadedChunks;
    @Unique
    private final LongSet preloadedCenterChunks = new LongOpenHashSet();
    @Unique
    private int preloadRadius = 0;

    public PoiManagerMixin(SimpleRegionStorage storageAccess, Function<Runnable, Codec<PoiSection>> codecFactory, Function<Runnable, PoiSection> factory, RegistryAccess registryManager, ChunkIOErrorReporter errorHandler, LevelHeightAccessor world) {
        super(storageAccess, codecFactory, factory, registryManager, errorHandler, world);
    }

    @Overwrite
    public void ensureLoadedAndValid(LevelReader worldView, BlockPos pos, int radius) {
        long chunkPos;
        if (this.preloadRadius != radius) {
            this.preloadedCenterChunks.clear();
            this.preloadRadius = radius;
        }
        if (this.preloadedCenterChunks.contains(chunkPos = ChunkPos.asLong((BlockPos)pos))) {
            return;
        }
        int chunkX = SectionPos.blockToSectionCoord((int)pos.getX());
        int chunkZ = SectionPos.blockToSectionCoord((int)pos.getZ());
        int chunkRadius = Math.floorDiv(radius, 16);
        int maxHeight = this.levelHeightAccessor.getMaxSection() - 1;
        int minHeight = this.levelHeightAccessor.getMinSection();
        int xMax = chunkX + chunkRadius;
        for (int x = chunkX - chunkRadius; x <= xMax; ++x) {
            int zMax = chunkZ + chunkRadius;
            for (int z = chunkZ - chunkRadius; z <= zMax; ++z) {
                this.lithium$preloadChunkIfAnySubChunkContainsPOI(worldView, x, z, minHeight, maxHeight);
            }
        }
        this.preloadedCenterChunks.add(chunkPos);
    }

    @Unique
    private void lithium$preloadChunkIfAnySubChunkContainsPOI(LevelReader worldView, int x, int z, int minSubChunk, int maxSubChunk) {
        ChunkPos chunkPos = new ChunkPos(x, z);
        long longChunkPos = chunkPos.toLong();
        if (this.loadedChunks.contains(longChunkPos)) {
            return;
        }
        for (int y = minSubChunk; y <= maxSubChunk; ++y) {
            boolean result;
            Optional section = this.getOrLoad(SectionPos.asLong((int)x, (int)y, (int)z));
            if (!section.isPresent() || !(result = ((PoiSection)section.get()).isValid())) continue;
            if (!this.loadedChunks.add(longChunkPos)) break;
            worldView.getChunk(x, z, ChunkStatus.EMPTY);
            break;
        }
    }
}

