/*
 * Decompiled with CFR 0.152.
 */
package win.demistorm.neoforge;

import net.minecraft.core.registries.Registries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.neoforge.client.event.EntityRenderersEvent;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import net.neoforged.neoforge.network.registration.PayloadRegistrar;
import net.neoforged.neoforge.registries.RegisterEvent;
import win.demistorm.ThrownProjectileEntity;
import win.demistorm.VRThrowingExtensions;
import win.demistorm.client.ThrownItemRenderer;
import win.demistorm.neoforge.BufferPacket;
import win.demistorm.neoforge.ClientSetup;
import win.demistorm.neoforge.NeoForgeConfigScreen;
import win.demistorm.network.Network;

@Mod(value="vr_throwing_extensions")
public class VRThrowingExtensionsNeoForge {
    public VRThrowingExtensionsNeoForge(IEventBus modEventBus) {
        VRThrowingExtensions.log.info("VR Throwing Extensions (NEOFORGE) starting!");
        modEventBus.addListener(event -> {
            PayloadRegistrar registrar = event.registrar("vr_throwing_extensions").optional();
            registrar.playBidirectional(BufferPacket.TYPE, BufferPacket.STREAM_CODEC, (packet, context) -> {
                if (context.flow().isClientbound()) {
                    if (FMLEnvironment.dist.isClient()) {
                        ClientSetup.handleNetworkPacket(packet.buffer());
                    }
                } else {
                    this.handleServerPacket(packet.buffer(), context);
                }
            });
            VRThrowingExtensions.log.info("Registered NeoForge network handlers in constructor");
        });
        modEventBus.addListener(this::registerEntities);
        if (FMLEnvironment.dist.isClient()) {
            modEventBus.addListener(this::registerEntityRenderers);
        }
        try {
            Class.forName("org.vivecraft.api.VRAPI");
            VRThrowingExtensions.log.info("Vivecraft detected! VR throwing enabled.");
        }
        catch (ClassNotFoundException e) {
            VRThrowingExtensions.log.error("Vivecraft not found! VR Throwing Extensions requires Vivecraft to function.");
            throw new RuntimeException("Vivecraft is required for VR Throwing Extensions");
        }
        VRThrowingExtensions.initialize();
        Network.initialize();
        if (FMLEnvironment.dist.isClient()) {
            ClientSetup.doClientSetup();
            NeoForgeConfigScreen.register();
        }
        VRThrowingExtensions.log.info("VR Throwing Extensions (NEOFORGE) initialization complete!");
    }

    private void registerEntities(RegisterEvent event) {
        ResourceLocation entityLocation = ResourceLocation.fromNamespaceAndPath((String)"vr_throwing_extensions", (String)"generic_thrown_item");
        if (event.getRegistryKey() == Registries.ENTITY_TYPE) {
            event.register(Registries.ENTITY_TYPE, entityLocation, () -> {
                VRThrowingExtensions.THROWN_ITEM_TYPE = EntityType.Builder.of(ThrownProjectileEntity::new, (MobCategory)MobCategory.MISC).sized(0.25f, 0.25f).clientTrackingRange(64).updateInterval(5).build("vr_throwing_extensions:generic_thrown_item");
                return VRThrowingExtensions.THROWN_ITEM_TYPE;
            });
            VRThrowingExtensions.log.info("Registered entity type: {}", (Object)entityLocation);
        }
    }

    private void registerEntityRenderers(EntityRenderersEvent.RegisterRenderers event) {
        if (FMLEnvironment.dist.isClient() && VRThrowingExtensions.THROWN_ITEM_TYPE != null) {
            event.registerEntityRenderer(VRThrowingExtensions.THROWN_ITEM_TYPE, ThrownItemRenderer::new);
            VRThrowingExtensions.log.info("Registered thrown item renderer for NeoForge");
        }
    }

    private void handleServerPacket(RegistryFriendlyByteBuf buffer, IPayloadContext context) {
        context.enqueueWork(() -> {
            ServerPlayer player = (ServerPlayer)context.player();
            if (VRThrowingExtensions.THROWN_ITEM_TYPE == null) {
                VRThrowingExtensions.log.error("[NeoForge] THROWN_ITEM_TYPE is null when processing packet! Entity registration may not be complete.");
                return;
            }
            Network.INSTANCE.handlePacket(player, buffer);
        });
    }
}

