/*
 * Decompiled with CFR 0.152.
 */
package win.demistorm;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import net.minecraft.server.level.ServerPlayer;
import win.demistorm.VRThrowingExtensions;
import win.demistorm.WeaponEffectType;
import win.demistorm.network.ConfigSyncData;
import win.demistorm.network.Network;

public final class ConfigHelper {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final Path CONFIGDIR = Path.of("config", new String[0]);
    private static final Path FILE = CONFIGDIR.resolve("vr-throwing-extensions.json");
    public static final Data CLIENT = new Data();
    public static final Data ACTIVE = new Data();

    private static String toJson(Data d) {
        return GSON.toJson((Object)d);
    }

    private static Data fromJson(String js) {
        return (Data)GSON.fromJson(js, Data.class);
    }

    public static void loadOrCreateServerConfig() {
        Data d = ConfigHelper.read();
        if (!Files.exists(FILE, new LinkOption[0])) {
            ConfigHelper.write(d);
        }
        ConfigHelper.copyInto(d, ACTIVE);
    }

    public static void loadOrCreateClientConfig() {
        Data d = ConfigHelper.read();
        ConfigHelper.write(d);
        ConfigHelper.copyInto(d, CLIENT);
        ConfigHelper.copyInto(CLIENT, ACTIVE);
    }

    private static Data read() {
        try {
            if (Files.exists(FILE, new LinkOption[0])) {
                return ConfigHelper.fromJson(Files.readString(FILE));
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return new Data();
    }

    public static void write(Data d) {
        try {
            Files.createDirectories(CONFIGDIR, new FileAttribute[0]);
            Files.writeString(FILE, (CharSequence)ConfigHelper.toJson(d), new OpenOption[0]);
        }
        catch (IOException e) {
            VRThrowingExtensions.log.error("Unable to write config!", (Throwable)e);
        }
    }

    public static void copyInto(Data from, Data to) {
        to.weaponEffect = from.weaponEffect;
        to.aimAssist = from.aimAssist;
    }

    public static void sendConfigToPlayer(ServerPlayer player) {
        ConfigSyncData data = new ConfigSyncData(ConfigHelper.toJson(ACTIVE));
        Network.INSTANCE.sendToPlayer(player, data);
    }

    public static void clientReceivedRemote(String json) {
        ConfigHelper.copyInto(ConfigHelper.fromJson(json), ACTIVE);
        VRThrowingExtensions.log.debug("Received remote config: {}", (Object)json);
    }

    public static void clientDisconnected() {
        ConfigHelper.copyInto(CLIENT, ACTIVE);
    }

    public static final class Data {
        public WeaponEffectType weaponEffect = WeaponEffectType.BOOMERANG;
        public boolean aimAssist = true;
    }
}

