/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.voicechat.net;

import de.maxhenkel.voicechat.net.Packet;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;

public class JoinGroupPacket
implements Packet<JoinGroupPacket> {
    public static final CustomPacketPayload.Type<JoinGroupPacket> SET_GROUP = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"voicechat", (String)"set_group"));
    private UUID group;
    @Nullable
    private String password;

    public JoinGroupPacket() {
    }

    public JoinGroupPacket(UUID group, @Nullable String password) {
        this.group = group;
        this.password = password;
    }

    public UUID getGroup() {
        return this.group;
    }

    @Nullable
    public String getPassword() {
        return this.password;
    }

    @Override
    public JoinGroupPacket fromBytes(FriendlyByteBuf buf) {
        this.group = buf.readUUID();
        if (buf.readBoolean()) {
            this.password = buf.readUtf(512);
        }
        return this;
    }

    @Override
    public void toBytes(FriendlyByteBuf buf) {
        buf.writeUUID(this.group);
        buf.writeBoolean(this.password != null);
        if (this.password != null) {
            buf.writeUtf(this.password, 512);
        }
    }

    @Override
    public CustomPacketPayload.Type<JoinGroupPacket> type() {
        return SET_GROUP;
    }
}

