/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.equipment.armor;

import com.google.common.cache.Cache;
import com.mojang.blaze3d.vertex.PoseStack;
import com.simibubi.create.AllPartialModels;
import com.simibubi.create.content.equipment.armor.CardboardArmorHandler;
import com.simibubi.create.content.logistics.box.PackageRenderer;
import com.simibubi.create.foundation.utility.TickBasedCache;
import dev.engine_room.flywheel.lib.model.baked.PartialModel;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import net.createmod.catnip.animation.AnimationTickHolder;
import net.minecraft.client.CameraType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.RenderPlayerEvent;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;

@EventBusSubscriber(value={Dist.CLIENT})
public class CardboardArmorHandlerClient {
    private static final Cache<UUID, Integer> BOXES_PLAYERS_ARE_HIDING_AS = new TickBasedCache<UUID, Integer>(20, true);

    @SubscribeEvent
    public static void keepCacheAliveDesignDespiteNotRendering(PlayerTickEvent.Post event) {
        Player player = event.getEntity();
        if (!CardboardArmorHandler.testForStealth((Entity)player)) {
            return;
        }
        try {
            CardboardArmorHandlerClient.getCurrentBoxIndex(player);
        }
        catch (ExecutionException e) {
            e.printStackTrace();
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void playerRendersAsBoxWhenSneaking(RenderPlayerEvent.Pre event) {
        Player player = event.getEntity();
        if (!CardboardArmorHandler.testForStealth((Entity)player)) {
            return;
        }
        event.setCanceled(true);
        if (player == Minecraft.getInstance().player && Minecraft.getInstance().options.getCameraType() == CameraType.FIRST_PERSON) {
            return;
        }
        PoseStack ms = event.getPoseStack();
        ms.pushPose();
        Vec3 renderOffset = event.getRenderer().getRenderOffset((AbstractClientPlayer)player, event.getPartialTick());
        ms.translate(0.0, -renderOffset.y, 0.0);
        float movement = (float)player.position().subtract(player.xo, player.yo, player.zo).length();
        if (player.onGround()) {
            ms.translate(0.0, Math.min((double)Math.abs(Mth.cos((float)(AnimationTickHolder.getRenderTime() % 256.0f / 2.0f))) * -renderOffset.y, (double)(movement * 5.0f)), 0.0);
        }
        float interpolatedYaw = Mth.lerp((float)event.getPartialTick(), (float)player.yRotO, (float)player.getYRot());
        float scale = player.getScale();
        ms.scale(scale, scale, scale);
        try {
            PartialModel model = AllPartialModels.PACKAGES_TO_HIDE_AS.get(CardboardArmorHandlerClient.getCurrentBoxIndex(player));
            PackageRenderer.renderBox((Entity)player, interpolatedYaw, ms, event.getMultiBufferSource(), event.getPackedLight(), model);
        }
        catch (ExecutionException e) {
            e.printStackTrace();
        }
        ms.popPose();
    }

    private static Integer getCurrentBoxIndex(Player player) throws ExecutionException {
        return (Integer)BOXES_PLAYERS_ARE_HIDING_AS.get((Object)player.getUUID(), () -> player.level().random.nextInt(AllPartialModels.PACKAGES_TO_HIDE_AS.size()));
    }
}

