/*
 * Decompiled with CFR 0.152.
 */
package com.github.talrey.createdeco.blocks;

import com.github.talrey.createdeco.BlockRegistry;
import com.simibubi.create.api.connectivity.ConnectivityHandler;
import com.simibubi.create.api.packager.InventoryIdentifier;
import com.simibubi.create.content.logistics.vault.ItemVaultBlock;
import com.simibubi.create.content.logistics.vault.ItemVaultBlockEntity;
import com.simibubi.create.foundation.ICapabilityProvider;
import com.simibubi.create.foundation.blockEntity.behaviour.inventory.VersionedInventoryWrapper;
import com.simibubi.create.foundation.utility.SameSizeCombinedInvWrapper;
import com.tterrag.registrate.util.entry.BlockEntityEntry;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import net.neoforged.neoforge.items.ItemStackHandler;
import org.jetbrains.annotations.Nullable;

public class ShippingContainerBlock
extends ItemVaultBlock {
    public final DyeColor COLOR;
    public static final SoundType SILENCED_METAL = new SoundType(0.1f, 1.5f, SoundEvents.NETHERITE_BLOCK_BREAK, SoundEvents.NETHERITE_BLOCK_STEP, SoundEvents.NETHERITE_BLOCK_PLACE, SoundEvents.NETHERITE_BLOCK_HIT, SoundEvents.NETHERITE_BLOCK_FALL);

    public ShippingContainerBlock(BlockBehaviour.Properties properties, DyeColor color) {
        super(properties);
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)LARGE, (Comparable)Boolean.valueOf(false)));
        this.COLOR = color;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> pBuilder) {
        super.createBlockStateDefinition(pBuilder);
    }

    public static DyeColor getColor(BlockState state) {
        Block block = state.getBlock();
        if (block instanceof ShippingContainerBlock) {
            ShippingContainerBlock scb = (ShippingContainerBlock)block;
            return scb.COLOR;
        }
        return DyeColor.BLUE;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isSameType(BlockState other) {
        Block block = other.getBlock();
        if (!(block instanceof ShippingContainerBlock)) return false;
        ShippingContainerBlock container = (ShippingContainerBlock)block;
        if (container.COLOR != this.COLOR) return false;
        return true;
    }

    public static boolean isVault(BlockState state) {
        return state.getBlock() instanceof ShippingContainerBlock;
    }

    public static boolean isLarge(BlockState state) {
        if (!ShippingContainerBlock.isVault(state)) {
            return false;
        }
        return (Boolean)state.getValue((Property)LARGE);
    }

    @Nullable
    public static Direction.Axis getVaultBlockAxis(BlockState state) {
        if (!ShippingContainerBlock.isVault(state)) {
            return null;
        }
        return (Direction.Axis)state.getValue(HORIZONTAL_AXIS);
    }

    public BlockEntityType<? extends ItemVaultBlockEntity> getBlockEntityType() {
        return (BlockEntityType)BlockRegistry.CONTAINER_ENTITIES.get(this.COLOR).get();
    }

    public static class Entity
    extends ItemVaultBlockEntity {
        public Entity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
            super(type, pos, state);
        }

        public static void registerCapabilities(RegisterCapabilitiesEvent event) {
            for (BlockEntityEntry<Entity> vault : BlockRegistry.CONTAINER_ENTITIES.values()) {
                event.registerBlockEntity(Capabilities.ItemHandler.BLOCK, (BlockEntityType)vault.get(), (be, context) -> {
                    be.initCapability();
                    if (be.itemCapability == null) {
                        return null;
                    }
                    return (IItemHandler)be.itemCapability.getCapability();
                });
            }
        }

        public InventoryIdentifier getInvId() {
            this.initCapability();
            return this.invId;
        }

        public Entity getControllerBE() {
            if (this.isController()) {
                return this;
            }
            BlockEntity blockEntity = this.level.getBlockEntity(this.controller);
            if (blockEntity instanceof Entity) {
                Entity entity = (Entity)blockEntity;
                return entity;
            }
            return null;
        }

        protected void updateConnectivity() {
            this.updateConnectivity = false;
            if (this.level.isClientSide()) {
                return;
            }
            if (!this.isController()) {
                return;
            }
            ConnectivityHandler.formMulti((BlockEntity)this);
        }

        public void notifyMultiUpdated() {
            BlockState state = this.getBlockState();
            if (ShippingContainerBlock.isVault(state)) {
                this.level.setBlock(this.getBlockPos(), (BlockState)state.setValue((Property)ItemVaultBlock.LARGE, (Comparable)Boolean.valueOf(this.radius > 2)), 6);
            }
            super.notifyMultiUpdated();
        }

        public void removeController(boolean keepContents) {
            BlockState state = this.getBlockState();
            if (ShippingContainerBlock.isVault(state)) {
                state = (BlockState)state.setValue((Property)ItemVaultBlock.LARGE, (Comparable)Boolean.valueOf(false));
                this.getLevel().setBlock(this.worldPosition, state, 22);
            }
            super.removeController(keepContents);
        }

        private void initCapability() {
            if (this.itemCapability != null && this.itemCapability.getCapability() != null) {
                return;
            }
            if (!this.isController()) {
                Entity controllerBE = this.getControllerBE();
                if (controllerBE == null) {
                    return;
                }
                controllerBE.initCapability();
                this.itemCapability = ICapabilityProvider.of(() -> {
                    if (controllerBE.isRemoved()) {
                        return null;
                    }
                    if (controllerBE.itemCapability == null) {
                        return null;
                    }
                    return (IItemHandler)controllerBE.itemCapability.getCapability();
                });
                this.invId = controllerBE.invId;
                return;
            }
            boolean alongZ = ItemVaultBlock.getVaultBlockAxis((BlockState)this.getBlockState()) == Direction.Axis.Z;
            IItemHandlerModifiable[] invs = new IItemHandlerModifiable[this.length * this.radius * this.radius];
            for (int yOffset = 0; yOffset < this.length; ++yOffset) {
                for (int xOffset = 0; xOffset < this.radius; ++xOffset) {
                    for (int zOffset = 0; zOffset < this.radius; ++zOffset) {
                        BlockPos vaultPos = alongZ ? this.worldPosition.offset(xOffset, zOffset, yOffset) : this.worldPosition.offset(yOffset, xOffset, zOffset);
                        Entity vaultAt = (Entity)ConnectivityHandler.partAt((BlockEntityType)this.getType(), (BlockGetter)this.getLevel(), (BlockPos)vaultPos);
                        invs[yOffset * this.radius * this.radius + xOffset * this.radius + zOffset] = vaultAt != null ? vaultAt.inventory : new ItemStackHandler();
                    }
                }
            }
            this.itemCapability = ICapabilityProvider.of((Object)new VersionedInventoryWrapper((IItemHandlerModifiable)SameSizeCombinedInvWrapper.create((IItemHandlerModifiable[])invs)));
            BlockPos farCorner = alongZ ? this.worldPosition.offset(this.radius, this.radius, this.length) : this.worldPosition.offset(this.length, this.radius, this.radius);
            BoundingBox bounds = BoundingBox.fromCorners((Vec3i)this.worldPosition, (Vec3i)farCorner);
            this.invId = new InventoryIdentifier.Bounds(bounds);
        }
    }
}

