/*
 * Decompiled with CFR 0.152.
 */
package org.antarcticgardens.cna.content.nuclear.reactor.fuelacceptor;

import java.util.LinkedList;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.Containers;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.antarcticgardens.cna.CNATags;
import org.antarcticgardens.cna.CreateNewAge;
import org.antarcticgardens.cna.content.nuclear.reactor.RodFindingReactorBlockEntity;
import org.antarcticgardens.cna.content.nuclear.reactor.rod.ReactorRodBlockEntity;

public abstract class ReactorFuelAcceptorBlockEntity
extends RodFindingReactorBlockEntity {
    public SimpleContainer container = new FuelAcceptorContainer(this, 3);
    int ticks = 0;

    public ReactorFuelAcceptorBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState blockState) {
        super(type, pos, blockState);
    }

    protected void write(CompoundTag compound, HolderLookup.Provider registries, boolean clientPacket) {
        compound.put("contents", (Tag)this.container.createTag(registries));
        super.write(compound, registries, clientPacket);
    }

    protected void read(CompoundTag compound, HolderLookup.Provider registries, boolean clientPacket) {
        this.container.fromTag(compound.getList("contents", 10), registries);
        super.read(compound, registries, clientPacket);
    }

    public void destroy() {
        super.destroy();
        for (int i = 0; i < this.container.getContainerSize(); ++i) {
            Containers.dropItemStack((Level)this.level, (double)this.worldPosition.getX(), (double)this.worldPosition.getY(), (double)this.worldPosition.getZ(), (ItemStack)this.container.getItem(i));
        }
    }

    public void tick(BlockPos pos, Level world, BlockState state) {
        --this.ticks;
        if (this.ticks <= 0) {
            this.ticks = 20;
            LinkedList<ReactorRodBlockEntity> rods = new LinkedList<ReactorRodBlockEntity>();
            for (Direction dir : Direction.values()) {
                this.findRods(rods, dir);
            }
            if (rods.isEmpty()) {
                return;
            }
            AtomicInteger have = new AtomicInteger();
            int hadBefore = 0;
            for (ReactorRodBlockEntity rod : rods) {
                hadBefore += rod.fuel;
            }
            AtomicInteger totalNeeded = new AtomicInteger(345600 * rods.size() - hadBefore);
            for (int i = 0; i < this.container.getContainerSize(); ++i) {
                ItemStack stack = this.container.getItem(i);
                if (!stack.is(CNATags.Item.NUCLEAR_FUEL.tag)) continue;
                stack.getTags().forEach(itemTagKey -> {
                    String path;
                    if (itemTagKey.location().getNamespace().equals("create_new_age") && (path = itemTagKey.location().getPath()).startsWith("nuclear/energy_")) {
                        try {
                            int energy = Integer.parseInt(path.substring(15));
                            int total = (int)Math.min((double)stack.getCount(), (double)(totalNeeded.get() / energy));
                            totalNeeded.addAndGet(-energy * total);
                            have.addAndGet(energy * total);
                            stack.shrink(total);
                        }
                        catch (NumberFormatException e) {
                            CreateNewAge.LOGGER.error("BAD TAG " + String.valueOf(itemTagKey) + " on item " + stack.getDisplayName().getString(), (Throwable)e);
                        }
                    }
                });
            }
            this.setChanged();
            int target = (hadBefore + have.get()) / rods.size();
            for (ReactorRodBlockEntity rod : rods) {
                rod.fuel = target;
            }
        }
    }

    private class FuelAcceptorContainer
    extends SimpleContainer {
        FuelAcceptorContainer(ReactorFuelAcceptorBlockEntity reactorFuelAcceptorBlockEntity, int size) {
            super(size);
        }

        public boolean canPlaceItem(int index, ItemStack stack) {
            return stack.is(CNATags.Item.NUCLEAR_FUEL.tag);
        }
    }
}

