/*
 * Decompiled with CFR 0.152.
 */
package org.antarcticgardens.cna.content.nuclear;

import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FallingBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import org.antarcticgardens.cna.CNABlocks;
import org.antarcticgardens.cna.content.heat.HeatBlockEntity;
import org.antarcticgardens.cna.content.nuclear.NuclearUtil;

public class CoriumBlock
extends FallingBlock {
    public static final MapCodec<CoriumBlock> CODEC = CoriumBlock.simpleCodec(CoriumBlock::new);

    public CoriumBlock(BlockBehaviour.Properties properties) {
        super(properties.randomTicks());
    }

    protected MapCodec<? extends FallingBlock> codec() {
        return CODEC;
    }

    public void animateTick(BlockState state, Level level, BlockPos pos, RandomSource random) {
    }

    public void randomTick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        NuclearUtil.createRadiation(20, (Level)level, pos);
        for (Direction dir : Direction.values()) {
            BlockEntity be = level.getBlockEntity(pos.relative(dir));
            if (!(be instanceof HeatBlockEntity)) continue;
            HeatBlockEntity heat = (HeatBlockEntity)be;
            heat.addHeat(random.nextFloat() * 3000.0f);
            level.sendBlockUpdated(pos.relative(dir), be.getBlockState(), be.getBlockState(), 2);
        }
        if ((double)random.nextFloat() < 0.05) {
            level.setBlock(pos, CNABlocks.SOLID_CORIUM.getDefaultState(), 3);
            return;
        }
        if (level.getBlockState(pos.relative(Direction.DOWN)).getBlock().getExplosionResistance() < (float)random.nextInt(2, 12)) {
            level.setBlock(pos.relative(Direction.DOWN), Blocks.AIR.defaultBlockState(), 3);
        }
    }
}

