/*
 * Decompiled with CFR 0.152.
 */
package org.antarcticgardens.cna;

import java.nio.file.Path;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.packs.PackLocationInfo;
import net.minecraft.server.packs.PackSelectionConfig;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.PathPackResources;
import net.minecraft.server.packs.repository.KnownPack;
import net.minecraft.server.packs.repository.Pack;
import net.minecraft.server.packs.repository.PackSource;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModList;
import net.neoforged.neoforge.event.AddPackFindersEvent;
import net.neoforged.neoforgespi.language.IModInfo;
import org.antarcticgardens.cna.Platform;
import org.antarcticgardens.cna.content.nuclear.reactor.fuelacceptor.ReactorFuelAcceptorBlockEntity;
import org.antarcticgardens.cna.neoforge.NeoForgeRegistrar;
import org.antarcticgardens.cna.neoforge.compat.jei.ForgeJeiEnergisingSubcategory;
import org.antarcticgardens.cna.neoforge.content.nuclear.reactor.fuelacceptor.NeoForgeReactorFuelAcceptorBlockEntity;
import org.antarcticgardens.cna.platform.PlatformRegistrar;
import org.apache.maven.artifact.versioning.ArtifactVersion;

public class NeoForgePlatform
extends Platform {
    private final NeoForgeRegistrar registrationHelper = new NeoForgeRegistrar();
    private final IEventBus modEventBus;

    public NeoForgePlatform(IEventBus eventBus) {
        this.modEventBus = eventBus;
    }

    @Override
    public PlatformRegistrar getRegistrar() {
        return this.registrationHelper;
    }

    @Override
    public void commonSetup(Runnable commonSetup) {
        this.modEventBus.addListener(e -> e.enqueueWork(commonSetup));
    }

    @Override
    public Object getEnergisingRecipeSubCategory() {
        return () -> ForgeJeiEnergisingSubcategory::new;
    }

    @Override
    public ReactorFuelAcceptorBlockEntity platformReactorFuelAcceptorBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState blockState) {
        return new NeoForgeReactorFuelAcceptorBlockEntity(type, pos, blockState);
    }

    public static void registerDatapack(AddPackFindersEvent event) {
        if (event.getPackType() == PackType.SERVER_DATA) {
            Path path = ModList.get().getModFileById("create_new_age").getFile().findResource(new String[]{"resourcepacks/create_new_age_monkey_edition"});
            String version = ModList.get().getModFileById("create_new_age").getFile().getModInfos().stream().map(IModInfo::getVersion).map(ArtifactVersion::toString).collect(Collectors.joining(","));
            PackLocationInfo packLocationInfo = new PackLocationInfo("create_new_age:create_new_age_monkey_edition", (Component)Component.translatable((String)"create_new_age.monkey_edition"), PackSource.create(arg -> Component.translatable((String)"pack.nameAndSource", (Object[])new Object[]{arg, Component.translatable((String)"pack.source.builtin")}).withStyle(ChatFormatting.GRAY), (boolean)false), Optional.of(new KnownPack("create_new_age", "create_new_age_monkey_edition", version)));
            Pack builtinDataPack = Pack.readMetaAndCreate((PackLocationInfo)packLocationInfo, (Pack.ResourcesSupplier)new PathPackResources.PathResourcesSupplier(path), (PackType)PackType.SERVER_DATA, (PackSelectionConfig)new PackSelectionConfig(false, Pack.Position.TOP, false));
            event.addRepositorySource(packConsumer -> packConsumer.accept(builtinDataPack));
        }
    }
}

