/*
 * Decompiled with CFR 0.152.
 */
package org.sinytra.adapter.patch.transformer;

import com.mojang.datafixers.util.Pair;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;
import org.sinytra.adapter.patch.analysis.InheritanceHandler;
import org.sinytra.adapter.patch.analysis.params.EnhancedParamsDiff;
import org.sinytra.adapter.patch.analysis.params.SimpleParamsDiffSnapshot;
import org.sinytra.adapter.patch.api.MethodContext;
import org.sinytra.adapter.patch.api.MethodTransform;
import org.sinytra.adapter.patch.api.Patch;
import org.sinytra.adapter.patch.api.PatchContext;
import org.sinytra.adapter.patch.fixes.BytecodeFixerUpper;
import org.sinytra.adapter.patch.transformer.operation.param.TransformParameters;
import org.sinytra.adapter.patch.util.AdapterUtil;
import org.sinytra.adapter.patch.util.MethodQualifier;

public record SoftMethodParamsPatch(String replacementTarget, MethodTransform targetTransform) implements MethodTransform
{
    @Override
    public Collection<String> getAcceptedAnnotations() {
        return Set.of("Lorg/spongepowered/asm/mixin/injection/Inject;", "Lorg/spongepowered/asm/mixin/injection/Redirect;");
    }

    @Override
    public Patch.Result apply(ClassNode classNode, MethodNode methodNode, MethodContext methodContext, PatchContext context) {
        Patch.Result result = Patch.Result.PASS;
        MethodQualifier targetQualifier = methodContext.getTargetMethodQualifier();
        if (targetQualifier != null) {
            if (targetQualifier.name().equals("<init>") && !methodContext.capturesLocals() && methodContext.injectionPointAnnotation().getValue("value").map(s -> ((String)s.get()).equals("TAIL")).orElse(false).booleanValue()) {
                return Patch.Result.PASS;
            }
            List<Pair<Integer, Type>> replacements = this.determineAutomaticReplacements(targetQualifier, methodNode, context, this.replacementTarget);
            if (!replacements.isEmpty()) {
                TransformParameters patch = TransformParameters.builder().replacements(replacements).build();
                result = Patch.Result.APPLY.or(patch.apply(classNode, methodNode, methodContext, context));
            }
        }
        return result.or(this.targetTransform.apply(classNode, methodNode, methodContext, context));
    }

    private List<Pair<Integer, Type>> determineAutomaticReplacements(MethodQualifier targetQualifier, MethodNode methodNode, PatchContext context, String replacement) {
        Type[] newArgs;
        BytecodeFixerUpper bfu = context.environment().bytecodeFixerUpper();
        if (bfu == null) {
            return List.of();
        }
        MethodQualifier newQualifier = MethodQualifier.create(replacement).orElse(null);
        if (newQualifier == null) {
            return List.of();
        }
        Type[] args = Type.getArgumentTypes((String)targetQualifier.desc());
        SimpleParamsDiffSnapshot diff = EnhancedParamsDiff.create(args, newArgs = Type.getArgumentTypes((String)newQualifier.desc()));
        if (!diff.replacements().isEmpty() && diff.insertions().isEmpty() && diff.swaps().isEmpty()) {
            return diff.replacements().stream().filter(pair -> {
                int index = (Integer)pair.getFirst();
                Type type = (Type)pair.getSecond();
                Type original = args[(Integer)pair.getFirst()];
                return original.getSort() == 10 && type.getSort() == 10 && (bfu.getTypeAdapter((Type)pair.getSecond(), original) != null || SoftMethodParamsPatch.permittedTypeNarrowing(index, original, type, context.environment().inheritanceHandler(), methodNode));
            }).toList();
        }
        return List.of();
    }

    private static boolean permittedTypeNarrowing(int index, Type original, Type updated, InheritanceHandler inheritanceHandler, MethodNode methodNode) {
        if (inheritanceHandler.isClassInherited(original.getInternalName(), updated.getInternalName())) {
            int lvtIndex = AdapterUtil.getLVTIndexForParam(methodNode, index, original);
            for (AbstractInsnNode insn : methodNode.instructions) {
                if (!(insn instanceof VarInsnNode)) continue;
                VarInsnNode varInsn = (VarInsnNode)insn;
                if (varInsn.var != lvtIndex) continue;
                MethodInsnNode lastMethodCall = null;
                for (AbstractInsnNode next = insn.getNext(); next != null && !(next instanceof LabelNode); next = next.getNext()) {
                    MethodInsnNode minsn;
                    if (!(next instanceof MethodInsnNode)) continue;
                    lastMethodCall = minsn = (MethodInsnNode)next;
                }
                if (lastMethodCall.owner.equals(original.getInternalName()) && inheritanceHandler.isMethodOverriden(lastMethodCall.owner, lastMethodCall.name, lastMethodCall.desc)) continue;
                return false;
            }
            return true;
        }
        return false;
    }
}

