/*
 * Decompiled with CFR 0.152.
 */
package org.sinytra.adapter.patch;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.MethodNode;
import org.sinytra.adapter.patch.MethodContextImpl;
import org.sinytra.adapter.patch.PatchInstance;
import org.sinytra.adapter.patch.analysis.selector.AnnotationHandle;
import org.sinytra.adapter.patch.analysis.selector.FieldMatcher;
import org.sinytra.adapter.patch.api.ClassTransform;
import org.sinytra.adapter.patch.api.MethodTransform;
import org.sinytra.adapter.patch.api.Patch;
import org.sinytra.adapter.patch.api.PatchEnvironment;
import org.sinytra.adapter.patch.util.AdapterUtil;

public final class InterfacePatchInstance
extends PatchInstance {
    public static final Collection<String> KNOWN_INTERFACE_MIXIN_TYPES = Set.of("Lorg/spongepowered/asm/mixin/gen/Accessor;");
    private final List<FieldMatcher> targetFields;

    private InterfacePatchInstance(List<String> targetClasses, List<FieldMatcher> targetFields, List<String> targetAnnotations, Predicate<AnnotationHandle> targetAnnotationValues, List<ClassTransform> classTransforms, List<MethodTransform> transforms) {
        super(targetClasses, targetAnnotations, targetAnnotationValues, classTransforms, transforms);
        this.targetFields = targetFields;
    }

    @Override
    public Patch.Result apply(ClassNode classNode, PatchEnvironment environment) {
        if ((classNode.access & 0x200) == 0) {
            return Patch.Result.PASS;
        }
        return super.apply(classNode, environment);
    }

    @Override
    protected boolean checkAnnotation(String owner, MethodNode method, AnnotationHandle methodAnnotation, PatchEnvironment environment, MethodContextImpl.Builder builder) {
        FieldMatcher matcher;
        if (KNOWN_INTERFACE_MIXIN_TYPES.contains(methodAnnotation.getDesc()) && methodAnnotation.matchesDesc("Lorg/spongepowered/asm/mixin/gen/Accessor;") && (matcher = (FieldMatcher)AdapterUtil.getAccessorTargetFieldName(owner, method, methodAnnotation, environment).map(FieldMatcher::new).orElse(null)) != null && (this.targetFields.isEmpty() || this.targetFields.stream().anyMatch(m -> m.matches(matcher)))) {
            builder.methodNode(method);
            builder.methodAnnotation(methodAnnotation);
            return true;
        }
        return false;
    }

    public static class InterfaceClassPatchBuilderImpl
    extends PatchInstance.BaseBuilder<Patch.InterfacePatchBuilder>
    implements Patch.InterfacePatchBuilder {
        private final Set<FieldMatcher> targetFields = new HashSet<FieldMatcher>();

        @Override
        public Patch.InterfacePatchBuilder targetField(String ... targets) {
            for (String target : targets) {
                this.targetFields.add(new FieldMatcher(target));
            }
            return this;
        }

        @Override
        public PatchInstance build() {
            return new InterfacePatchInstance(List.copyOf(this.targetClasses), List.copyOf(this.targetFields), List.copyOf(this.targetAnnotations), this.targetAnnotationValues, List.copyOf(this.classTransforms), List.copyOf(this.transforms));
        }
    }
}

