/*
 * Decompiled with CFR 0.152.
 */
package org.sinytra.adapter.next.pipeline.resolver.injection;

import java.util.List;
import org.jetbrains.annotations.Nullable;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.sinytra.adapter.next.env.MixinContext;
import org.sinytra.adapter.next.env.ann.MixinData;
import org.sinytra.adapter.next.pipeline.config.Configuration;
import org.sinytra.adapter.next.pipeline.resolver.CompoundResolver;
import org.sinytra.adapter.next.pipeline.resolver.injection.ArbitraryInjectionPointSubResolver;
import org.sinytra.adapter.next.pipeline.resolver.injection.InjectionPointSubResolvers;
import org.sinytra.adapter.patch.api.MethodContext;
import org.sinytra.adapter.patch.util.MethodQualifier;

public class InjectionPointResolver
extends CompoundResolver {
    public InjectionPointResolver() {
        this.addSubResolver(InjectionPointSubResolvers.REPLACED_TYPE);
        this.addSubResolver(new ArbitraryInjectionPointSubResolver());
    }

    @Override
    protected boolean canApply(MixinData mixin, Configuration clean, Configuration dirty) {
        return dirty.getAtData() == null;
    }

    @Override
    @Nullable
    protected Configuration tryReuse(MixinContext context, Configuration clean, Configuration dirty) {
        MethodQualifier dirtyQualifier = dirty.getTargetMethod();
        if (dirtyQualifier == null) {
            return null;
        }
        MethodContext.TargetPair dirtyTarget = context.methods().findOwnMethodPair(context.dirtyLookup(), dirtyQualifier);
        if (dirtyTarget == null) {
            return null;
        }
        List<AbstractInsnNode> insns = context.methods().findInjectionTargetInsns(dirtyTarget);
        if (!insns.isEmpty()) {
            return dirty.subConfig().inheritAtData();
        }
        return null;
    }
}

