/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.neoforge.impl.biome;

import fuzs.puzzleslib.api.biome.v1.BiomeLoadingContext;
import fuzs.puzzleslib.api.core.v1.CommonAbstractions;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.dimension.LevelStem;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.structure.Structure;

public record BiomeLoadingContextNeoForge(RegistryAccess registryAccess, Holder<Biome> holder) implements BiomeLoadingContext
{
    public BiomeLoadingContextNeoForge(Holder<Biome> holder) {
        this((RegistryAccess)CommonAbstractions.INSTANCE.getMinecraftServer().registryAccess(), holder);
    }

    @Override
    public ResourceKey<Biome> getResourceKey() {
        return (ResourceKey)this.holder.unwrapKey().orElseThrow();
    }

    @Override
    public Biome getBiome() {
        return (Biome)this.holder.value();
    }

    @Override
    public Optional<ResourceKey<ConfiguredFeature<?, ?>>> getFeatureKey(ConfiguredFeature<?, ?> configuredFeature) {
        Registry registry = this.registryAccess.registryOrThrow(Registries.CONFIGURED_FEATURE);
        return registry.getResourceKey(configuredFeature);
    }

    @Override
    public Optional<ResourceKey<PlacedFeature>> getPlacedFeatureKey(PlacedFeature placedFeature) {
        Registry registry = this.registryAccess.registryOrThrow(Registries.PLACED_FEATURE);
        return registry.getResourceKey((Object)placedFeature);
    }

    @Override
    public boolean validForStructure(ResourceKey<Structure> key) {
        Structure instance = (Structure)this.registryAccess.registryOrThrow(Registries.STRUCTURE).get(key);
        return instance != null && instance.biomes().contains(this.holder());
    }

    @Override
    public Optional<ResourceKey<Structure>> getStructureKey(Structure structure) {
        Registry registry = this.registryAccess.registryOrThrow(Registries.STRUCTURE);
        return registry.getResourceKey((Object)structure);
    }

    @Override
    public boolean canGenerateIn(ResourceKey<LevelStem> dimensionKey) {
        LevelStem dimension = (LevelStem)this.registryAccess.registryOrThrow(Registries.LEVEL_STEM).get(dimensionKey);
        return dimension != null && dimension.generator().getBiomeSource().possibleBiomes().stream().anyMatch(entry -> entry.value() == this.getBiome());
    }

    @Override
    public boolean is(TagKey<Biome> tag) {
        Registry biomeRegistry = this.registryAccess.registryOrThrow(Registries.BIOME);
        return biomeRegistry.getHolderOrThrow(this.getResourceKey()).is(tag);
    }
}

