/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.api.core.v1;

import com.google.common.collect.ImmutableMap;
import fuzs.puzzleslib.api.core.v1.ModLoaderEnvironment;
import fuzs.puzzleslib.impl.PuzzlesLib;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

public interface ModContainer {
    public String getModId();

    public String getDisplayName();

    public String getDescription();

    public String getVersion();

    public Collection<String> getLicenses();

    public Collection<String> getAuthors();

    public Collection<String> getCredits();

    public Map<String, String> getContactTypes();

    public Optional<Path> findResource(String ... var1);

    public Collection<ModContainer> getChildren();

    default public Stream<ModContainer> getAllChildren() {
        return Stream.concat(Stream.of(this), this.getChildren().stream().flatMap(ModContainer::getAllChildren));
    }

    @Nullable
    public ModContainer getParent();

    public static String getDisplayName(String modId) {
        return ModLoaderEnvironment.INSTANCE.getModContainer(modId).map(ModContainer::getDisplayName).orElse(modId);
    }

    @ApiStatus.Internal
    public static Map<String, ModContainer> toModList(Supplier<Stream<? extends ModContainer>> modContainers) {
        try {
            return (Map)modContainers.get().sorted(Comparator.comparing(ModContainer::getModId)).collect(ImmutableMap.toImmutableMap(ModContainer::getModId, Function.identity()));
        }
        catch (Throwable throwable) {
            PuzzlesLib.LOGGER.warn("Failed to generate mod list", throwable);
            return Collections.emptyMap();
        }
    }
}

