/*
 * Decompiled with CFR 0.152.
 */
package dynamic_fps.impl.mixin;

import com.mojang.blaze3d.platform.Window;
import dynamic_fps.impl.DynamicFPSMod;
import dynamic_fps.impl.PowerState;
import dynamic_fps.impl.config.DynamicFPSConfig;
import dynamic_fps.impl.feature.state.IdleHandler;
import net.minecraft.client.Minecraft;
import net.minecraft.client.Options;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Minecraft.class})
public class MinecraftMixin {
    @Shadow
    @Final
    private Window window;
    @Shadow
    @Final
    public Options options;

    @Inject(method={"<init>(Lnet/minecraft/client/main/GameConfig;)V"}, at={@At(value="TAIL")})
    private void onInit(CallbackInfo callbackInfo) {
        DynamicFPSMod.setWindow(this.window.window);
    }

    @Inject(method={"setScreen(Lnet/minecraft/client/gui/screens/Screen;)V"}, at={@At(value="HEAD")})
    private void setScreen(CallbackInfo callbackInfo) {
        IdleHandler.onActivity();
    }

    @Inject(method={"getFramerateLimit()I"}, at={@At(value="CONSTANT", args={"intValue=60"})}, cancellable=true)
    private void getFramerateLimit(CallbackInfoReturnable<Integer> callbackInfo) {
        int limit = this.window.getFramerateLimit();
        if (DynamicFPSMod.powerState() != PowerState.FOCUSED) {
            if (limit < 60) {
                callbackInfo.setReturnValue((Object)limit);
            }
        } else if (DynamicFPSConfig.INSTANCE.uncapMenuFrameRate()) {
            if (((Boolean)this.options.enableVsync().get()).booleanValue()) {
                callbackInfo.setReturnValue((Object)260);
            } else {
                callbackInfo.setReturnValue((Object)Math.min(limit, 250));
            }
        }
    }
}

