/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.util;

import java.util.HashMap;
import java.util.Map;
import net.geforcemods.securitycraft.blockentities.AlarmBlockEntity;
import net.geforcemods.securitycraft.misc.SCSounds;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.core.Holder;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.event.EventHooks;
import net.neoforged.neoforge.event.PlayLevelSoundEvent;

public final class AlarmSoundHandler {
    private static final Map<AlarmBlockEntity, SoundInstance> SOUND_STORAGE = new HashMap<AlarmBlockEntity, SoundInstance>();

    private AlarmSoundHandler() {
    }

    public static void playSound(AlarmBlockEntity be, Level level, double x, double y, double z, Holder<SoundEvent> sound, SoundSource source, float volume, float pitch, long seed) {
        SoundManager soundManager;
        PlayLevelSoundEvent.AtPosition event = EventHooks.onPlaySoundAtPosition((Level)level, (double)x, (double)y, (double)z, sound, (SoundSource)source, (float)volume, (float)pitch);
        if (event.isCanceled() || event.getSound() == null) {
            return;
        }
        SimpleSoundInstance soundInstance = new SimpleSoundInstance((SoundEvent)event.getSound().value(), event.getSource(), event.getNewVolume(), event.getNewPitch(), RandomSource.create((long)seed), x, y, z);
        if (soundInstance.resolve(soundManager = Minecraft.getInstance().getSoundManager()) == null) {
            soundInstance = new SimpleSoundInstance(SCSounds.ALARM.event, event.getSource(), event.getNewVolume(), event.getNewPitch(), RandomSource.create((long)seed), x, y, z);
        }
        AlarmSoundHandler.stopCurrentSound(be);
        soundManager.play((SoundInstance)soundInstance);
        SOUND_STORAGE.put(be, (SoundInstance)soundInstance);
    }

    public static void stopCurrentSound(AlarmBlockEntity be) {
        SoundInstance soundInstance = SOUND_STORAGE.remove(be);
        if (soundInstance != null) {
            Minecraft.getInstance().getSoundManager().stop(soundInstance);
        }
    }
}

