/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.renderers;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.geforcemods.securitycraft.blockentities.BlockPocketManagerBlockEntity;
import net.geforcemods.securitycraft.blocks.BlockPocketManagerBlock;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.Direction;
import net.minecraft.util.FastColor;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;

public class BlockPocketManagerRenderer
implements BlockEntityRenderer<BlockPocketManagerBlockEntity> {
    public static final int RENDER_DISTANCE = 100;

    public BlockPocketManagerRenderer(BlockEntityRendererProvider.Context ctx) {
    }

    public void render(BlockPocketManagerBlockEntity be, float partialTicks, PoseStack pose, MultiBufferSource buffer, int combinedLight, int combinedOverlay) {
        if (!be.showsOutline() || !be.isOwnedBy((Entity)Minecraft.getInstance().player)) {
            return;
        }
        Direction facing = (Direction)be.getBlockState().getValue((Property)BlockPocketManagerBlock.FACING);
        int offset = facing == Direction.NORTH || facing == Direction.EAST ? -be.getAutoBuildOffset() : be.getAutoBuildOffset();
        int size = be.getSize();
        int half = (size - 1) / 2;
        int leftX = -half + offset;
        int rightX = half + 1 + offset;
        int frontZ = facing == Direction.NORTH || facing == Direction.WEST ? 0 : 1;
        int backZ = facing == Direction.NORTH || facing == Direction.WEST ? size : 1 - size;
        int packedColor = be.getColor();
        float r = (float)FastColor.ARGB32.red((int)packedColor) / 255.0f;
        float g = (float)FastColor.ARGB32.green((int)packedColor) / 255.0f;
        float b = (float)FastColor.ARGB32.blue((int)packedColor) / 255.0f;
        if (facing == Direction.EAST || facing == Direction.WEST) {
            leftX = frontZ;
            rightX = backZ;
            frontZ = -half + offset;
            backZ = half + 1 + offset;
        }
        LevelRenderer.renderLineBox((PoseStack)pose, (VertexConsumer)buffer.getBuffer(RenderType.lines()), (double)leftX, (double)0.0, (double)frontZ, (double)rightX, (double)size, (double)backZ, (float)r, (float)g, (float)b, (float)1.0f);
    }

    public boolean shouldRenderOffScreen(BlockPocketManagerBlockEntity be) {
        return be.showsOutline();
    }

    public AABB getRenderBoundingBox(BlockPocketManagerBlockEntity be) {
        return new AABB(be.getBlockPos()).inflate(100.0);
    }
}

