/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.network.client;

import net.geforcemods.securitycraft.SecurityCraft;
import net.geforcemods.securitycraft.blockentities.TrophySystemBlockEntity;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record SetTrophySystemTarget(BlockPos pos, int targetID) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<SetTrophySystemTarget> TYPE = new CustomPacketPayload.Type(SecurityCraft.resLoc("set_trophy_system_target"));
    public static final StreamCodec<RegistryFriendlyByteBuf, SetTrophySystemTarget> STREAM_CODEC = StreamCodec.composite((StreamCodec)BlockPos.STREAM_CODEC, SetTrophySystemTarget::pos, (StreamCodec)ByteBufCodecs.VAR_INT, SetTrophySystemTarget::targetID, SetTrophySystemTarget::new);

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public void handle(IPayloadContext ctx) {
        BlockEntity blockEntity = ctx.player().level().getBlockEntity(this.pos);
        if (blockEntity instanceof TrophySystemBlockEntity) {
            TrophySystemBlockEntity be = (TrophySystemBlockEntity)blockEntity;
            Entity entity = Minecraft.getInstance().level.getEntity(this.targetID);
            if (entity instanceof Projectile) {
                Projectile projectile = (Projectile)entity;
                be.setTarget(projectile);
            }
        }
    }
}

