/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.network.client;

import net.geforcemods.securitycraft.ClientHandler;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.SecurityCraft;
import net.geforcemods.securitycraft.api.IPasscodeProtected;
import net.geforcemods.securitycraft.blockentities.AlarmBlockEntity;
import net.geforcemods.securitycraft.blockentities.RiftStabilizerBlockEntity;
import net.geforcemods.securitycraft.blockentities.SecureRedstoneInterfaceBlockEntity;
import net.geforcemods.securitycraft.blockentities.SonicSecuritySystemBlockEntity;
import net.geforcemods.securitycraft.blockentities.UsernameLoggerBlockEntity;
import net.geforcemods.securitycraft.util.PlayerUtils;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.core.BlockPos;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public class OpenScreen
implements CustomPacketPayload {
    public static final CustomPacketPayload.Type<OpenScreen> TYPE = new CustomPacketPayload.Type(SecurityCraft.resLoc("open_screen"));
    public static final StreamCodec<RegistryFriendlyByteBuf, OpenScreen> STREAM_CODEC = new StreamCodec<RegistryFriendlyByteBuf, OpenScreen>(){

        public OpenScreen decode(RegistryFriendlyByteBuf buf) {
            DataType dataType = (DataType)buf.readEnum(DataType.class);
            if (dataType.needsPosition) {
                return new OpenScreen(dataType, buf.readBlockPos());
            }
            if (dataType == DataType.CHANGE_PASSCODE_FOR_ENTITY || dataType == DataType.CHECK_PASSCODE_FOR_ENTITY || dataType == DataType.SET_PASSCODE_FOR_ENTITY) {
                return new OpenScreen(dataType, buf.readVarInt());
            }
            return new OpenScreen(dataType);
        }

        public void encode(RegistryFriendlyByteBuf buf, OpenScreen packet) {
            buf.writeEnum((Enum)packet.dataType);
            if (packet.dataType.needsPosition) {
                buf.writeBlockPos(packet.pos);
            } else if (packet.dataType == DataType.CHANGE_PASSCODE_FOR_ENTITY || packet.dataType == DataType.CHECK_PASSCODE_FOR_ENTITY || packet.dataType == DataType.SET_PASSCODE_FOR_ENTITY) {
                buf.writeVarInt(packet.entityId);
            }
        }
    };
    private DataType dataType;
    private BlockPos pos;
    private int entityId;

    public OpenScreen() {
    }

    public OpenScreen(DataType dataType) {
        this.dataType = dataType;
        if (dataType.needsPosition) {
            throw new IllegalArgumentException(String.format("The DataType %s needs a position, but none was supplied.", dataType.name()));
        }
    }

    public OpenScreen(DataType dataType, int entityId) {
        this.dataType = dataType;
        this.entityId = entityId;
    }

    public OpenScreen(DataType dataType, BlockPos pos) {
        this.dataType = dataType;
        this.pos = pos;
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public void handle(IPayloadContext ctx) {
        Player player = ctx.player();
        Level level = player.level();
        switch (this.dataType.ordinal()) {
            case 0: {
                BlockEntity blockEntity = level.getBlockEntity(this.pos);
                if (!(blockEntity instanceof AlarmBlockEntity)) break;
                AlarmBlockEntity be = (AlarmBlockEntity)blockEntity;
                ClientHandler.displayAlarmScreen(be);
                break;
            }
            case 1: {
                BlockEntity blockEntity = level.getBlockEntity(this.pos);
                if (!(blockEntity instanceof IPasscodeProtected)) break;
                IPasscodeProtected passcodeProtected = (IPasscodeProtected)blockEntity;
                ClientHandler.displayUniversalKeyChangerScreen((BlockEntity)passcodeProtected);
                break;
            }
            case 2: {
                Entity entity = level.getEntity(this.entityId);
                if (!(entity instanceof IPasscodeProtected)) break;
                IPasscodeProtected entity2 = (IPasscodeProtected)entity;
                ClientHandler.displayUniversalKeyChangerScreen((Entity)entity2);
                break;
            }
            case 3: {
                BlockEntity blockEntity = level.getBlockEntity(this.pos);
                if (!(blockEntity instanceof IPasscodeProtected)) break;
                IPasscodeProtected be = (IPasscodeProtected)blockEntity;
                ClientHandler.displayCheckPasscodeScreen((BlockEntity)be);
                break;
            }
            case 4: {
                ItemStack briefcaseStack = PlayerUtils.getItemStackFromAnyHand(player, (Item)SCContent.BRIEFCASE.get());
                if (briefcaseStack.isEmpty()) break;
                ClientHandler.displayBriefcasePasscodeScreen(briefcaseStack.getHoverName());
                break;
            }
            case 5: {
                Entity entity = level.getEntity(this.entityId);
                if (!(entity instanceof IPasscodeProtected)) break;
                IPasscodeProtected entity3 = (IPasscodeProtected)entity;
                ClientHandler.displayCheckPasscodeScreen((Entity)entity3);
                break;
            }
            case 6: {
                BlockEntity blockEntity = level.getBlockEntity(this.pos);
                if (!(blockEntity instanceof RiftStabilizerBlockEntity)) break;
                RiftStabilizerBlockEntity riftStabilizer = (RiftStabilizerBlockEntity)blockEntity;
                ClientHandler.displayRiftStabilizerScreen(riftStabilizer);
                break;
            }
            case 8: {
                BlockEntity blockEntity = level.getBlockEntity(this.pos);
                if (!(blockEntity instanceof SecureRedstoneInterfaceBlockEntity)) break;
                SecureRedstoneInterfaceBlockEntity secureRedstoneInterface = (SecureRedstoneInterfaceBlockEntity)blockEntity;
                ClientHandler.displaySecureRedstoneInterfaceScreen(secureRedstoneInterface);
                break;
            }
            case 7: {
                ItemStack srat = PlayerUtils.getItemStackFromAnyHand(player, (Item)SCContent.SENTRY_REMOTE_ACCESS_TOOL.get());
                if (srat.isEmpty()) break;
                ClientHandler.displaySRATScreen(srat);
                break;
            }
            case 9: {
                BlockEntity blockEntity = level.getBlockEntity(this.pos);
                if (!(blockEntity instanceof IPasscodeProtected)) break;
                IPasscodeProtected be = (IPasscodeProtected)blockEntity;
                ClientHandler.displaySetPasscodeScreen((BlockEntity)be);
                break;
            }
            case 10: {
                ItemStack briefcase = PlayerUtils.getItemStackFromAnyHand(player, (Item)SCContent.BRIEFCASE.get());
                if (briefcase.isEmpty()) break;
                ClientHandler.displayBriefcaseSetupScreen((Component)briefcase.getHoverName().plainCopy().append((Component)Component.literal((String)" ")).append((Component)Utils.localize("gui.securitycraft:passcode.setup", new Object[0])));
                break;
            }
            case 11: {
                Entity entity = level.getEntity(this.entityId);
                if (!(entity instanceof IPasscodeProtected)) break;
                IPasscodeProtected entity4 = (IPasscodeProtected)entity;
                ClientHandler.displaySetPasscodeScreen((Entity)entity4);
                break;
            }
            case 12: {
                BlockEntity blockEntity = level.getBlockEntity(this.pos);
                if (!(blockEntity instanceof SonicSecuritySystemBlockEntity)) break;
                SonicSecuritySystemBlockEntity sss = (SonicSecuritySystemBlockEntity)blockEntity;
                ClientHandler.displaySonicSecuritySystemScreen(sss);
                break;
            }
            case 13: {
                BlockEntity blockEntity = level.getBlockEntity(this.pos);
                if (!(blockEntity instanceof UsernameLoggerBlockEntity)) break;
                UsernameLoggerBlockEntity logger = (UsernameLoggerBlockEntity)blockEntity;
                ClientHandler.displayUsernameLoggerScreen(logger);
                break;
            }
            default: {
                throw new IllegalStateException("Unhandled data type: " + this.dataType.name());
            }
        }
    }

    public static enum DataType {
        ALARM(true),
        CHANGE_PASSCODE(true),
        CHANGE_PASSCODE_FOR_ENTITY(false),
        CHECK_PASSCODE(true),
        CHECK_PASSCODE_FOR_BRIEFCASE(false),
        CHECK_PASSCODE_FOR_ENTITY(false),
        RIFT_STABILIZER(true),
        SENTRY_REMOTE_ACCESS_TOOL(false),
        SECURE_REDSTONE_INTERFACE(true),
        SET_PASSCODE(true),
        SET_PASSCODE_FOR_BRIEFCASE(false),
        SET_PASSCODE_FOR_ENTITY(false),
        SONIC_SECURITY_SYSTEM(true),
        USERNAME_LOGGER(true);

        public final boolean needsPosition;

        private DataType(boolean needsPosition) {
            this.needsPosition = needsPosition;
        }
    }
}

