/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.network.client;

import net.geforcemods.securitycraft.ClientHandler;
import net.geforcemods.securitycraft.SecurityCraft;
import net.geforcemods.securitycraft.blockentities.FrameBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record InteractWithFrame(BlockPos pos, boolean owner) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<InteractWithFrame> TYPE = new CustomPacketPayload.Type(SecurityCraft.resLoc("interact_with_frame"));
    public static final StreamCodec<RegistryFriendlyByteBuf, InteractWithFrame> STREAM_CODEC = StreamCodec.composite((StreamCodec)BlockPos.STREAM_CODEC, InteractWithFrame::pos, (StreamCodec)ByteBufCodecs.BOOL, InteractWithFrame::owner, InteractWithFrame::new);

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public void handle(IPayloadContext ctx) {
        Level level = ctx.player().level();
        BlockEntity blockEntity = level.getBlockEntity(this.pos);
        if (blockEntity instanceof FrameBlockEntity) {
            FrameBlockEntity be = (FrameBlockEntity)blockEntity;
            if (!be.redstoneSignalDisabled() && !be.hasClientInteracted() && be.getCurrentCamera() != null) {
                be.setCameraOnClientAndUpdate(be.getCurrentCamera());
            } else {
                ClientHandler.displayFrameScreen(be, !this.owner);
            }
        }
    }
}

