/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.inventory;

import java.util.Map;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.blockentities.LaserBlockBlockEntity;
import net.geforcemods.securitycraft.inventory.LensContainer;
import net.geforcemods.securitycraft.inventory.LensSlot;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;

public class LaserBlockMenu
extends AbstractContainerMenu {
    public final LaserBlockBlockEntity be;
    public final Map<Direction, Boolean> sideConfig;
    private ContainerLevelAccess containerLevelAccess;

    public LaserBlockMenu(int windowId, Level level, BlockPos pos, Map<Direction, Boolean> sideConfig, Inventory inventory) {
        super((MenuType)SCContent.LASER_BLOCK_MENU.get(), windowId);
        this.containerLevelAccess = ContainerLevelAccess.create((Level)level, (BlockPos)pos);
        this.be = (LaserBlockBlockEntity)level.getBlockEntity(pos);
        this.sideConfig = sideConfig;
        if (this.be.isOwnedBy((Entity)inventory.player)) {
            LensContainer container = this.be.getLensContainer();
            for (int i = 0; i < 6; ++i) {
                this.addSlot(new LensSlot((Container)container, i, 15, i * 22 + 27));
            }
        }
        for (int y = 0; y < 3; ++y) {
            for (int x = 0; x < 9; ++x) {
                this.addSlot(new Slot((Container)inventory, x + y * 9 + 9, 8 + x * 18, 174 + y * 18));
            }
        }
        for (int x = 0; x < 9; ++x) {
            this.addSlot(new Slot((Container)inventory, x, 8 + x * 18, 232));
        }
    }

    public ItemStack quickMoveStack(Player player, int index) {
        ItemStack slotStackCopy = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(index);
        if (slot.hasItem()) {
            ItemStack slotStack = slot.getItem();
            slotStackCopy = slotStack.copy();
            if (index < 6) {
                if (!this.moveItemStackTo(slotStack, 6, 42, true)) {
                    return ItemStack.EMPTY;
                }
                slot.onQuickCraft(slotStack, slotStackCopy);
            } else if (!this.moveItemStackTo(slotStack, 0, 6, false)) {
                return ItemStack.EMPTY;
            }
            if (slotStack.getCount() == 0) {
                slot.set(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
            if (slotStack.getCount() == slotStackCopy.getCount()) {
                return ItemStack.EMPTY;
            }
            slot.onTake(player, slotStack);
            this.broadcastChanges();
        }
        return slotStackCopy;
    }

    public boolean stillValid(Player player) {
        return LaserBlockMenu.stillValid((ContainerLevelAccess)this.containerLevelAccess, (Player)player, (Block)this.be.getBlockState().getBlock());
    }
}

