/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.inventory;

import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.blockentities.BlockPocketManagerBlockEntity;
import net.geforcemods.securitycraft.misc.ModuleType;
import net.minecraft.core.BlockPos;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.SlotItemHandler;

public class BlockPocketManagerMenu
extends AbstractContainerMenu {
    public final BlockPocketManagerBlockEntity be;
    private ContainerLevelAccess worldPosCallable;
    public final boolean hasStorageModule;
    public final boolean isOwner;

    public BlockPocketManagerMenu(int windowId, Level level, BlockPos pos, Inventory inventory) {
        super((MenuType)SCContent.BLOCK_POCKET_MANAGER_MENU.get(), windowId);
        this.be = (BlockPocketManagerBlockEntity)level.getBlockEntity(pos);
        this.worldPosCallable = ContainerLevelAccess.create((Level)level, (BlockPos)pos);
        this.isOwner = this.be.isOwnedBy((Entity)inventory.player);
        boolean bl = this.hasStorageModule = this.be.isModuleEnabled(ModuleType.STORAGE) && this.isOwner;
        if (this.hasStorageModule) {
            for (int y = 0; y < 3; ++y) {
                for (int x = 0; x < 9; ++x) {
                    this.addSlot(new Slot((Container)inventory, x + y * 9 + 9, 8 + x * 18, 84 + y * 18 + 74));
                }
            }
            for (int x = 0; x < 9; ++x) {
                this.addSlot(new Slot((Container)inventory, x, 8 + x * 18, 216));
            }
            BlockPocketManagerBlockEntity.ValidityCheckItemStackHandler handler = new BlockPocketManagerBlockEntity.ValidityCheckItemStackHandler(this.be.getStorage());
            int slotId = 0;
            for (int y = 0; y < 8; ++y) {
                for (int x = 0; x < 7; ++x) {
                    this.addSlot((Slot)new SlotItemHandler(this, (IItemHandler)handler, slotId++, 124 + x * 18, 8 + y * 18){

                        public void initialize(ItemStack stack) {
                            this.set(stack);
                        }
                    });
                }
            }
        }
    }

    public void removed(Player player) {
        super.removed(player);
        this.be.setChanged();
    }

    public ItemStack quickMoveStack(Player player, int index) {
        ItemStack copy = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(index);
        if (slot.hasItem()) {
            ItemStack slotStack = slot.getItem();
            copy = slotStack.copy();
            if (index >= 36 ? !this.moveItemStackTo(slotStack, 0, 36, true) : index >= 0 && index <= 35 && !this.moveItemStackTo(slotStack, 36, this.slots.size(), false)) {
                return ItemStack.EMPTY;
            }
            if (slotStack.isEmpty()) {
                slot.set(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
        }
        return copy;
    }

    public boolean stillValid(Player player) {
        return BlockPocketManagerMenu.stillValid((ContainerLevelAccess)this.worldPosCallable, (Player)player, (Block)((Block)SCContent.BLOCK_POCKET_MANAGER.get()));
    }
}

