/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blocks.reinforced;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.api.IOwnable;
import net.geforcemods.securitycraft.api.IReinforcedBlock;
import net.geforcemods.securitycraft.api.OwnableBlockEntity;
import net.geforcemods.securitycraft.blockentities.ReinforcedPistonMovingBlockEntity;
import net.geforcemods.securitycraft.blockentities.ValidationOwnableBlockEntity;
import net.geforcemods.securitycraft.blocks.ElectrifiedIronFenceBlock;
import net.geforcemods.securitycraft.blocks.ElectrifiedIronFenceGateBlock;
import net.geforcemods.securitycraft.blocks.OwnableBlock;
import net.geforcemods.securitycraft.blocks.reinforced.ReinforcedMovingPistonBlock;
import net.geforcemods.securitycraft.blocks.reinforced.ReinforcedPistonHeadBlock;
import net.geforcemods.securitycraft.misc.OwnershipEvent;
import net.geforcemods.securitycraft.util.BlockUtils;
import net.geforcemods.securitycraft.util.ReinforcedPistonStructureResolver;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.piston.MovingPistonBlock;
import net.minecraft.world.level.block.piston.PistonBaseBlock;
import net.minecraft.world.level.block.piston.PistonHeadBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.PistonType;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.PushReaction;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.EventHooks;

public class ReinforcedPistonBaseBlock
extends PistonBaseBlock
implements IReinforcedBlock,
EntityBlock {
    private final float destroyTimeForOwner = OwnableBlock.getStoredDestroyTime();

    public ReinforcedPistonBaseBlock(boolean sticky, BlockBehaviour.Properties properties) {
        super(sticky, OwnableBlock.withReinforcedDestroyTime(properties));
    }

    public float getDestroyProgress(BlockState state, Player player, BlockGetter level, BlockPos pos) {
        return BlockUtils.getDestroyProgress((x$0, x$1, x$2, x$3) -> super.getDestroyProgress(x$0, x$1, x$2, x$3), this.destroyTimeForOwner, state, player, level, pos);
    }

    public void setPlacedBy(Level level, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        if (placer instanceof Player) {
            Player player = (Player)placer;
            NeoForge.EVENT_BUS.post((Event)new OwnershipEvent(level, pos, player));
        }
        super.setPlacedBy(level, pos, state, placer, stack);
    }

    protected void onPlace(BlockState state, Level level, BlockPos pos, BlockState oldState, boolean isMoving) {
        if (!oldState.is(state.getBlock()) && !level.isClientSide && level.getBlockEntity(pos) instanceof ValidationOwnableBlockEntity) {
            this.checkIfExtend(level, pos, state);
        }
    }

    public void checkIfExtend(Level level, BlockPos pos, BlockState state) {
        OwnableBlockEntity be;
        Direction direction = (Direction)state.getValue((Property)FACING);
        boolean hasSignal = this.getNeighborSignal(level, pos, direction);
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof OwnableBlockEntity && !(be = (OwnableBlockEntity)blockEntity).getOwner().isValidated()) {
            return;
        }
        if (hasSignal && !((Boolean)state.getValue((Property)EXTENDED)).booleanValue()) {
            if (new ReinforcedPistonStructureResolver(level, pos, direction, true).resolve()) {
                level.blockEvent(pos, (Block)this, 0, direction.get3DDataValue());
            }
        } else if (!hasSignal && ((Boolean)state.getValue((Property)EXTENDED)).booleanValue()) {
            ReinforcedPistonMovingBlockEntity pistonTileEntity;
            BlockEntity blockEntity2;
            BlockPos offsetPos = pos.relative(direction, 2);
            BlockState offsetState = level.getBlockState(offsetPos);
            int i = 1;
            if (offsetState.is((Block)SCContent.REINFORCED_MOVING_PISTON.get()) && offsetState.getValue((Property)FACING) == direction && (blockEntity2 = level.getBlockEntity(offsetPos)) instanceof ReinforcedPistonMovingBlockEntity && (pistonTileEntity = (ReinforcedPistonMovingBlockEntity)blockEntity2).isExtending() && (pistonTileEntity.getProgress(0.0f) < 0.5f || level.getGameTime() == pistonTileEntity.getLastTicked() || ((ServerLevel)level).isHandlingTick())) {
                i = 2;
            }
            level.blockEvent(pos, (Block)this, i, direction.get3DDataValue());
        }
    }

    private boolean getNeighborSignal(Level level, BlockPos pos, Direction direction) {
        for (Direction dir : Direction.values()) {
            if (dir == direction || !level.hasSignal(pos.relative(dir), dir)) continue;
            return true;
        }
        if (level.hasSignal(pos, Direction.DOWN)) {
            return true;
        }
        BlockPos posAbove = pos.above();
        for (Direction dir : Direction.values()) {
            if (dir == Direction.DOWN || !level.hasSignal(posAbove.relative(dir), dir)) continue;
            return true;
        }
        return false;
    }

    public boolean triggerEvent(BlockState state, Level level, BlockPos pos, int id, int param) {
        Direction direction = (Direction)state.getValue((Property)FACING);
        BlockState extendedState = (BlockState)state.setValue((Property)EXTENDED, (Comparable)Boolean.valueOf(true));
        if (!level.isClientSide) {
            boolean isPowered = this.getNeighborSignal(level, pos, direction);
            if (isPowered && (id == 1 || id == 2)) {
                level.setBlock(pos, extendedState, 2);
                return false;
            }
            if (!isPowered && id == 0) {
                return false;
            }
        }
        if (id == 0) {
            if (EventHooks.onPistonMovePre((Level)level, (BlockPos)pos, (Direction)direction, (boolean)true)) {
                return false;
            }
            if (!this.moveBlocks(level, pos, direction, true)) {
                return false;
            }
            level.setBlock(pos, extendedState, 67);
            level.playSound(null, pos, SoundEvents.PISTON_EXTEND, SoundSource.BLOCKS, 0.5f, level.random.nextFloat() * 0.25f + 0.6f);
            level.gameEvent((Holder)GameEvent.BLOCK_ACTIVATE, pos, GameEvent.Context.of((BlockState)extendedState));
        } else if (id == 1 || id == 2) {
            if (EventHooks.onPistonMovePre((Level)level, (BlockPos)pos, (Direction)direction, (boolean)false)) {
                return false;
            }
            BlockEntity blockEntity = level.getBlockEntity(pos.relative(direction));
            if (blockEntity instanceof ReinforcedPistonMovingBlockEntity) {
                ReinforcedPistonMovingBlockEntity pistonBe = (ReinforcedPistonMovingBlockEntity)blockEntity;
                pistonBe.finalTick();
            }
            BlockEntity be = level.getBlockEntity(pos);
            BlockState movingPiston = (BlockState)((BlockState)((ReinforcedMovingPistonBlock)((Object)SCContent.REINFORCED_MOVING_PISTON.get())).defaultBlockState().setValue((Property)FACING, (Comparable)direction)).setValue((Property)MovingPistonBlock.TYPE, (Comparable)(this.isSticky ? PistonType.STICKY : PistonType.DEFAULT));
            level.setBlock(pos, movingPiston, 20);
            level.setBlockEntity(ReinforcedMovingPistonBlock.newMovingBlockEntity(pos, movingPiston, (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)Direction.from3DDataValue((int)(param & 7))), be != null ? be.getUpdateTag((HolderLookup.Provider)level.registryAccess()) : null, direction, false, true));
            level.blockUpdated(pos, movingPiston.getBlock());
            movingPiston.updateNeighbourShapes((LevelAccessor)level, pos, 2);
            if (this.isSticky) {
                ReinforcedPistonMovingBlockEntity pistonBe;
                BlockEntity blockEntity2;
                BlockPos offsetPos = pos.offset(direction.getStepX() * 2, direction.getStepY() * 2, direction.getStepZ() * 2);
                BlockState offsetState = level.getBlockState(offsetPos);
                boolean flag = false;
                if (offsetState.is((Block)SCContent.REINFORCED_MOVING_PISTON.get()) && (blockEntity2 = level.getBlockEntity(offsetPos)) instanceof ReinforcedPistonMovingBlockEntity && (pistonBe = (ReinforcedPistonMovingBlockEntity)blockEntity2).getFacing() == direction && pistonBe.isExtending()) {
                    pistonBe.finalTick();
                    flag = true;
                }
                if (!flag) {
                    if (id != 1 || offsetState.isAir() || !ReinforcedPistonBaseBlock.isPushable(offsetState, level, pos, offsetPos, direction.getOpposite(), false, direction) || offsetState.getPistonPushReaction() != PushReaction.NORMAL && !offsetState.is((Block)SCContent.REINFORCED_PISTON.get()) && !offsetState.is((Block)SCContent.REINFORCED_STICKY_PISTON.get())) {
                        level.removeBlock(pos.relative(direction), false);
                    } else {
                        this.moveBlocks(level, pos, direction, false);
                    }
                }
            } else {
                level.removeBlock(pos.relative(direction), false);
            }
            level.playSound(null, pos, SoundEvents.PISTON_CONTRACT, SoundSource.BLOCKS, 0.5f, level.random.nextFloat() * 0.15f + 0.6f);
            level.gameEvent((Holder)GameEvent.BLOCK_DEACTIVATE, pos, GameEvent.Context.of((BlockState)movingPiston));
        }
        EventHooks.onPistonMovePost((Level)level, (BlockPos)pos, (Direction)direction, (id == 0 ? 1 : 0) != 0);
        return true;
    }

    public static boolean isPushable(BlockState state, Level level, BlockPos pistonPos, BlockPos pos, Direction facing, boolean destroyBlocks, Direction direction) {
        if (pos.getY() >= level.getMinBuildHeight() && pos.getY() <= level.getMaxBuildHeight() - 1 && level.getWorldBorder().isWithinBounds(pos)) {
            if (state.isAir()) {
                return true;
            }
            if (!(state.is(Blocks.OBSIDIAN) || state.is(Blocks.CRYING_OBSIDIAN) || state.is(Blocks.RESPAWN_ANCHOR) || state.is(Blocks.REINFORCED_DEEPSLATE) || state.is((Block)SCContent.REINFORCED_OBSIDIAN.get()) || state.is((Block)SCContent.REINFORCED_CRYING_OBSIDIAN.get()))) {
                boolean isPushableSCBlock;
                if (facing == Direction.DOWN && pos.getY() == level.getMinBuildHeight() || facing == Direction.UP && pos.getY() == level.getMaxBuildHeight() - 1) {
                    return false;
                }
                boolean bl = isPushableSCBlock = state.getBlock() instanceof IReinforcedBlock || state.getBlock() instanceof ElectrifiedIronFenceBlock || state.getBlock() instanceof ElectrifiedIronFenceGateBlock;
                if (!(state.is(Blocks.PISTON) || state.is(Blocks.STICKY_PISTON) || state.is((Block)SCContent.REINFORCED_PISTON.get()) || state.is((Block)SCContent.REINFORCED_STICKY_PISTON.get()))) {
                    if (isPushableSCBlock ? !ReinforcedPistonBaseBlock.isSameOwner(pos, pistonPos, level) : state.getDestroySpeed((BlockGetter)level, pos) == -1.0f) {
                        return false;
                    }
                    switch (state.getPistonPushReaction()) {
                        case BLOCK: {
                            return false;
                        }
                        case DESTROY: {
                            return destroyBlocks;
                        }
                        case PUSH_ONLY: {
                            return facing == direction;
                        }
                    }
                } else if (((Boolean)state.getValue((Property)EXTENDED)).booleanValue()) {
                    return false;
                }
                return !state.hasBlockEntity() || isPushableSCBlock;
            }
        }
        return false;
    }

    private boolean moveBlocks(Level level, BlockPos pos, Direction facing, boolean extending) {
        ReinforcedPistonStructureResolver structureResolver;
        BlockPos frontPos = pos.relative(facing);
        BlockEntity pistonBe = level.getBlockEntity(pos);
        if (!extending && level.getBlockState(frontPos).is((Block)SCContent.REINFORCED_PISTON_HEAD.get())) {
            level.setBlock(frontPos, Blocks.AIR.defaultBlockState(), 20);
        }
        if (!(structureResolver = new ReinforcedPistonStructureResolver(level, pos, facing, extending)).resolve()) {
            return false;
        }
        HashMap stateToPosMap = Maps.newHashMap();
        List<BlockPos> blocksToMove = structureResolver.getToPush();
        ArrayList statesToMove = Lists.newArrayList();
        for (int i = 0; i < blocksToMove.size(); ++i) {
            BlockPos posToMove = blocksToMove.get(i);
            BlockState stateToMove = level.getBlockState(posToMove);
            statesToMove.add(stateToMove);
            stateToPosMap.put(posToMove, stateToMove);
        }
        List<BlockPos> blocksToDestroy = structureResolver.getToDestroy();
        BlockState[] updatedBlocks = new BlockState[blocksToMove.size() + blocksToDestroy.size()];
        Direction direction = extending ? facing : facing.getOpposite();
        int j = 0;
        for (int k = blocksToDestroy.size() - 1; k >= 0; --k) {
            BlockPos posToDestroy = blocksToDestroy.get(k);
            BlockState blockState = level.getBlockState(posToDestroy);
            BlockEntity beToDestroy = blockState.hasBlockEntity() ? level.getBlockEntity(posToDestroy) : null;
            ReinforcedPistonBaseBlock.dropResources((BlockState)blockState, (LevelAccessor)level, (BlockPos)posToDestroy, (BlockEntity)beToDestroy);
            level.setBlock(posToDestroy, Blocks.AIR.defaultBlockState(), 18);
            level.gameEvent((Holder)GameEvent.BLOCK_DESTROY, posToDestroy, GameEvent.Context.of((BlockState)blockState));
            if (!blockState.is(BlockTags.FIRE)) {
                level.addDestroyBlockEffect(posToDestroy, blockState);
            }
            updatedBlocks[j++] = blockState;
        }
        for (int l = blocksToMove.size() - 1; l >= 0; --l) {
            BlockPos posToMove = blocksToMove.get(l);
            BlockState blockState = level.getBlockState(posToMove);
            BlockState movingPiston = (BlockState)((ReinforcedMovingPistonBlock)((Object)SCContent.REINFORCED_MOVING_PISTON.get())).defaultBlockState().setValue((Property)FACING, (Comparable)direction);
            BlockEntity beToMove = level.getBlockEntity(posToMove);
            CompoundTag tag = null;
            posToMove = posToMove.relative(direction);
            if (beToMove != null) {
                tag = beToMove.saveWithoutMetadata((HolderLookup.Provider)level.registryAccess());
                tag.putInt("x", posToMove.getX());
                tag.putInt("y", posToMove.getY());
                tag.putInt("z", posToMove.getZ());
            }
            stateToPosMap.remove(posToMove);
            level.setBlock(posToMove, (BlockState)((ReinforcedMovingPistonBlock)((Object)SCContent.REINFORCED_MOVING_PISTON.get())).defaultBlockState().setValue((Property)FACING, (Comparable)facing), 68);
            level.setBlockEntity(ReinforcedMovingPistonBlock.newMovingBlockEntity(posToMove, movingPiston, (BlockState)statesToMove.get(l), tag, facing, extending, false));
            updatedBlocks[j++] = blockState;
        }
        if (extending) {
            PistonType type = this.isSticky ? PistonType.STICKY : PistonType.DEFAULT;
            Iterator<Object> pistonHead = (BlockState)((BlockState)((ReinforcedPistonHeadBlock)SCContent.REINFORCED_PISTON_HEAD.get()).defaultBlockState().setValue((Property)FACING, (Comparable)facing)).setValue((Property)PistonHeadBlock.TYPE, (Comparable)type);
            BlockState blockState = (BlockState)((BlockState)((ReinforcedMovingPistonBlock)((Object)SCContent.REINFORCED_MOVING_PISTON.get())).defaultBlockState().setValue((Property)MovingPistonBlock.FACING, (Comparable)facing)).setValue((Property)MovingPistonBlock.TYPE, (Comparable)(this.isSticky ? PistonType.STICKY : PistonType.DEFAULT));
            OwnableBlockEntity headBe = new OwnableBlockEntity(frontPos, blockState);
            if (pistonBe instanceof OwnableBlockEntity) {
                OwnableBlockEntity ownable = (OwnableBlockEntity)pistonBe;
                headBe.setOwner(ownable.getOwner().getUUID(), ownable.getOwner().getName());
            }
            stateToPosMap.remove(frontPos);
            level.setBlock(frontPos, blockState, 68);
            level.setBlockEntity(ReinforcedMovingPistonBlock.newMovingBlockEntity(frontPos, blockState, pistonHead, headBe.getUpdateTag((HolderLookup.Provider)level.registryAccess()), facing, true, true));
        }
        BlockState air = Blocks.AIR.defaultBlockState();
        for (BlockPos blockPos : stateToPosMap.keySet()) {
            level.setBlock(blockPos, air, 82);
        }
        for (Map.Entry entry : stateToPosMap.entrySet()) {
            BlockPos posToUpdate = (BlockPos)entry.getKey();
            BlockState stateToUpdate = (BlockState)entry.getValue();
            stateToUpdate.updateIndirectNeighbourShapes((LevelAccessor)level, posToUpdate, 2);
            air.updateNeighbourShapes((LevelAccessor)level, posToUpdate, 2);
            air.updateIndirectNeighbourShapes((LevelAccessor)level, posToUpdate, 2);
        }
        j = 0;
        for (int i1 = blocksToDestroy.size() - 1; i1 >= 0; --i1) {
            BlockState blockState = updatedBlocks[j++];
            BlockPos posToDestroy = blocksToDestroy.get(i1);
            blockState.updateIndirectNeighbourShapes((LevelAccessor)level, posToDestroy, 2);
            level.updateNeighborsAt(posToDestroy, blockState.getBlock());
        }
        for (int j1 = blocksToMove.size() - 1; j1 >= 0; --j1) {
            level.updateNeighborsAt(blocksToMove.get(j1), updatedBlocks[j++].getBlock());
        }
        if (extending) {
            level.updateNeighborsAt(frontPos, (Block)SCContent.REINFORCED_PISTON_HEAD.get());
        }
        return true;
    }

    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new ValidationOwnableBlockEntity(pos, state);
    }

    @Override
    public Block getVanillaBlock() {
        return this.isSticky ? Blocks.STICKY_PISTON : Blocks.PISTON;
    }

    @Override
    public BlockState convertToVanilla(Level level, BlockPos pos, BlockState reinforcedState) {
        return (BlockState)IReinforcedBlock.super.convertToVanilla(level, pos, reinforcedState).setValue((Property)EXTENDED, (Comparable)Boolean.valueOf(false));
    }

    @Override
    public BlockState convertToReinforced(Level level, BlockPos pos, BlockState vanillaState) {
        return (BlockState)IReinforcedBlock.super.convertToReinforced(level, pos, vanillaState).setValue((Property)EXTENDED, (Comparable)Boolean.valueOf(false));
    }

    private static boolean isSameOwner(BlockPos blockPos, BlockPos pistonPos, Level level) {
        BlockEntity pistonBe = level.getBlockEntity(pistonPos);
        IOwnable blockBe = (IOwnable)level.getBlockEntity(blockPos);
        if (pistonBe instanceof IOwnable) {
            IOwnable ownable = (IOwnable)pistonBe;
            return blockBe.getOwner().owns(ownable);
        }
        return false;
    }
}

