/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blockentities;

import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.api.IOwnable;
import net.geforcemods.securitycraft.api.Owner;
import net.geforcemods.securitycraft.blocks.mines.BrushableMineBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.BrushableBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;

public class BrushableMineBlockEntity
extends BrushableBlockEntity
implements IOwnable {
    private Owner owner = new Owner();

    public BrushableMineBlockEntity(BlockPos pos, BlockState state) {
        super(pos, state);
    }

    public boolean brush(long tickCount, Player player, Direction direction) {
        if (this.hitDirection == null) {
            this.hitDirection = direction;
        }
        this.brushCountResetsAtTick = tickCount + 40L;
        if (tickCount >= this.coolDownEndsAtTick && this.level instanceof ServerLevel) {
            this.coolDownEndsAtTick = tickCount + 10L;
            this.unpackLootTable(player);
            int previousCompletionState = this.getCompletionState();
            if (++this.brushCount >= 10) {
                this.brushingCompleted(player);
                return true;
            }
            this.level.scheduleTick(this.getBlockPos(), this.getBlockState().getBlock(), 40);
            int newCompletionState = this.getCompletionState();
            if (previousCompletionState != newCompletionState) {
                if (newCompletionState > 1 && !((Boolean)this.getBlockState().getValue((Property)BrushableMineBlock.SAFE)).booleanValue() && !this.isOwnedBy((Entity)player)) {
                    ((BrushableMineBlock)this.getBlockState().getBlock()).explode(this.level, this.worldPosition);
                } else {
                    this.level.setBlock(this.getBlockPos(), (BlockState)this.getBlockState().setValue((Property)BlockStateProperties.DUSTED, (Comparable)Integer.valueOf(newCompletionState)), 3);
                }
            }
        }
        return false;
    }

    public void checkReset() {
        if (this.level != null) {
            if (this.brushCount != 0 && this.level.getGameTime() >= this.brushCountResetsAtTick) {
                int previousCompletionState = this.getCompletionState();
                this.brushCount = Math.max(0, this.brushCount - 2);
                int currentCompletionState = this.getCompletionState();
                if (previousCompletionState != currentCompletionState) {
                    this.level.setBlock(this.getBlockPos(), (BlockState)this.getBlockState().setValue((Property)BlockStateProperties.DUSTED, (Comparable)Integer.valueOf(currentCompletionState)), 3);
                }
                this.brushCountResetsAtTick = this.level.getGameTime() + 4L;
            }
            if (this.brushCount == 0) {
                this.hitDirection = null;
                this.brushCountResetsAtTick = 0L;
                this.coolDownEndsAtTick = 0L;
            } else {
                this.level.scheduleTick(this.getBlockPos(), this.getBlockState().getBlock(), (int)(this.brushCountResetsAtTick - this.level.getGameTime()));
            }
        }
    }

    public void brushingCompleted(Player player) {
        if (this.level != null && this.level.getServer() != null) {
            Block turnInto = Blocks.AIR;
            this.dropContent(player);
            this.level.levelEvent(3008, this.getBlockPos(), Block.getId((BlockState)this.getBlockState()));
            Block block = this.getBlockState().getBlock();
            if (block instanceof BrushableMineBlock) {
                BrushableMineBlock brushableMineBlock = (BrushableMineBlock)block;
                turnInto = brushableMineBlock.getTurnsInto();
            }
            this.level.setBlock(this.worldPosition, turnInto.defaultBlockState(), 3);
        }
    }

    public boolean isValidBlockState(BlockState state) {
        return this.getType().isValid(state);
    }

    public BlockEntityType<?> getType() {
        return (BlockEntityType)SCContent.BRUSHABLE_MINE_BLOCK_ENTITY.get();
    }

    public void saveAdditional(CompoundTag tag, HolderLookup.Provider lookupProvider) {
        super.saveAdditional(tag, lookupProvider);
        if (this.owner != null) {
            this.owner.save(tag, this.needsValidation());
        }
    }

    public void loadAdditional(CompoundTag tag, HolderLookup.Provider lookupProvider) {
        super.loadAdditional(tag, lookupProvider);
        this.owner.load(tag);
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    @Override
    public Owner getOwner() {
        return this.owner;
    }

    @Override
    public void setOwner(String uuid, String name) {
        this.owner.set(uuid, name);
        this.setChanged();
    }
}

