/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.api;

import java.util.Optional;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.api.IModuleInventory;
import net.geforcemods.securitycraft.api.IOwnable;
import net.geforcemods.securitycraft.components.SavedBlockState;
import net.geforcemods.securitycraft.items.ModuleItem;
import net.geforcemods.securitycraft.misc.ModuleType;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public interface IDisguisable {
    default public ItemStack getDisguisedStack(BlockGetter level, BlockPos pos) {
        BlockEntity blockEntity;
        if (level != null && (blockEntity = level.getBlockEntity(pos)) instanceof IModuleInventory) {
            Block block;
            ItemStack stack;
            IModuleInventory be = (IModuleInventory)blockEntity;
            ItemStack itemStack = stack = be.isModuleEnabled(ModuleType.DISGUISE) ? be.getModule(ModuleType.DISGUISE) : ItemStack.EMPTY;
            if (!stack.isEmpty() && (block = ModuleItem.getBlockAddon(stack)) != null) {
                return new ItemStack((ItemLike)block);
            }
        }
        return this.getDefaultStack();
    }

    default public ItemStack getDefaultStack() {
        return new ItemStack((ItemLike)((Block)this));
    }

    public static boolean shouldPickBlockDisguise(BlockGetter level, BlockPos pos, Player player) {
        IOwnable ownable;
        BlockEntity blockEntity;
        return !player.isCreative() && (level == null || !((blockEntity = level.getBlockEntity(pos)) instanceof IOwnable) || !(ownable = (IOwnable)blockEntity).isOwnedBy((Entity)player));
    }

    public static Optional<BlockState> getDisguisedBlockState(BlockEntity be) {
        IModuleInventory moduleInv;
        if (be instanceof IModuleInventory && (moduleInv = (IModuleInventory)be).isModuleEnabled(ModuleType.DISGUISE)) {
            return IDisguisable.getDisguisedBlockStateFromStack(moduleInv.getModule(ModuleType.DISGUISE));
        }
        return Optional.empty();
    }

    public static Optional<BlockState> getDisguisedBlockStateFromStack(ItemStack module) {
        SavedBlockState savedBlockState = (SavedBlockState)module.get(SCContent.SAVED_BLOCK_STATE);
        if (savedBlockState != null) {
            BlockState disguisedState = savedBlockState.state();
            if (disguisedState != null && disguisedState.getBlock() != Blocks.AIR) {
                return Optional.of(disguisedState);
            }
            Block block = ModuleItem.getBlockAddon(module);
            if (block != null) {
                return Optional.of(block.defaultBlockState());
            }
        }
        return Optional.empty();
    }
}

