/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.common.gui.integration;

import com.mojang.blaze3d.platform.Window;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.client.event.RenderFrameEvent;
import team.creative.creativecore.CreativeCore;
import team.creative.creativecore.common.gui.IScaleableGuiScreen;

public class GuiEventHandler {
    private static int displayWidth;
    private static int displayHeight;
    private static int defaultScale;
    private static boolean changed;
    private static Screen displayScreen;

    public static void queueScreen(Screen displayScreen) {
        GuiEventHandler.displayScreen = displayScreen;
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public static void onTick(RenderFrameEvent.Pre tick) {
        Screen screen;
        Window window;
        Minecraft mc = Minecraft.getInstance();
        if (displayScreen != null) {
            mc.setScreen(displayScreen);
            displayScreen = null;
        }
        if ((window = mc.getWindow()).getWidth() != displayWidth || window.getHeight() != displayHeight) {
            displayWidth = window.getWidth();
            displayHeight = window.getHeight();
            if (mc.screen instanceof IScaleableGuiScreen) {
                mc.options.guiScale().set((Object)defaultScale);
                window.setGuiScale((double)window.calculateScale(((Integer)mc.options.guiScale().get()).intValue(), mc.isEnforceUnicode()));
                if (mc.screen != null) {
                    mc.screen.resize(mc, window.getGuiScaledWidth(), window.getGuiScaledHeight());
                }
            }
        }
        if ((screen = mc.screen) instanceof IScaleableGuiScreen) {
            IScaleableGuiScreen gui = (IScaleableGuiScreen)screen;
            if (!changed) {
                defaultScale = (Integer)mc.options.guiScale().get();
            }
            int maxScale = Math.min(CreativeCore.CONFIG.maxGuiScale, gui.getMaxScale(window.getWidth(), window.getHeight()));
            int scale = Math.min(defaultScale, maxScale);
            if (defaultScale == 0) {
                scale = maxScale;
            }
            if (scale != (Integer)mc.options.guiScale().get()) {
                changed = true;
                mc.options.guiScale().set((Object)scale);
                window.setGuiScale((double)scale);
                mc.screen.resize(mc, window.getGuiScaledWidth(), window.getGuiScaledHeight());
            }
        } else if (changed) {
            changed = false;
            mc.options.guiScale().set((Object)defaultScale);
            window.setGuiScale((double)window.calculateScale(((Integer)mc.options.guiScale().get()).intValue(), mc.isEnforceUnicode()));
            if (mc.screen != null) {
                mc.screen.resize(mc, window.getGuiScaledWidth(), window.getGuiScaledHeight());
            }
        }
    }
}

