/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.shared.template.args;

import com.tom.cpm.shared.io.IOHelper;
import com.tom.cpm.shared.model.RenderedCube;
import com.tom.cpm.shared.template.Template;
import java.io.IOException;
import java.util.Map;

public class TexArg
implements Template.IArg {
    public int u;
    public int v;
    public int texSize;

    @Override
    public String getType() {
        return "tex";
    }

    @Override
    public void write(Map<String, Object> map) {
        map.put("u", this.u);
        map.put("v", this.v);
        map.put("ts", this.texSize);
    }

    @Override
    public void write(IOHelper dout) throws IOException {
        dout.writeByte(this.texSize);
        dout.write(this.u);
        dout.write(this.v);
    }

    @Override
    public void load(Map<String, Object> map) {
        this.u = ((Number)map.get("u")).intValue();
        this.v = ((Number)map.get("v")).intValue();
        this.texSize = ((Number)map.get("ts")).intValue();
    }

    @Override
    public void load(IOHelper din) throws IOException {
        this.texSize = din.readByte();
        this.u = din.read();
        this.v = din.read();
    }

    @Override
    public void init(Map<String, Object> map) {
    }

    @Override
    public void apply(RenderedCube cube) {
        if (this.texSize != 0) {
            cube.getCube().u += this.u * this.texSize;
            cube.getCube().v += this.v * this.texSize;
            cube.getCube().texSize *= this.texSize;
        }
    }

    @Override
    public void export(Map<String, Object> map) {
    }

    @Override
    public void apply(Map<String, Object> map) {
    }

    public boolean isTextureMerged() {
        return this.texSize != 0;
    }
}

