/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.shared.io;

import java.io.IOException;
import java.io.OutputStream;

public class ChecksumOutputStream
extends OutputStream {
    private OutputStream os;
    private short sum;

    public ChecksumOutputStream(OutputStream os) {
        this.os = os;
    }

    @Override
    public void write(int b) throws IOException {
        this.os.write(b);
        this.sum = (short)(this.sum + (b & 0xFF));
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        for (int i = 0; i < len; ++i) {
            this.sum = (short)(this.sum + Byte.toUnsignedInt(b[off + i]));
        }
        this.os.write(b, off, len);
    }

    @Override
    public void flush() throws IOException {
        this.os.flush();
    }

    @Override
    public void close() throws IOException {
        try {
            this.os.write(this.sum >>> 8 & 0xFF);
            this.os.write(this.sum >>> 0 & 0xFF);
        }
        finally {
            this.os.close();
        }
    }
}

