/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.shared.gui.gesture;

import com.tom.cpl.gui.KeyboardEvent;
import com.tom.cpl.gui.MouseEvent;
import com.tom.cpl.gui.elements.Button;
import com.tom.cpl.gui.elements.ComboSlider;
import com.tom.cpl.gui.elements.GuiElement;
import com.tom.cpl.gui.elements.Panel;
import com.tom.cpl.gui.elements.Tooltip;
import com.tom.cpl.math.Box;
import com.tom.cpm.shared.MinecraftClientAccess;
import com.tom.cpm.shared.gui.Keybinds;
import com.tom.cpm.shared.gui.gesture.IGestureButton;
import com.tom.cpm.shared.gui.gesture.IGestureButtonContainer;
import com.tom.cpm.shared.network.ServerCaps;
import com.tom.cpm.shared.parts.anim.menu.ValueParameterButtonData;

public class GestureValueSlider
extends Panel
implements IGestureButton {
    private ValueParameterButtonData data;
    private ComboSlider slider;
    private Button btn;
    private boolean isHovered;

    public GestureValueSlider(IGestureButtonContainer c, ValueParameterButtonData data) {
        super(c.gui());
        this.data = data;
        if (!MinecraftClientAccess.get().getNetHandler().hasServerCap(ServerCaps.GESTURES)) {
            this.btn = new Button(this.gui, data.getName(), null);
            this.btn.setEnabled(false);
            this.btn.setTooltip(new Tooltip(this.gui.getFrame(), this.gui.i18nFormat("label.cpm.feature_unavailable", new Object[0])));
            this.addElement(this.btn);
        } else {
            this.slider = new ComboSlider(this.gui, a -> data.getName(), a -> a * (float)data.maxValue, a -> a / (float)data.maxValue);
            this.slider.getSpinner().setDp(0);
            this.slider.setTooltip(new Tooltip(this.gui.getFrame(), this.gui.i18nFormat("tooltip.cpm.gesture.valueDefaultValue", (int)(data.getDefaultValue() * (float)data.maxValue), Keybinds.RESET_VALUE_LAYER.getSetKey(this.gui))));
            this.slider.setAction(() -> {
                data.setValue(this.slider.getValue());
                c.valueChanged();
            });
            this.slider.setSteps(1.0f / (float)data.maxValue);
            this.slider.setValue(data.getValue());
            this.addElement(this.slider);
        }
    }

    @Override
    public void draw(MouseEvent event, float partialTicks) {
        this.isHovered = event.isHovered(this.bounds);
        super.draw(event, partialTicks);
    }

    @Override
    public GuiElement setBounds(Box bounds) {
        if (this.slider != null) {
            this.slider.setBounds(new Box(0, 0, bounds.w, bounds.h));
        }
        if (this.btn != null) {
            this.btn.setBounds(new Box(0, 0, bounds.w, bounds.h));
        }
        return super.setBounds(bounds);
    }

    @Override
    public void keyPressed(KeyboardEvent event) {
        super.keyPressed(event);
        if (Keybinds.RESET_VALUE_LAYER.isPressed(this.gui, event) && (this.gui.isCtrlDown() || this.isHovered)) {
            if (this.isHovered) {
                event.consume();
            }
            this.slider.setValue(this.data.getDefaultValue());
            this.data.setValue(this.data.getDefaultValue());
        }
    }

    @Override
    public void updateKeybinds() {
    }
}

