/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.shared.animation;

import com.tom.cpl.function.FloatUnaryOperator;
import com.tom.cpm.shared.animation.AnimationEngine;
import com.tom.cpm.shared.animation.IAnimation;
import com.tom.cpm.shared.animation.InterpolationInfo;
import com.tom.cpm.shared.definition.ModelDefinition;
import java.util.ArrayList;
import java.util.List;

public class AnimationNew
implements IAnimation {
    private final int duration;
    private final int priority;
    private List<AnimationDriver> handlers = new ArrayList<AnimationDriver>();

    public AnimationNew(int priority, int duration) {
        this.duration = duration;
        this.priority = priority;
    }

    public void add(AnimationDriver d) {
        this.handlers.add(d);
    }

    @Override
    public void animate(long millis, ModelDefinition def, AnimationEngine.AnimationMode mode) {
        float step = (float)millis % (float)this.duration / (float)this.duration;
        for (int i = 0; i < this.handlers.size(); ++i) {
            AnimationDriver p = this.handlers.get(i);
            p.set(step);
        }
    }

    @Override
    public int getDuration(AnimationEngine.AnimationMode mode) {
        return this.duration;
    }

    @Override
    public int getPriority(AnimationEngine.AnimationMode mode) {
        return this.priority;
    }

    public static interface AnimationDriver {
        public void set(float var1);
    }

    public static interface PartAnimationDriver
    extends AnimationDriver {
        public InterpolationInfo getInterpolationInfo();

        public void init(ModelDefinition var1);

        default public AnimationDriver makeDriver(FloatUnaryOperator frameDriver) {
            if (frameDriver == null) {
                return null;
            }
            return t -> this.set(frameDriver.apply(t));
        }
    }
}

