/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpl.math;

import com.tom.cpl.math.Vec2i;

public class Box {
    public int x;
    public int y;
    public int w;
    public int h;

    public Box(int x, int y, int w, int h) {
        this.x = x;
        this.y = y;
        this.w = w;
        this.h = h;
    }

    public Box(Box b) {
        this(b.x, b.y, b.w, b.h);
    }

    public boolean isInBounds(Vec2i v) {
        return this.isInBounds(v.x, v.y);
    }

    public boolean isInBounds(int x, int y) {
        return this.x <= x && this.y <= y && this.x + this.w > x && this.y + this.h > y;
    }

    public boolean intersects(Box box) {
        return this.x < box.x + box.w && this.x + this.w > box.x && this.y < box.y + box.h && this.y + this.h > box.y;
    }

    public Box intersect(Box other) {
        int f0 = Math.max(this.x, other.x);
        int f1 = Math.max(this.y, other.y);
        int f3 = Math.min(this.x + this.w, other.x + other.w);
        int f4 = Math.min(this.y + this.h, other.y + other.h);
        return new Box(f0, f1, f3 - f0, f4 - f1);
    }

    public Box union(Box other) {
        int f0 = Math.min(this.x, other.x);
        int f1 = Math.min(this.y, other.y);
        int f3 = Math.max(this.x + this.w, other.x + other.w);
        int f4 = Math.max(this.y + this.h, other.y + other.h);
        return new Box(f0, f1, f3 - f0, f4 - f1);
    }

    public static Box fromArea(int sx, int sy, int ex, int ey) {
        int x = Math.min(sx, ex);
        int y = Math.min(sy, ey);
        return new Box(x, y, Math.abs(sx - ex), Math.abs(sy - ey));
    }
}

