/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft.common.network.packet.s2c;

import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import org.vivecraft.client_vr.settings.VRSettings;
import org.vivecraft.common.network.CommonNetworkHelper;
import org.vivecraft.common.network.packet.PayloadIdentifier;
import org.vivecraft.common.network.packet.VivecraftPayload;
import org.vivecraft.common.network.packet.s2c.AttackWhileBlockingPayloadS2C;
import org.vivecraft.common.network.packet.s2c.ClimbingPayloadS2C;
import org.vivecraft.common.network.packet.s2c.CrawlPayloadS2C;
import org.vivecraft.common.network.packet.s2c.DamageDirectionPayloadS2C;
import org.vivecraft.common.network.packet.s2c.DualWieldingPayloadS2C;
import org.vivecraft.common.network.packet.s2c.HapticPayloadS2C;
import org.vivecraft.common.network.packet.s2c.NetworkVersionPayloadS2C;
import org.vivecraft.common.network.packet.s2c.RequestDataPayloadS2C;
import org.vivecraft.common.network.packet.s2c.ServerVrChangesS2CPacket;
import org.vivecraft.common.network.packet.s2c.SettingOverridePayloadS2C;
import org.vivecraft.common.network.packet.s2c.TeleportPayloadS2C;
import org.vivecraft.common.network.packet.s2c.UberPacketPayloadS2C;
import org.vivecraft.common.network.packet.s2c.UnknownPayloadS2C;
import org.vivecraft.common.network.packet.s2c.VRActivePayloadS2C;
import org.vivecraft.common.network.packet.s2c.VRSwitchingPayloadS2C;
import org.vivecraft.common.network.packet.s2c.VersionPayloadS2C;

public interface VivecraftPayloadS2C
extends VivecraftPayload {
    public static final StreamCodec<FriendlyByteBuf, VivecraftPayloadS2C> CODEC = CustomPacketPayload.codec(VivecraftPayload::write, VivecraftPayloadS2C::readPacket);
    public static final CustomPacketPayload.Type<VivecraftPayloadS2C> TYPE = new CustomPacketPayload.Type(CommonNetworkHelper.CHANNEL);

    default public CustomPacketPayload.Type<VivecraftPayloadS2C> type() {
        return TYPE;
    }

    public static VivecraftPayloadS2C readPacket(FriendlyByteBuf buffer) {
        byte index = buffer.readByte();
        if (index < PayloadIdentifier.values().length) {
            PayloadIdentifier id = PayloadIdentifier.values()[index];
            return switch (id) {
                case PayloadIdentifier.VERSION -> VersionPayloadS2C.read(buffer);
                case PayloadIdentifier.REQUESTDATA -> new RequestDataPayloadS2C();
                case PayloadIdentifier.UBERPACKET -> UberPacketPayloadS2C.read(buffer);
                case PayloadIdentifier.TELEPORT -> TeleportPayloadS2C.read(buffer);
                case PayloadIdentifier.CLIMBING -> ClimbingPayloadS2C.read(buffer);
                case PayloadIdentifier.SETTING_OVERRIDE -> SettingOverridePayloadS2C.read(buffer);
                case PayloadIdentifier.CRAWL -> CrawlPayloadS2C.read(buffer);
                case PayloadIdentifier.NETWORK_VERSION -> NetworkVersionPayloadS2C.read(buffer);
                case PayloadIdentifier.VR_SWITCHING -> VRSwitchingPayloadS2C.read(buffer);
                case PayloadIdentifier.IS_VR_ACTIVE -> VRActivePayloadS2C.read(buffer);
                case PayloadIdentifier.DUAL_WIELDING -> DualWieldingPayloadS2C.read(buffer);
                case PayloadIdentifier.HAPTIC -> HapticPayloadS2C.read(buffer);
                case PayloadIdentifier.SERVER_VR_CHANGES -> ServerVrChangesS2CPacket.read(buffer);
                case PayloadIdentifier.DAMAGE_DIRECTION -> DamageDirectionPayloadS2C.read(buffer);
                case PayloadIdentifier.ATTACK_WHILE_BLOCKING -> AttackWhileBlockingPayloadS2C.read(buffer);
                default -> {
                    VRSettings.LOGGER.error("Vivecraft: Got unexpected payload identifier on client: {}", (Object)id);
                    yield UnknownPayloadS2C.read(buffer);
                }
            };
        }
        VRSettings.LOGGER.error("Vivecraft: Got unknown payload identifier on client: {}", (Object)index);
        return UnknownPayloadS2C.read(buffer);
    }
}

