/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft.client_vr.menuworlds;

import com.google.common.io.Files;
import com.mojang.datafixers.DataFixer;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.zip.DataFormatException;
import java.util.zip.Deflater;
import java.util.zip.Inflater;
import net.minecraft.SharedConstants;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtAccounter;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.CrudeIncrementalIntIdentityHashBiMap;
import net.minecraft.util.StringRepresentable;
import net.minecraft.util.datafix.DataFixers;
import net.minecraft.util.datafix.fixes.References;
import net.minecraft.util.valueproviders.ConstantInt;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.biome.AmbientParticleSettings;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeGenerationSettings;
import net.minecraft.world.level.biome.BiomeSpecialEffects;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.dimension.BuiltinDimensionTypes;
import net.minecraft.world.level.dimension.DimensionType;
import org.vivecraft.Xplat;
import org.vivecraft.client_vr.menuworlds.FakeBlockAccess;
import org.vivecraft.client_vr.settings.VRSettings;

public class MenuWorldExporter {
    public static final int VERSION = 5;
    public static final int MIN_VERSION = 2;
    private static final DataFixer DATA_FIXER = DataFixers.getDataFixer();
    private static final BiomeGenerationSettings DUMMY_GENERATION_SETTINGS = new BiomeGenerationSettings.PlainBuilder().build();
    private static final MobSpawnSettings DUMMY_MOB_SPAWN_SETTINGS = new MobSpawnSettings.Builder().build();

    public static byte[] saveArea(Level level, int xMin, int zMin, int xSize, int zSize, int ground) throws IOException {
        int i;
        BlockStateMapper blockStateMapper = new BlockStateMapper();
        PaletteBiomeMapper biomeMapper = new PaletteBiomeMapper();
        int yMin = level.getMinBuildHeight();
        int ySize = level.getHeight();
        int[] blocks = new int[xSize * ySize * zSize];
        byte[] skylightmap = new byte[xSize * ySize * zSize];
        byte[] blocklightmap = new byte[xSize * ySize * zSize];
        int[] biomemap = new int[xSize * ySize * zSize / 64];
        for (int x = xMin; x < xMin + xSize; ++x) {
            int xl = x - xMin;
            for (int z = zMin; z < zMin + zSize; ++z) {
                int zl = z - zMin;
                for (int y = yMin; y < yMin + ySize; ++y) {
                    int yl = y - yMin;
                    int index3 = (yl * zSize + zl) * xSize + xl;
                    BlockPos pos3 = new BlockPos(x, y, z);
                    BlockState state = level.getBlockState(pos3);
                    blocks[index3] = blockStateMapper.getId(state);
                    skylightmap[index3] = (byte)level.getBrightness(LightLayer.SKY, pos3);
                    blocklightmap[index3] = (byte)level.getBrightness(LightLayer.BLOCK, pos3);
                    if (x % 4 != 0 || y % 4 != 0 || z % 4 != 0) continue;
                    int indexBiome = (yl / 4 * (zSize / 4) + zl / 4) * (xSize / 4) + xl / 4;
                    biomemap[indexBiome] = biomeMapper.getId((Biome)level.getNoiseBiome(x / 4, y / 4, z / 4).value());
                }
            }
        }
        ByteArrayOutputStream data = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(data);
        dos.writeInt(xSize);
        dos.writeInt(ySize);
        dos.writeInt(zSize);
        dos.writeInt(ground);
        dos.writeUTF(level.dimensionType().effectsLocation().toString());
        if (level instanceof ServerLevel) {
            dos.writeBoolean(((ServerLevel)level).isFlat());
        } else {
            dos.writeBoolean(((ClientLevel)level).getLevelData().isFlat);
        }
        dos.writeBoolean(level.dimensionType().hasSkyLight());
        if (level instanceof ServerLevel) {
            dos.writeLong(((ServerLevel)level).getSeed());
        } else {
            dos.writeLong(level.getBiomeManager().biomeZoomSeed);
        }
        dos.writeInt(SharedConstants.getCurrentVersion().getDataVersion().getVersion());
        dos.writeBoolean(level.dimensionType().fixedTime().isPresent());
        if (level.dimensionType().fixedTime().isPresent()) {
            dos.writeLong(level.dimensionType().fixedTime().getAsLong());
        }
        dos.writeBoolean(level.dimensionType().hasCeiling());
        dos.writeInt(level.dimensionType().minY());
        dos.writeFloat(level.dimensionType().ambientLight());
        dos.writeFloat(switch (Minecraft.getInstance().player.getDirection()) {
            case Direction.SOUTH -> 180.0f;
            case Direction.WEST -> -90.0f;
            case Direction.EAST -> 90.0f;
            default -> 0.0f;
        });
        dos.writeBoolean(level.getRainLevel(1.0f) > 0.0f);
        dos.writeBoolean(level.getThunderLevel(1.0f) > 0.0f);
        blockStateMapper.writePalette(dos);
        biomeMapper.writePalette(dos, level.registryAccess());
        for (i = 0; i < blocks.length; ++i) {
            dos.writeInt(blocks[i]);
        }
        for (i = 0; i < skylightmap.length; ++i) {
            dos.writeByte(skylightmap[i] | blocklightmap[i] << 4);
        }
        for (i = 0; i < biomemap.length; ++i) {
            dos.writeInt(biomemap[i]);
        }
        Header header = new Header();
        header.version = 5;
        header.uncompressedSize = data.size();
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        DataOutputStream headerStream = new DataOutputStream(output);
        header.write(headerStream);
        Deflater deflater = new Deflater(9);
        deflater.setInput(data.toByteArray());
        deflater.finish();
        byte[] buffer = new byte[0x100000];
        while (!deflater.finished()) {
            int len = deflater.deflate(buffer);
            output.write(buffer, 0, len);
        }
        return output.toByteArray();
    }

    public static void saveAreaToFile(Level world, int xMin, int zMin, int xSize, int zSize, int ground, File file) throws IOException {
        byte[] bytes = MenuWorldExporter.saveArea(world, xMin, zMin, xSize, zSize, ground);
        Files.write((byte[])bytes, (File)file);
    }

    public static FakeBlockAccess loadWorld(byte[] data) throws IOException, DataFormatException {
        BiomeMapper biomeMapper;
        float dimAmbientLight;
        int dimMinY;
        boolean dimHasCeiling;
        int dataVersion;
        ResourceLocation dimName;
        Header header = new Header();
        try (DataInputStream dis = new DataInputStream(new ByteArrayInputStream(data));){
            header.read(dis);
        }
        if (header.version > 5 || header.version < 2) {
            throw new DataFormatException("Unsupported menu world version: " + header.version);
        }
        Inflater inflater = new Inflater();
        inflater.setInput(data, 8, data.length - 8);
        ByteArrayOutputStream output = new ByteArrayOutputStream(header.uncompressedSize);
        byte[] buffer = new byte[0x100000];
        while (!inflater.finished()) {
            int len = inflater.inflate(buffer);
            output.write(buffer, 0, len);
        }
        DataInputStream dis = new DataInputStream(new ByteArrayInputStream(output.toByteArray()));
        int xSize = dis.readInt();
        int ySize = dis.readInt();
        int zSize = dis.readInt();
        int ground = dis.readInt();
        if (header.version < 4) {
            int dimId = dis.readInt();
            dimName = switch (dimId) {
                case -1 -> BuiltinDimensionTypes.NETHER_EFFECTS;
                case 1 -> BuiltinDimensionTypes.END_EFFECTS;
                default -> BuiltinDimensionTypes.OVERWORLD_EFFECTS;
            };
        } else {
            dimName = ResourceLocation.parse((String)dis.readUTF());
        }
        boolean isFlat = header.version < 4 ? dis.readUTF().equals("flat") : dis.readBoolean();
        boolean dimHasSkyLight = dis.readBoolean();
        long seed = 0L;
        if (header.version >= 3) {
            seed = dis.readLong();
        }
        if ((dataVersion = header.version == 2 ? 1631 : (header.version == 3 ? 2230 : (header.version == 4 ? 2586 : dis.readInt()))) > SharedConstants.getCurrentVersion().getDataVersion().getVersion()) {
            VRSettings.LOGGER.warn("Vivecraft: Menuworld data version is newer than current, this menu world may not load correctly.");
        }
        OptionalLong dimFixedTime = OptionalLong.empty();
        if (header.version < 5) {
            if (BuiltinDimensionTypes.NETHER_EFFECTS.equals((Object)dimName)) {
                dimFixedTime = OptionalLong.of(18000L);
                dimHasCeiling = true;
                dimMinY = 0;
                dimAmbientLight = 0.1f;
            } else if (BuiltinDimensionTypes.END_EFFECTS.equals((Object)dimName)) {
                dimFixedTime = OptionalLong.of(6000L);
                dimHasCeiling = false;
                dimMinY = 0;
                dimAmbientLight = 0.0f;
            } else {
                dimHasCeiling = false;
                dimMinY = 0;
                dimAmbientLight = 0.0f;
            }
        } else {
            if (dis.readBoolean()) {
                dimFixedTime = OptionalLong.of(dis.readLong());
            }
            dimHasCeiling = dis.readBoolean();
            dimMinY = dis.readInt();
            dimAmbientLight = dis.readFloat();
        }
        DimensionType dimensionType = new DimensionType(dimFixedTime, dimHasSkyLight, dimHasCeiling, false, false, 1.0, true, false, dimMinY, ySize, ySize, BlockTags.INFINIBURN_OVERWORLD, dimName, dimAmbientLight, new DimensionType.MonsterSettings(false, false, (IntProvider)ConstantInt.of((int)0), 0));
        float rotation = 0.0f;
        boolean rain = false;
        boolean thunder = false;
        if (header.version >= 5) {
            rotation = dis.readFloat();
            rain = dis.readBoolean();
            thunder = dis.readBoolean();
        }
        BlockStateMapper blockStateMapper = new BlockStateMapper();
        blockStateMapper.readPalette(dis, dataVersion);
        if (header.version >= 5) {
            biomeMapper = new PaletteBiomeMapper();
            ((PaletteBiomeMapper)biomeMapper).readPalette(dis);
        } else {
            biomeMapper = new LegacyBiomeMapper();
        }
        BlockState[] blocks = new BlockState[xSize * ySize * zSize];
        for (int i = 0; i < blocks.length; ++i) {
            blocks[i] = blockStateMapper.getState(dis.readInt());
        }
        short[][] heightmap = new short[xSize][zSize];
        for (int x = 0; x < xSize; ++x) {
            block12: for (int z = 0; z < zSize; ++z) {
                for (int y = ySize - 1; y >= 0; --y) {
                    int index = (y * zSize + z) * xSize + x;
                    if (!blocks[index].blocksMotion() && blocks[index].getFluidState().isEmpty()) continue;
                    heightmap[x][z] = (short)(y + 1);
                    continue block12;
                }
            }
        }
        byte[] skylightmap = new byte[xSize * ySize * zSize];
        byte[] blocklightmap = new byte[xSize * ySize * zSize];
        for (int i = 0; i < skylightmap.length; ++i) {
            int b = dis.readByte() & 0xFF;
            skylightmap[i] = (byte)(b & 0xF);
            blocklightmap[i] = (byte)(b >> 4);
        }
        Biome[] biomemap = new Biome[xSize * ySize * zSize / 64];
        if (header.version == 2) {
            Biome[] tempBiomemap = new Biome[xSize * zSize];
            for (int i = 0; i < tempBiomemap.length; ++i) {
                tempBiomemap[i] = biomeMapper.getBiome(dis.readInt());
            }
            for (int x = 0; x < xSize / 4; ++x) {
                for (int z = 0; z < zSize / 4; ++z) {
                    biomemap[z * (xSize / 4) + x] = tempBiomemap[z * 4 * xSize + x * 4];
                }
            }
            int yStride = xSize / 4 * (zSize / 4);
            for (int y = 1; y < ySize / 4; ++y) {
                System.arraycopy(biomemap, 0, biomemap, yStride * y, yStride);
            }
        } else {
            for (int i = 0; i < biomemap.length; ++i) {
                biomemap[i] = biomeMapper.getBiome(dis.readInt());
            }
        }
        return new FakeBlockAccess(header.version, seed, blocks, skylightmap, blocklightmap, biomemap, heightmap, xSize, ySize, zSize, ground, dimensionType, isFlat, rotation, rain, thunder);
    }

    public static FakeBlockAccess loadWorld(InputStream is) throws IOException, DataFormatException {
        int count;
        ByteArrayOutputStream data = new ByteArrayOutputStream();
        byte[] buffer = new byte[0x100000];
        while ((count = is.read(buffer)) != -1) {
            data.write(buffer, 0, count);
        }
        return MenuWorldExporter.loadWorld(data.toByteArray());
    }

    public static int readVersion(File file) throws IOException {
        try (DataInputStream dis = new DataInputStream(new FileInputStream(file));){
            Header header = new Header();
            header.read(dis);
            int n = header.version;
            return n;
        }
    }

    private static <T extends Enum> Optional<T> decodeEnum(Class<T> type, String input) {
        return Arrays.stream((Enum[])type.getEnumConstants()).filter(e -> input.equals(((StringRepresentable)e).getSerializedName())).findFirst();
    }

    private static class BlockStateMapper {
        CrudeIncrementalIntIdentityHashBiMap<BlockState> paletteMap = CrudeIncrementalIntIdentityHashBiMap.create((int)256);

        private BlockStateMapper() {
        }

        int getId(BlockState state) {
            int id = this.paletteMap.getId((Object)state);
            return id == -1 ? this.paletteMap.add((Object)state) : id;
        }

        BlockState getState(int id) {
            return (BlockState)this.paletteMap.byId(id);
        }

        void readPalette(DataInputStream dis, int dataVersion) throws IOException {
            this.paletteMap.clear();
            int size = dis.readInt();
            for (int i = 0; i < size; ++i) {
                CompoundTag tag = (CompoundTag)CompoundTag.TYPE.load((DataInput)dis, NbtAccounter.unlimitedHeap());
                tag = (CompoundTag)DATA_FIXER.update(References.BLOCK_STATE, new Dynamic((DynamicOps)NbtOps.INSTANCE, (Object)tag), dataVersion, SharedConstants.getCurrentVersion().getDataVersion().getVersion()).getValue();
                this.paletteMap.add((Object)NbtUtils.readBlockState((HolderGetter)BuiltInRegistries.BLOCK.asLookup(), (CompoundTag)tag));
            }
        }

        void writePalette(DataOutputStream dos) throws IOException {
            dos.writeInt(this.paletteMap.size());
            for (int i = 0; i < this.paletteMap.size(); ++i) {
                CompoundTag compoundtag = NbtUtils.writeBlockState((BlockState)((BlockState)this.paletteMap.byId(i)));
                compoundtag.write((DataOutput)dos);
            }
        }
    }

    private static class PaletteBiomeMapper
    implements BiomeMapper {
        private final CrudeIncrementalIntIdentityHashBiMap<Biome> paletteMap = CrudeIncrementalIntIdentityHashBiMap.create((int)256);

        private PaletteBiomeMapper() {
        }

        @Override
        public int getId(Biome biome) {
            int id = this.paletteMap.getId((Object)biome);
            return id == -1 ? this.paletteMap.add((Object)biome) : id;
        }

        @Override
        public Biome getBiome(int id) {
            return (Biome)this.paletteMap.byId(id);
        }

        void readPalette(DataInputStream dis) throws IOException {
            this.paletteMap.clear();
            int size = dis.readInt();
            for (int i = 0; i < size; ++i) {
                Biome.BiomeBuilder builder = new Biome.BiomeBuilder();
                dis.readUTF();
                builder.hasPrecipitation(dis.readBoolean());
                builder.temperature(dis.readFloat());
                MenuWorldExporter.decodeEnum(Biome.TemperatureModifier.class, dis.readUTF()).ifPresent(arg_0 -> ((Biome.BiomeBuilder)builder).temperatureAdjustment(arg_0));
                builder.downfall(dis.readFloat());
                BiomeSpecialEffects.Builder effectsBuilder = new BiomeSpecialEffects.Builder();
                effectsBuilder.fogColor(dis.readInt());
                effectsBuilder.waterColor(dis.readInt());
                effectsBuilder.waterFogColor(dis.readInt());
                effectsBuilder.skyColor(dis.readInt());
                if (dis.readBoolean()) {
                    effectsBuilder.foliageColorOverride(dis.readInt());
                }
                if (dis.readBoolean()) {
                    effectsBuilder.grassColorOverride(dis.readInt());
                }
                MenuWorldExporter.decodeEnum(BiomeSpecialEffects.GrassColorModifier.class, dis.readUTF()).ifPresent(arg_0 -> ((BiomeSpecialEffects.Builder)effectsBuilder).grassColorModifier(arg_0));
                if (dis.readBoolean()) {
                    ParticleType particleType = (ParticleType)BuiltInRegistries.PARTICLE_TYPE.get(ResourceLocation.parse((String)dis.readUTF()));
                    float probability = dis.readFloat();
                    if (particleType instanceof ParticleOptions) {
                        effectsBuilder.ambientParticle(new AmbientParticleSettings((ParticleOptions)particleType, probability));
                    }
                }
                Biome biome = builder.specialEffects(effectsBuilder.build()).generationSettings(DUMMY_GENERATION_SETTINGS).mobSpawnSettings(DUMMY_MOB_SPAWN_SETTINGS).build();
                this.paletteMap.add((Object)biome);
            }
        }

        void writePalette(DataOutputStream dos, RegistryAccess registryAccess) throws IOException {
            dos.writeInt(this.paletteMap.size());
            for (int i = 0; i < this.paletteMap.size(); ++i) {
                Biome biome = (Biome)this.paletteMap.byId(i);
                dos.writeUTF(registryAccess.registryOrThrow(Registries.BIOME).getKey((Object)biome).toString());
                Biome.ClimateSettings climateSettings = Xplat.getBiomeClimateSettings(biome);
                dos.writeBoolean(climateSettings.hasPrecipitation());
                dos.writeFloat(climateSettings.temperature());
                dos.writeUTF(climateSettings.temperatureModifier().getSerializedName());
                dos.writeFloat(climateSettings.downfall());
                BiomeSpecialEffects specialEffects = Xplat.getBiomeEffects(biome);
                dos.writeInt(specialEffects.getFogColor());
                dos.writeInt(specialEffects.getWaterColor());
                dos.writeInt(specialEffects.getWaterFogColor());
                dos.writeInt(specialEffects.getSkyColor());
                dos.writeBoolean(specialEffects.getFoliageColorOverride().isPresent());
                if (specialEffects.getFoliageColorOverride().isPresent()) {
                    dos.writeInt((Integer)specialEffects.getFoliageColorOverride().get());
                }
                dos.writeBoolean(specialEffects.getGrassColorOverride().isPresent());
                if (specialEffects.getGrassColorOverride().isPresent()) {
                    dos.writeInt((Integer)specialEffects.getGrassColorOverride().get());
                }
                dos.writeUTF(specialEffects.getGrassColorModifier().getSerializedName());
                dos.writeBoolean(specialEffects.getAmbientParticleSettings().isPresent());
                if (!specialEffects.getAmbientParticleSettings().isPresent()) continue;
                AmbientParticleSettings ambientParticleSettings = (AmbientParticleSettings)specialEffects.getAmbientParticleSettings().get();
                dos.writeUTF(BuiltInRegistries.PARTICLE_TYPE.getKey((Object)ambientParticleSettings.getOptions().getType()).toString());
                dos.writeFloat(ambientParticleSettings.probability);
            }
        }
    }

    public static class Header {
        public static final int SIZE = 8;
        public int version;
        public int uncompressedSize;

        public void read(DataInputStream dis) throws IOException {
            this.version = dis.readInt();
            this.uncompressedSize = dis.readInt();
        }

        public void write(DataOutputStream dos) throws IOException {
            dos.writeInt(this.version);
            dos.writeInt(this.uncompressedSize);
        }
    }

    private static class LegacyBiomeMapper
    implements BiomeMapper {
        private static final Map<Integer, Biome> MAP = new HashMap<Integer, Biome>();

        private LegacyBiomeMapper() {
        }

        @Override
        public int getId(Biome biome) {
            throw new UnsupportedOperationException("this mapper does not support reversing biomes to IDs");
        }

        @Override
        public Biome getBiome(int id) {
            Biome biome = MAP.get(id);
            return biome != null ? biome : MAP.get(1);
        }

        static {
            MAP.put(1, new Biome.BiomeBuilder().hasPrecipitation(true).temperature(0.8f).downfall(0.4f).specialEffects(new BiomeSpecialEffects.Builder().fogColor(12638463).waterColor(4159204).waterFogColor(329011).skyColor(7907327).build()).generationSettings(DUMMY_GENERATION_SETTINGS).mobSpawnSettings(DUMMY_MOB_SPAWN_SETTINGS).build());
            MAP.put(127, new Biome.BiomeBuilder().hasPrecipitation(false).temperature(0.5f).downfall(0.5f).specialEffects(new BiomeSpecialEffects.Builder().fogColor(12638463).waterColor(4159204).waterFogColor(329011).skyColor(8103167).build()).generationSettings(DUMMY_GENERATION_SETTINGS).mobSpawnSettings(DUMMY_MOB_SPAWN_SETTINGS).build());
            MAP.put(0, new Biome.BiomeBuilder().hasPrecipitation(true).temperature(0.5f).downfall(0.5f).specialEffects(new BiomeSpecialEffects.Builder().fogColor(12638463).waterColor(4159204).waterFogColor(329011).skyColor(8103167).build()).generationSettings(DUMMY_GENERATION_SETTINGS).mobSpawnSettings(DUMMY_MOB_SPAWN_SETTINGS).build());
            MAP.put(2, new Biome.BiomeBuilder().hasPrecipitation(false).temperature(2.0f).downfall(0.0f).specialEffects(new BiomeSpecialEffects.Builder().fogColor(12638463).waterColor(4159204).waterFogColor(329011).skyColor(7254527).build()).generationSettings(DUMMY_GENERATION_SETTINGS).mobSpawnSettings(DUMMY_MOB_SPAWN_SETTINGS).build());
            MAP.put(3, new Biome.BiomeBuilder().hasPrecipitation(true).temperature(0.2f).downfall(0.3f).specialEffects(new BiomeSpecialEffects.Builder().fogColor(12638463).waterColor(4159204).waterFogColor(329011).skyColor(8233727).build()).generationSettings(DUMMY_GENERATION_SETTINGS).mobSpawnSettings(DUMMY_MOB_SPAWN_SETTINGS).build());
            MAP.put(4, new Biome.BiomeBuilder().hasPrecipitation(true).temperature(0.7f).downfall(0.8f).specialEffects(new BiomeSpecialEffects.Builder().fogColor(12638463).waterColor(4159204).waterFogColor(329011).skyColor(7972607).build()).generationSettings(DUMMY_GENERATION_SETTINGS).mobSpawnSettings(DUMMY_MOB_SPAWN_SETTINGS).build());
            MAP.put(5, new Biome.BiomeBuilder().hasPrecipitation(true).temperature(0.25f).downfall(0.8f).specialEffects(new BiomeSpecialEffects.Builder().fogColor(12638463).waterColor(4159204).waterFogColor(329011).skyColor(8233983).build()).generationSettings(DUMMY_GENERATION_SETTINGS).mobSpawnSettings(DUMMY_MOB_SPAWN_SETTINGS).build());
            MAP.put(6, new Biome.BiomeBuilder().hasPrecipitation(true).temperature(0.8f).downfall(0.9f).specialEffects(new BiomeSpecialEffects.Builder().fogColor(12638463).waterColor(6388580).waterFogColor(2302743).skyColor(7907327).foliageColorOverride(6975545).grassColorModifier(BiomeSpecialEffects.GrassColorModifier.SWAMP).build()).generationSettings(DUMMY_GENERATION_SETTINGS).mobSpawnSettings(DUMMY_MOB_SPAWN_SETTINGS).build());
            MAP.put(7, new Biome.BiomeBuilder().hasPrecipitation(true).temperature(0.5f).downfall(0.5f).specialEffects(new BiomeSpecialEffects.Builder().fogColor(12638463).waterColor(4159204).waterFogColor(329011).skyColor(8103167).build()).generationSettings(DUMMY_GENERATION_SETTINGS).mobSpawnSettings(DUMMY_MOB_SPAWN_SETTINGS).build());
            MAP.put(8, new Biome.BiomeBuilder().hasPrecipitation(false).temperature(2.0f).downfall(0.0f).specialEffects(new BiomeSpecialEffects.Builder().fogColor(0x330808).waterColor(4159204).waterFogColor(329011).skyColor(7254527).build()).generationSettings(DUMMY_GENERATION_SETTINGS).mobSpawnSettings(DUMMY_MOB_SPAWN_SETTINGS).build());
            MAP.put(9, new Biome.BiomeBuilder().hasPrecipitation(false).temperature(0.5f).downfall(0.5f).specialEffects(new BiomeSpecialEffects.Builder().fogColor(0xA080A0).waterColor(4159204).waterFogColor(329011).skyColor(0).build()).generationSettings(DUMMY_GENERATION_SETTINGS).mobSpawnSettings(DUMMY_MOB_SPAWN_SETTINGS).build());
            MAP.put(10, new Biome.BiomeBuilder().hasPrecipitation(true).temperature(0.0f).downfall(0.5f).temperatureAdjustment(Biome.TemperatureModifier.FROZEN).specialEffects(new BiomeSpecialEffects.Builder().fogColor(12638463).waterColor(3750089).waterFogColor(329011).skyColor(8364543).build()).generationSettings(DUMMY_GENERATION_SETTINGS).mobSpawnSettings(DUMMY_MOB_SPAWN_SETTINGS).build());
            MAP.put(11, new Biome.BiomeBuilder().hasPrecipitation(true).temperature(0.0f).downfall(0.5f).specialEffects(new BiomeSpecialEffects.Builder().fogColor(12638463).waterColor(3750089).waterFogColor(329011).skyColor(8364543).build()).generationSettings(DUMMY_GENERATION_SETTINGS).mobSpawnSettings(DUMMY_MOB_SPAWN_SETTINGS).build());
            MAP.put(12, new Biome.BiomeBuilder().hasPrecipitation(true).temperature(0.0f).downfall(0.5f).specialEffects(new BiomeSpecialEffects.Builder().fogColor(12638463).waterColor(4159204).waterFogColor(329011).skyColor(8364543).build()).generationSettings(DUMMY_GENERATION_SETTINGS).mobSpawnSettings(DUMMY_MOB_SPAWN_SETTINGS).build());
            MAP.put(13, new Biome.BiomeBuilder().hasPrecipitation(true).temperature(0.0f).downfall(0.5f).specialEffects(new BiomeSpecialEffects.Builder().fogColor(12638463).waterColor(4159204).waterFogColor(329011).skyColor(8364543).build()).generationSettings(DUMMY_GENERATION_SETTINGS).mobSpawnSettings(DUMMY_MOB_SPAWN_SETTINGS).build());
            MAP.put(14, new Biome.BiomeBuilder().hasPrecipitation(true).temperature(0.9f).downfall(1.0f).specialEffects(new BiomeSpecialEffects.Builder().fogColor(12638463).waterColor(4159204).waterFogColor(329011).skyColor(7842047).build()).generationSettings(DUMMY_GENERATION_SETTINGS).mobSpawnSettings(DUMMY_MOB_SPAWN_SETTINGS).build());
            MAP.put(15, new Biome.BiomeBuilder().hasPrecipitation(true).temperature(0.9f).downfall(1.0f).specialEffects(new BiomeSpecialEffects.Builder().fogColor(12638463).waterColor(4159204).waterFogColor(329011).skyColor(7842047).build()).generationSettings(DUMMY_GENERATION_SETTINGS).mobSpawnSettings(DUMMY_MOB_SPAWN_SETTINGS).build());
            MAP.put(16, new Biome.BiomeBuilder().hasPrecipitation(true).temperature(0.8f).downfall(0.4f).specialEffects(new BiomeSpecialEffects.Builder().fogColor(12638463).waterColor(4159204).waterFogColor(329011).skyColor(7907327).build()).generationSettings(DUMMY_GENERATION_SETTINGS).mobSpawnSettings(DUMMY_MOB_SPAWN_SETTINGS).build());
            MAP.put(17, new Biome.BiomeBuilder().hasPrecipitation(false).temperature(2.0f).downfall(0.0f).specialEffects(new BiomeSpecialEffects.Builder().fogColor(12638463).waterColor(4159204).waterFogColor(329011).skyColor(7254527).build()).generationSettings(DUMMY_GENERATION_SETTINGS).mobSpawnSettings(DUMMY_MOB_SPAWN_SETTINGS).build());
            MAP.put(18, new Biome.BiomeBuilder().hasPrecipitation(true).temperature(0.7f).downfall(0.8f).specialEffects(new BiomeSpecialEffects.Builder().fogColor(12638463).waterColor(4159204).waterFogColor(329011).skyColor(7972607).build()).generationSettings(DUMMY_GENERATION_SETTINGS).mobSpawnSettings(DUMMY_MOB_SPAWN_SETTINGS).build());
            MAP.put(19, new Biome.BiomeBuilder().hasPrecipitation(true).temperature(0.25f).downfall(0.8f).specialEffects(new BiomeSpecialEffects.Builder().fogColor(12638463).waterColor(4159204).waterFogColor(329011).skyColor(8233983).build()).generationSettings(DUMMY_GENERATION_SETTINGS).mobSpawnSettings(DUMMY_MOB_SPAWN_SETTINGS).build());
            MAP.put(20, new Biome.BiomeBuilder().hasPrecipitation(true).temperature(0.2f).downfall(0.3f).specialEffects(new BiomeSpecialEffects.Builder().fogColor(12638463).waterColor(4159204).waterFogColor(329011).skyColor(8233727).build()).generationSettings(DUMMY_GENERATION_SETTINGS).mobSpawnSettings(DUMMY_MOB_SPAWN_SETTINGS).build());
            MAP.put(21, new Biome.BiomeBuilder().hasPrecipitation(true).temperature(0.95f).downfall(0.9f).specialEffects(new BiomeSpecialEffects.Builder().fogColor(12638463).waterColor(4159204).waterFogColor(329011).skyColor(7842047).build()).generationSettings(DUMMY_GENERATION_SETTINGS).mobSpawnSettings(DUMMY_MOB_SPAWN_SETTINGS).build());
            MAP.put(22, new Biome.BiomeBuilder().hasPrecipitation(true).temperature(0.95f).downfall(0.9f).specialEffects(new BiomeSpecialEffects.Builder().fogColor(12638463).waterColor(4159204).waterFogColor(329011).skyColor(7842047).build()).generationSettings(DUMMY_GENERATION_SETTINGS).mobSpawnSettings(DUMMY_MOB_SPAWN_SETTINGS).build());
            MAP.put(23, new Biome.BiomeBuilder().hasPrecipitation(true).temperature(0.95f).downfall(0.8f).specialEffects(new BiomeSpecialEffects.Builder().fogColor(12638463).waterColor(4159204).waterFogColor(329011).skyColor(7842047).build()).generationSettings(DUMMY_GENERATION_SETTINGS).mobSpawnSettings(DUMMY_MOB_SPAWN_SETTINGS).build());
            MAP.put(24, new Biome.BiomeBuilder().hasPrecipitation(true).temperature(0.5f).downfall(0.5f).specialEffects(new BiomeSpecialEffects.Builder().fogColor(12638463).waterColor(4159204).waterFogColor(329011).skyColor(8103167).build()).generationSettings(DUMMY_GENERATION_SETTINGS).mobSpawnSettings(DUMMY_MOB_SPAWN_SETTINGS).build());
            MAP.put(25, new Biome.BiomeBuilder().hasPrecipitation(true).temperature(0.2f).downfall(0.3f).specialEffects(new BiomeSpecialEffects.Builder().fogColor(12638463).waterColor(4159204).waterFogColor(329011).skyColor(8233727).build()).generationSettings(DUMMY_GENERATION_SETTINGS).mobSpawnSettings(DUMMY_MOB_SPAWN_SETTINGS).build());
            MAP.put(26, new Biome.BiomeBuilder().hasPrecipitation(true).temperature(0.05f).downfall(0.3f).specialEffects(new BiomeSpecialEffects.Builder().fogColor(12638463).waterColor(4020182).waterFogColor(329011).skyColor(8364543).build()).generationSettings(DUMMY_GENERATION_SETTINGS).mobSpawnSettings(DUMMY_MOB_SPAWN_SETTINGS).build());
            MAP.put(27, new Biome.BiomeBuilder().hasPrecipitation(true).temperature(0.6f).downfall(0.6f).specialEffects(new BiomeSpecialEffects.Builder().fogColor(12638463).waterColor(4159204).waterFogColor(329011).skyColor(8037887).build()).generationSettings(DUMMY_GENERATION_SETTINGS).mobSpawnSettings(DUMMY_MOB_SPAWN_SETTINGS).build());
            MAP.put(28, new Biome.BiomeBuilder().hasPrecipitation(true).temperature(0.6f).downfall(0.6f).specialEffects(new BiomeSpecialEffects.Builder().fogColor(12638463).waterColor(4159204).waterFogColor(329011).skyColor(8037887).build()).generationSettings(DUMMY_GENERATION_SETTINGS).mobSpawnSettings(DUMMY_MOB_SPAWN_SETTINGS).build());
            MAP.put(29, new Biome.BiomeBuilder().hasPrecipitation(true).temperature(0.7f).downfall(0.8f).specialEffects(new BiomeSpecialEffects.Builder().fogColor(12638463).waterColor(4159204).waterFogColor(329011).skyColor(7972607).grassColorModifier(BiomeSpecialEffects.GrassColorModifier.DARK_FOREST).build()).generationSettings(DUMMY_GENERATION_SETTINGS).mobSpawnSettings(DUMMY_MOB_SPAWN_SETTINGS).build());
            MAP.put(30, new Biome.BiomeBuilder().hasPrecipitation(true).temperature(-0.5f).downfall(0.4f).specialEffects(new BiomeSpecialEffects.Builder().fogColor(12638463).waterColor(4020182).waterFogColor(329011).skyColor(8625919).build()).generationSettings(DUMMY_GENERATION_SETTINGS).mobSpawnSettings(DUMMY_MOB_SPAWN_SETTINGS).build());
            MAP.put(31, new Biome.BiomeBuilder().hasPrecipitation(true).temperature(-0.5f).downfall(0.4f).specialEffects(new BiomeSpecialEffects.Builder().fogColor(12638463).waterColor(4020182).waterFogColor(329011).skyColor(8625919).build()).generationSettings(DUMMY_GENERATION_SETTINGS).mobSpawnSettings(DUMMY_MOB_SPAWN_SETTINGS).build());
            MAP.put(32, new Biome.BiomeBuilder().hasPrecipitation(true).temperature(0.3f).downfall(0.8f).specialEffects(new BiomeSpecialEffects.Builder().fogColor(12638463).waterColor(4159204).waterFogColor(329011).skyColor(8168447).build()).generationSettings(DUMMY_GENERATION_SETTINGS).mobSpawnSettings(DUMMY_MOB_SPAWN_SETTINGS).build());
            MAP.put(33, new Biome.BiomeBuilder().hasPrecipitation(true).temperature(0.3f).downfall(0.8f).specialEffects(new BiomeSpecialEffects.Builder().fogColor(12638463).waterColor(4159204).waterFogColor(329011).skyColor(8168447).build()).generationSettings(DUMMY_GENERATION_SETTINGS).mobSpawnSettings(DUMMY_MOB_SPAWN_SETTINGS).build());
            MAP.put(34, new Biome.BiomeBuilder().hasPrecipitation(true).temperature(0.2f).downfall(0.3f).specialEffects(new BiomeSpecialEffects.Builder().fogColor(12638463).waterColor(4159204).waterFogColor(329011).skyColor(8233727).build()).generationSettings(DUMMY_GENERATION_SETTINGS).mobSpawnSettings(DUMMY_MOB_SPAWN_SETTINGS).build());
            MAP.put(35, new Biome.BiomeBuilder().hasPrecipitation(false).temperature(1.2f).downfall(0.0f).specialEffects(new BiomeSpecialEffects.Builder().fogColor(12638463).waterColor(4159204).waterFogColor(329011).skyColor(7711487).build()).generationSettings(DUMMY_GENERATION_SETTINGS).mobSpawnSettings(DUMMY_MOB_SPAWN_SETTINGS).build());
            MAP.put(36, new Biome.BiomeBuilder().hasPrecipitation(false).temperature(1.0f).downfall(0.0f).specialEffects(new BiomeSpecialEffects.Builder().fogColor(12638463).waterColor(4159204).waterFogColor(329011).skyColor(7776511).build()).generationSettings(DUMMY_GENERATION_SETTINGS).mobSpawnSettings(DUMMY_MOB_SPAWN_SETTINGS).build());
            MAP.put(37, new Biome.BiomeBuilder().hasPrecipitation(false).temperature(2.0f).downfall(0.0f).specialEffects(new BiomeSpecialEffects.Builder().fogColor(12638463).waterColor(4159204).waterFogColor(329011).skyColor(7254527).foliageColorOverride(10387789).grassColorOverride(9470285).build()).generationSettings(DUMMY_GENERATION_SETTINGS).mobSpawnSettings(DUMMY_MOB_SPAWN_SETTINGS).build());
            MAP.put(38, new Biome.BiomeBuilder().hasPrecipitation(false).temperature(2.0f).downfall(0.0f).specialEffects(new BiomeSpecialEffects.Builder().fogColor(12638463).waterColor(4159204).waterFogColor(329011).skyColor(7254527).foliageColorOverride(10387789).grassColorOverride(9470285).build()).generationSettings(DUMMY_GENERATION_SETTINGS).mobSpawnSettings(DUMMY_MOB_SPAWN_SETTINGS).build());
            MAP.put(39, new Biome.BiomeBuilder().hasPrecipitation(false).temperature(2.0f).downfall(0.0f).specialEffects(new BiomeSpecialEffects.Builder().fogColor(12638463).waterColor(4159204).waterFogColor(329011).skyColor(7254527).foliageColorOverride(10387789).grassColorOverride(9470285).build()).generationSettings(DUMMY_GENERATION_SETTINGS).mobSpawnSettings(DUMMY_MOB_SPAWN_SETTINGS).build());
            MAP.put(40, new Biome.BiomeBuilder().hasPrecipitation(false).temperature(0.5f).downfall(0.5f).specialEffects(new BiomeSpecialEffects.Builder().fogColor(0xA080A0).waterColor(4159204).waterFogColor(329011).skyColor(0).build()).generationSettings(DUMMY_GENERATION_SETTINGS).mobSpawnSettings(DUMMY_MOB_SPAWN_SETTINGS).build());
            MAP.put(41, new Biome.BiomeBuilder().hasPrecipitation(false).temperature(0.5f).downfall(0.5f).specialEffects(new BiomeSpecialEffects.Builder().fogColor(0xA080A0).waterColor(4159204).waterFogColor(329011).skyColor(0).build()).generationSettings(DUMMY_GENERATION_SETTINGS).mobSpawnSettings(DUMMY_MOB_SPAWN_SETTINGS).build());
            MAP.put(42, new Biome.BiomeBuilder().hasPrecipitation(false).temperature(0.5f).downfall(0.5f).specialEffects(new BiomeSpecialEffects.Builder().fogColor(0xA080A0).waterColor(4159204).waterFogColor(329011).skyColor(0).build()).generationSettings(DUMMY_GENERATION_SETTINGS).mobSpawnSettings(DUMMY_MOB_SPAWN_SETTINGS).build());
            MAP.put(43, new Biome.BiomeBuilder().hasPrecipitation(false).temperature(0.5f).downfall(0.5f).specialEffects(new BiomeSpecialEffects.Builder().fogColor(0xA080A0).waterColor(4159204).waterFogColor(329011).skyColor(0).build()).generationSettings(DUMMY_GENERATION_SETTINGS).mobSpawnSettings(DUMMY_MOB_SPAWN_SETTINGS).build());
            MAP.put(44, new Biome.BiomeBuilder().hasPrecipitation(true).temperature(0.5f).downfall(0.5f).specialEffects(new BiomeSpecialEffects.Builder().fogColor(12638463).waterColor(4445678).waterFogColor(270131).skyColor(8103167).build()).generationSettings(DUMMY_GENERATION_SETTINGS).mobSpawnSettings(DUMMY_MOB_SPAWN_SETTINGS).build());
            MAP.put(45, new Biome.BiomeBuilder().hasPrecipitation(true).temperature(0.5f).downfall(0.5f).specialEffects(new BiomeSpecialEffects.Builder().fogColor(12638463).waterColor(4566514).waterFogColor(267827).skyColor(8103167).build()).generationSettings(DUMMY_GENERATION_SETTINGS).mobSpawnSettings(DUMMY_MOB_SPAWN_SETTINGS).build());
            MAP.put(46, new Biome.BiomeBuilder().hasPrecipitation(true).temperature(0.5f).downfall(0.5f).specialEffects(new BiomeSpecialEffects.Builder().fogColor(12638463).waterColor(4020182).waterFogColor(329011).skyColor(8103167).build()).generationSettings(DUMMY_GENERATION_SETTINGS).mobSpawnSettings(DUMMY_MOB_SPAWN_SETTINGS).build());
            MAP.put(47, new Biome.BiomeBuilder().hasPrecipitation(true).temperature(0.5f).downfall(0.5f).specialEffects(new BiomeSpecialEffects.Builder().fogColor(12638463).waterColor(4445678).waterFogColor(270131).skyColor(8103167).build()).generationSettings(DUMMY_GENERATION_SETTINGS).mobSpawnSettings(DUMMY_MOB_SPAWN_SETTINGS).build());
            MAP.put(48, new Biome.BiomeBuilder().hasPrecipitation(true).temperature(0.5f).downfall(0.5f).specialEffects(new BiomeSpecialEffects.Builder().fogColor(12638463).waterColor(4566514).waterFogColor(267827).skyColor(8103167).build()).generationSettings(DUMMY_GENERATION_SETTINGS).mobSpawnSettings(DUMMY_MOB_SPAWN_SETTINGS).build());
            MAP.put(49, new Biome.BiomeBuilder().hasPrecipitation(true).temperature(0.5f).downfall(0.5f).specialEffects(new BiomeSpecialEffects.Builder().fogColor(12638463).waterColor(4020182).waterFogColor(329011).skyColor(8103167).build()).generationSettings(DUMMY_GENERATION_SETTINGS).mobSpawnSettings(DUMMY_MOB_SPAWN_SETTINGS).build());
            MAP.put(50, new Biome.BiomeBuilder().hasPrecipitation(true).temperature(0.5f).downfall(0.5f).temperatureAdjustment(Biome.TemperatureModifier.FROZEN).specialEffects(new BiomeSpecialEffects.Builder().fogColor(12638463).waterColor(3750089).waterFogColor(329011).skyColor(8103167).build()).generationSettings(DUMMY_GENERATION_SETTINGS).mobSpawnSettings(DUMMY_MOB_SPAWN_SETTINGS).build());
            MAP.put(129, new Biome.BiomeBuilder().hasPrecipitation(true).temperature(0.8f).downfall(0.4f).specialEffects(new BiomeSpecialEffects.Builder().fogColor(12638463).waterColor(4159204).waterFogColor(329011).skyColor(7907327).build()).generationSettings(DUMMY_GENERATION_SETTINGS).mobSpawnSettings(DUMMY_MOB_SPAWN_SETTINGS).build());
            MAP.put(130, new Biome.BiomeBuilder().hasPrecipitation(false).temperature(2.0f).downfall(0.0f).specialEffects(new BiomeSpecialEffects.Builder().fogColor(12638463).waterColor(4159204).waterFogColor(329011).skyColor(7254527).build()).generationSettings(DUMMY_GENERATION_SETTINGS).mobSpawnSettings(DUMMY_MOB_SPAWN_SETTINGS).build());
            MAP.put(131, new Biome.BiomeBuilder().hasPrecipitation(true).temperature(0.2f).downfall(0.3f).specialEffects(new BiomeSpecialEffects.Builder().fogColor(12638463).waterColor(4159204).waterFogColor(329011).skyColor(8233727).build()).generationSettings(DUMMY_GENERATION_SETTINGS).mobSpawnSettings(DUMMY_MOB_SPAWN_SETTINGS).build());
            MAP.put(132, new Biome.BiomeBuilder().hasPrecipitation(true).temperature(0.7f).downfall(0.8f).specialEffects(new BiomeSpecialEffects.Builder().fogColor(12638463).waterColor(4159204).waterFogColor(329011).skyColor(7972607).build()).generationSettings(DUMMY_GENERATION_SETTINGS).mobSpawnSettings(DUMMY_MOB_SPAWN_SETTINGS).build());
            MAP.put(133, new Biome.BiomeBuilder().hasPrecipitation(true).temperature(0.25f).downfall(0.8f).specialEffects(new BiomeSpecialEffects.Builder().fogColor(12638463).waterColor(4159204).waterFogColor(329011).skyColor(8233983).build()).generationSettings(DUMMY_GENERATION_SETTINGS).mobSpawnSettings(DUMMY_MOB_SPAWN_SETTINGS).build());
            MAP.put(134, new Biome.BiomeBuilder().hasPrecipitation(true).temperature(0.8f).downfall(0.9f).specialEffects(new BiomeSpecialEffects.Builder().fogColor(12638463).waterColor(6388580).waterFogColor(2302743).skyColor(7907327).foliageColorOverride(6975545).grassColorModifier(BiomeSpecialEffects.GrassColorModifier.SWAMP).build()).generationSettings(DUMMY_GENERATION_SETTINGS).mobSpawnSettings(DUMMY_MOB_SPAWN_SETTINGS).build());
            MAP.put(140, new Biome.BiomeBuilder().hasPrecipitation(true).temperature(0.0f).downfall(0.5f).specialEffects(new BiomeSpecialEffects.Builder().fogColor(12638463).waterColor(4159204).waterFogColor(329011).skyColor(8364543).build()).generationSettings(DUMMY_GENERATION_SETTINGS).mobSpawnSettings(DUMMY_MOB_SPAWN_SETTINGS).build());
            MAP.put(149, new Biome.BiomeBuilder().hasPrecipitation(true).temperature(0.95f).downfall(0.9f).specialEffects(new BiomeSpecialEffects.Builder().fogColor(12638463).waterColor(4159204).waterFogColor(329011).skyColor(7842047).build()).generationSettings(DUMMY_GENERATION_SETTINGS).mobSpawnSettings(DUMMY_MOB_SPAWN_SETTINGS).build());
            MAP.put(151, new Biome.BiomeBuilder().hasPrecipitation(true).temperature(0.95f).downfall(0.8f).specialEffects(new BiomeSpecialEffects.Builder().fogColor(12638463).waterColor(4159204).waterFogColor(329011).skyColor(7842047).build()).generationSettings(DUMMY_GENERATION_SETTINGS).mobSpawnSettings(DUMMY_MOB_SPAWN_SETTINGS).build());
            MAP.put(155, new Biome.BiomeBuilder().hasPrecipitation(true).temperature(0.6f).downfall(0.6f).specialEffects(new BiomeSpecialEffects.Builder().fogColor(12638463).waterColor(4159204).waterFogColor(329011).skyColor(8037887).build()).generationSettings(DUMMY_GENERATION_SETTINGS).mobSpawnSettings(DUMMY_MOB_SPAWN_SETTINGS).build());
            MAP.put(156, new Biome.BiomeBuilder().hasPrecipitation(true).temperature(0.6f).downfall(0.6f).specialEffects(new BiomeSpecialEffects.Builder().fogColor(12638463).waterColor(4159204).waterFogColor(329011).skyColor(8037887).build()).generationSettings(DUMMY_GENERATION_SETTINGS).mobSpawnSettings(DUMMY_MOB_SPAWN_SETTINGS).build());
            MAP.put(157, new Biome.BiomeBuilder().hasPrecipitation(true).temperature(0.7f).downfall(0.8f).specialEffects(new BiomeSpecialEffects.Builder().fogColor(12638463).waterColor(4159204).waterFogColor(329011).skyColor(7972607).grassColorModifier(BiomeSpecialEffects.GrassColorModifier.DARK_FOREST).build()).generationSettings(DUMMY_GENERATION_SETTINGS).mobSpawnSettings(DUMMY_MOB_SPAWN_SETTINGS).build());
            MAP.put(158, new Biome.BiomeBuilder().hasPrecipitation(true).temperature(-0.5f).downfall(0.4f).specialEffects(new BiomeSpecialEffects.Builder().fogColor(12638463).waterColor(4020182).waterFogColor(329011).skyColor(8625919).build()).generationSettings(DUMMY_GENERATION_SETTINGS).mobSpawnSettings(DUMMY_MOB_SPAWN_SETTINGS).build());
            MAP.put(160, new Biome.BiomeBuilder().hasPrecipitation(true).temperature(0.25f).downfall(0.8f).specialEffects(new BiomeSpecialEffects.Builder().fogColor(12638463).waterColor(4159204).waterFogColor(329011).skyColor(8233983).build()).generationSettings(DUMMY_GENERATION_SETTINGS).mobSpawnSettings(DUMMY_MOB_SPAWN_SETTINGS).build());
            MAP.put(161, new Biome.BiomeBuilder().hasPrecipitation(true).temperature(0.25f).downfall(0.8f).specialEffects(new BiomeSpecialEffects.Builder().fogColor(12638463).waterColor(4159204).waterFogColor(329011).skyColor(8233983).build()).generationSettings(DUMMY_GENERATION_SETTINGS).mobSpawnSettings(DUMMY_MOB_SPAWN_SETTINGS).build());
            MAP.put(162, new Biome.BiomeBuilder().hasPrecipitation(true).temperature(0.2f).downfall(0.3f).specialEffects(new BiomeSpecialEffects.Builder().fogColor(12638463).waterColor(4159204).waterFogColor(329011).skyColor(8233727).build()).generationSettings(DUMMY_GENERATION_SETTINGS).mobSpawnSettings(DUMMY_MOB_SPAWN_SETTINGS).build());
            MAP.put(163, new Biome.BiomeBuilder().hasPrecipitation(false).temperature(1.1f).downfall(0.0f).specialEffects(new BiomeSpecialEffects.Builder().fogColor(12638463).waterColor(4159204).waterFogColor(329011).skyColor(7776767).build()).generationSettings(DUMMY_GENERATION_SETTINGS).mobSpawnSettings(DUMMY_MOB_SPAWN_SETTINGS).build());
            MAP.put(164, new Biome.BiomeBuilder().hasPrecipitation(false).temperature(1.0f).downfall(0.0f).specialEffects(new BiomeSpecialEffects.Builder().fogColor(12638463).waterColor(4159204).waterFogColor(329011).skyColor(7776511).build()).generationSettings(DUMMY_GENERATION_SETTINGS).mobSpawnSettings(DUMMY_MOB_SPAWN_SETTINGS).build());
            MAP.put(165, new Biome.BiomeBuilder().hasPrecipitation(false).temperature(2.0f).downfall(0.0f).specialEffects(new BiomeSpecialEffects.Builder().fogColor(12638463).waterColor(4159204).waterFogColor(329011).skyColor(7254527).foliageColorOverride(10387789).grassColorOverride(9470285).build()).generationSettings(DUMMY_GENERATION_SETTINGS).mobSpawnSettings(DUMMY_MOB_SPAWN_SETTINGS).build());
            MAP.put(166, new Biome.BiomeBuilder().hasPrecipitation(false).temperature(2.0f).downfall(0.0f).specialEffects(new BiomeSpecialEffects.Builder().fogColor(12638463).waterColor(4159204).waterFogColor(329011).skyColor(7254527).foliageColorOverride(10387789).grassColorOverride(9470285).build()).generationSettings(DUMMY_GENERATION_SETTINGS).mobSpawnSettings(DUMMY_MOB_SPAWN_SETTINGS).build());
            MAP.put(167, new Biome.BiomeBuilder().hasPrecipitation(false).temperature(2.0f).downfall(0.0f).specialEffects(new BiomeSpecialEffects.Builder().fogColor(12638463).waterColor(4159204).waterFogColor(329011).skyColor(7254527).foliageColorOverride(10387789).grassColorOverride(9470285).build()).generationSettings(DUMMY_GENERATION_SETTINGS).mobSpawnSettings(DUMMY_MOB_SPAWN_SETTINGS).build());
            MAP.put(168, new Biome.BiomeBuilder().hasPrecipitation(true).temperature(0.95f).downfall(0.9f).specialEffects(new BiomeSpecialEffects.Builder().fogColor(12638463).waterColor(4159204).waterFogColor(329011).skyColor(7842047).build()).generationSettings(DUMMY_GENERATION_SETTINGS).mobSpawnSettings(DUMMY_MOB_SPAWN_SETTINGS).build());
            MAP.put(169, new Biome.BiomeBuilder().hasPrecipitation(true).temperature(0.95f).downfall(0.9f).specialEffects(new BiomeSpecialEffects.Builder().fogColor(12638463).waterColor(4159204).waterFogColor(329011).skyColor(7842047).build()).generationSettings(DUMMY_GENERATION_SETTINGS).mobSpawnSettings(DUMMY_MOB_SPAWN_SETTINGS).build());
            MAP.put(170, new Biome.BiomeBuilder().hasPrecipitation(false).temperature(2.0f).downfall(0.0f).specialEffects(new BiomeSpecialEffects.Builder().fogColor(1787717).waterColor(4159204).waterFogColor(329011).skyColor(7254527).ambientParticle(new AmbientParticleSettings((ParticleOptions)BuiltInRegistries.PARTICLE_TYPE.get(ResourceLocation.parse((String)"minecraft:ash")), 0.00625f)).build()).generationSettings(DUMMY_GENERATION_SETTINGS).mobSpawnSettings(DUMMY_MOB_SPAWN_SETTINGS).build());
            MAP.put(171, new Biome.BiomeBuilder().hasPrecipitation(false).temperature(2.0f).downfall(0.0f).specialEffects(new BiomeSpecialEffects.Builder().fogColor(0x330303).waterColor(4159204).waterFogColor(329011).skyColor(7254527).ambientParticle(new AmbientParticleSettings((ParticleOptions)BuiltInRegistries.PARTICLE_TYPE.get(ResourceLocation.parse((String)"minecraft:crimson_spore")), 0.025f)).build()).generationSettings(DUMMY_GENERATION_SETTINGS).mobSpawnSettings(DUMMY_MOB_SPAWN_SETTINGS).build());
            MAP.put(172, new Biome.BiomeBuilder().hasPrecipitation(false).temperature(2.0f).downfall(0.0f).specialEffects(new BiomeSpecialEffects.Builder().fogColor(1705242).waterColor(4159204).waterFogColor(329011).skyColor(7254527).ambientParticle(new AmbientParticleSettings((ParticleOptions)BuiltInRegistries.PARTICLE_TYPE.get(ResourceLocation.parse((String)"minecraft:warped_spore")), 0.01428f)).build()).generationSettings(DUMMY_GENERATION_SETTINGS).mobSpawnSettings(DUMMY_MOB_SPAWN_SETTINGS).build());
            MAP.put(173, new Biome.BiomeBuilder().hasPrecipitation(false).temperature(2.0f).downfall(0.0f).specialEffects(new BiomeSpecialEffects.Builder().fogColor(6840176).waterColor(4159204).waterFogColor(4341314).skyColor(7254527).ambientParticle(new AmbientParticleSettings((ParticleOptions)BuiltInRegistries.PARTICLE_TYPE.get(ResourceLocation.parse((String)"minecraft:white_ash")), 0.118093f)).build()).generationSettings(DUMMY_GENERATION_SETTINGS).mobSpawnSettings(DUMMY_MOB_SPAWN_SETTINGS).build());
        }
    }

    private static interface BiomeMapper {
        public int getId(Biome var1);

        public Biome getBiome(int var1);
    }
}

