/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openvr;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.openvr.VRTextureDepthInfo;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct VRTextureWithDepth_t")
public class VRTextureWithDepth
extends Struct<VRTextureWithDepth>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int HANDLE;
    public static final int ETYPE;
    public static final int ECOLORSPACE;
    public static final int DEPTH;

    protected VRTextureWithDepth(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected VRTextureWithDepth create(long address, @Nullable ByteBuffer container) {
        return new VRTextureWithDepth(address, container);
    }

    public VRTextureWithDepth(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), VRTextureWithDepth.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="void *")
    public long handle() {
        return VRTextureWithDepth.nhandle(this.address());
    }

    @NativeType(value="ETextureType")
    public int eType() {
        return VRTextureWithDepth.neType(this.address());
    }

    @NativeType(value="EColorSpace")
    public int eColorSpace() {
        return VRTextureWithDepth.neColorSpace(this.address());
    }

    @NativeType(value="VRTextureDepthInfo_t")
    public VRTextureDepthInfo depth() {
        return VRTextureWithDepth.ndepth(this.address());
    }

    public VRTextureWithDepth handle(@NativeType(value="void *") long value) {
        VRTextureWithDepth.nhandle(this.address(), value);
        return this;
    }

    public VRTextureWithDepth eType(@NativeType(value="ETextureType") int value) {
        VRTextureWithDepth.neType(this.address(), value);
        return this;
    }

    public VRTextureWithDepth eColorSpace(@NativeType(value="EColorSpace") int value) {
        VRTextureWithDepth.neColorSpace(this.address(), value);
        return this;
    }

    public VRTextureWithDepth depth(@NativeType(value="VRTextureDepthInfo_t") VRTextureDepthInfo value) {
        VRTextureWithDepth.ndepth(this.address(), value);
        return this;
    }

    public VRTextureWithDepth depth(Consumer<VRTextureDepthInfo> consumer) {
        consumer.accept(this.depth());
        return this;
    }

    public VRTextureWithDepth set(long handle, int eType, int eColorSpace, VRTextureDepthInfo depth) {
        this.handle(handle);
        this.eType(eType);
        this.eColorSpace(eColorSpace);
        this.depth(depth);
        return this;
    }

    public VRTextureWithDepth set(VRTextureWithDepth src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static VRTextureWithDepth malloc() {
        return new VRTextureWithDepth(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static VRTextureWithDepth calloc() {
        return new VRTextureWithDepth(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static VRTextureWithDepth create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new VRTextureWithDepth(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static VRTextureWithDepth create(long address) {
        return new VRTextureWithDepth(address, null);
    }

    @Nullable
    public static VRTextureWithDepth createSafe(long address) {
        return address == 0L ? null : new VRTextureWithDepth(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)VRTextureWithDepth.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VRTextureWithDepth.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    @Deprecated
    public static VRTextureWithDepth mallocStack() {
        return VRTextureWithDepth.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VRTextureWithDepth callocStack() {
        return VRTextureWithDepth.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VRTextureWithDepth mallocStack(MemoryStack stack) {
        return VRTextureWithDepth.malloc(stack);
    }

    @Deprecated
    public static VRTextureWithDepth callocStack(MemoryStack stack) {
        return VRTextureWithDepth.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return VRTextureWithDepth.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return VRTextureWithDepth.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VRTextureWithDepth.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VRTextureWithDepth.calloc(capacity, stack);
    }

    public static VRTextureWithDepth malloc(MemoryStack stack) {
        return new VRTextureWithDepth(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static VRTextureWithDepth calloc(MemoryStack stack) {
        return new VRTextureWithDepth(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static long nhandle(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)HANDLE));
    }

    public static int neType(long struct) {
        return UNSAFE.getInt(null, struct + (long)ETYPE);
    }

    public static int neColorSpace(long struct) {
        return UNSAFE.getInt(null, struct + (long)ECOLORSPACE);
    }

    public static VRTextureDepthInfo ndepth(long struct) {
        return VRTextureDepthInfo.create(struct + (long)DEPTH);
    }

    public static void nhandle(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)HANDLE), (long)Checks.check((long)value));
    }

    public static void neType(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)ETYPE, value);
    }

    public static void neColorSpace(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)ECOLORSPACE, value);
    }

    public static void ndepth(long struct, VRTextureDepthInfo value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)DEPTH), (long)VRTextureDepthInfo.SIZEOF);
    }

    public static void validate(long struct) {
        Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)HANDLE)));
        VRTextureDepthInfo.validate(struct + (long)DEPTH);
    }

    static {
        Struct.Layout layout = VRTextureWithDepth.__struct((Struct.Member[])new Struct.Member[]{VRTextureWithDepth.__member((int)POINTER_SIZE), VRTextureWithDepth.__member((int)4), VRTextureWithDepth.__member((int)4), VRTextureWithDepth.__member((int)VRTextureDepthInfo.SIZEOF, (int)VRTextureDepthInfo.ALIGNOF)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        HANDLE = layout.offsetof(0);
        ETYPE = layout.offsetof(1);
        ECOLORSPACE = layout.offsetof(2);
        DEPTH = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<VRTextureWithDepth, Buffer>
    implements NativeResource {
        private static final VRTextureWithDepth ELEMENT_FACTORY = VRTextureWithDepth.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected VRTextureWithDepth getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="void *")
        public long handle() {
            return VRTextureWithDepth.nhandle(this.address());
        }

        @NativeType(value="ETextureType")
        public int eType() {
            return VRTextureWithDepth.neType(this.address());
        }

        @NativeType(value="EColorSpace")
        public int eColorSpace() {
            return VRTextureWithDepth.neColorSpace(this.address());
        }

        @NativeType(value="VRTextureDepthInfo_t")
        public VRTextureDepthInfo depth() {
            return VRTextureWithDepth.ndepth(this.address());
        }

        public Buffer handle(@NativeType(value="void *") long value) {
            VRTextureWithDepth.nhandle(this.address(), value);
            return this;
        }

        public Buffer eType(@NativeType(value="ETextureType") int value) {
            VRTextureWithDepth.neType(this.address(), value);
            return this;
        }

        public Buffer eColorSpace(@NativeType(value="EColorSpace") int value) {
            VRTextureWithDepth.neColorSpace(this.address(), value);
            return this;
        }

        public Buffer depth(@NativeType(value="VRTextureDepthInfo_t") VRTextureDepthInfo value) {
            VRTextureWithDepth.ndepth(this.address(), value);
            return this;
        }

        public Buffer depth(Consumer<VRTextureDepthInfo> consumer) {
            consumer.accept(this.depth());
            return this;
        }
    }
}

