/*
 * Decompiled with CFR 0.152.
 */
package org.sinytra.adapter.patch.util;

import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.Nullable;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;

public record MethodQualifier(@Nullable String owner, @Nullable String name, @Nullable String desc) {
    public static final Pattern METHOD_QUALIFIER_PATTERN = Pattern.compile("^(?<owner>L.+?;)?(?<name>[^(:]+)?(?<desc>\\((?:\\[*[ZCBSIFJD]|\\[*L[a-zA-Z0-9/_$]+;)*\\)(?:\\[*[VZCBSIFJD]|\\[?L[a-zA-Z0-9/_;$]+))?$");

    public MethodQualifier(@Nullable String name, @Nullable String desc) {
        this(null, name, desc);
    }

    @Nullable
    public static Optional<MethodQualifier> create(String qualifier) {
        Matcher matcher = METHOD_QUALIFIER_PATTERN.matcher(qualifier);
        if (matcher.matches()) {
            String name = matcher.group("name");
            String desc = matcher.group("desc");
            if (name != null || desc != null) {
                return Optional.of(new MethodQualifier(matcher.group("owner"), name, desc));
            }
        }
        return Optional.empty();
    }

    public static MethodQualifier create(ClassNode classNode, MethodNode methodNode) {
        return new MethodQualifier(Type.getObjectType((String)classNode.name).getDescriptor(), methodNode.name, methodNode.desc);
    }

    public static MethodQualifier create(MethodNode methodNode) {
        return new MethodQualifier(null, methodNode.name, methodNode.desc);
    }

    public static MethodQualifier create(MethodInsnNode minsn) {
        return new MethodQualifier(Type.getObjectType((String)minsn.owner).getDescriptor(), minsn.name, minsn.desc);
    }

    @Nullable
    public String internalOwnerName() {
        return this.owner != null ? Type.getType((String)this.owner).getInternalName() : null;
    }

    public boolean matches(MethodQualifier other) {
        return this.matches(other.owner(), other.name(), other.desc());
    }

    public boolean matches(MethodInsnNode insn) {
        return this.matches(Type.getObjectType((String)insn.owner).getDescriptor(), insn.name, insn.desc);
    }

    public boolean matches(@Nullable String owner, @Nullable String name, @Nullable String desc) {
        return !(this.owner != null && !this.owner.equals(owner) || this.name == null || !this.name.equals(name) || this.desc != null && !this.desc.equals(desc));
    }

    public boolean isFull() {
        return this.owner != null && this.name != null && this.desc != null;
    }

    public String asDescriptor() {
        Object result = "";
        if (this.owner != null) {
            result = (String)result + this.owner;
        }
        return (String)result + this.name + (this.desc != null ? this.desc : "");
    }
}

