/*
 * Decompiled with CFR 0.152.
 */
package com.jesz.createdieselgenerators.events;

import com.jesz.createdieselgenerators.CDGBlocks;
import com.jesz.createdieselgenerators.CDGConfig;
import com.jesz.createdieselgenerators.CDGDataComponents;
import com.jesz.createdieselgenerators.CDGItems;
import com.jesz.createdieselgenerators.CDGRegistries;
import com.jesz.createdieselgenerators.commands.CDGCommands;
import com.jesz.createdieselgenerators.content.andesite_girder.AndesiteGirderWrenchBehaviour;
import com.jesz.createdieselgenerators.content.diesel_engine.EngineTypes;
import com.jesz.createdieselgenerators.content.entity_filter.EntityFilteringRenderer;
import com.jesz.createdieselgenerators.content.entity_filter.ReverseLootTable;
import com.jesz.createdieselgenerators.events.EntityTickEvent;
import com.jesz.createdieselgenerators.fuel_type.FuelType;
import com.jesz.createdieselgenerators.mixins.LootPoolAccessor;
import com.jesz.createdieselgenerators.mixins.LootTableAccessor;
import com.mojang.brigadier.CommandDispatcher;
import com.simibubi.create.content.equipment.goggles.GogglesItem;
import com.simibubi.create.content.kinetics.base.IRotate;
import com.simibubi.create.foundation.item.TooltipHelper;
import com.simibubi.create.foundation.utility.CreateLang;
import com.simibubi.create.infrastructure.config.AllConfigs;
import com.simibubi.create.infrastructure.config.CKinetics;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.createmod.catnip.animation.AnimationTickHolder;
import net.createmod.catnip.lang.FontHelper;
import net.createmod.catnip.lang.Lang;
import net.createmod.catnip.lang.LangBuilder;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.MilkBucketItem;
import net.minecraft.world.item.trading.ItemCost;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import net.neoforged.neoforge.common.NeoForgeMod;
import net.neoforged.neoforge.event.AddReloadListenerEvent;
import net.neoforged.neoforge.event.LootTableLoadEvent;
import net.neoforged.neoforge.event.RegisterCommandsEvent;
import net.neoforged.neoforge.event.entity.player.ItemTooltipEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.level.ExplosionEvent;
import net.neoforged.neoforge.event.tick.LevelTickEvent;
import net.neoforged.neoforge.event.village.VillagerTradesEvent;

@EventBusSubscriber(modid="createdieselgenerators", bus=EventBusSubscriber.Bus.GAME)
public class GameEvents {
    static Map<Level, Set<BlockPos>> toExplode = new HashMap<Level, Set<BlockPos>>();

    @SubscribeEvent
    public static void onCommandRegister(RegisterCommandsEvent event) {
        new CDGCommands((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
    }

    @SubscribeEvent
    public static void loadLootTable(LootTableLoadEvent event) {
        LootTable table = event.getTable();
        ResourceLocation tableId = table.getLootTableId();
        if (!tableId.getPath().startsWith("entities/")) {
            return;
        }
        LinkedList results = new LinkedList();
        ((LootTableAccessor)table).getPools().forEach(pool -> List.of(((LootPoolAccessor)pool).getEntries()).forEach(e -> {
            if (e instanceof LootItem) {
                LootItem lootItem = (LootItem)e;
                lootItem.createItemStack(stack -> {
                    String path = tableId.getPath();
                    path = path.replaceAll("entities/", "");
                    EntityType type = (EntityType)BuiltInRegistries.ENTITY_TYPE.get(ResourceLocation.fromNamespaceAndPath((String)tableId.getNamespace(), (String)path));
                    ReverseLootTable.ALL.computeIfAbsent(stack.getItem(), s -> new ArrayList()).add(type);
                }, null);
            }
        }));
    }

    @SubscribeEvent
    public static void playerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
    }

    @SubscribeEvent
    public static void addReloadListeners(AddReloadListenerEvent event) {
        event.addListener((PreparableReloadListener)ReverseLootTable.INSTANCE);
    }

    @SubscribeEvent
    public static void onClientTick(ClientTickEvent.Post event) {
        AndesiteGirderWrenchBehaviour.tick();
        EntityFilteringRenderer.tick();
    }

    @SubscribeEvent
    public static void onServerTick(LevelTickEvent.Post event) {
        Level level = event.getLevel();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel level2 = (ServerLevel)level;
        if (toExplode.containsKey(level2)) {
            List list = toExplode.get(level2).stream().toList();
            if (list.isEmpty()) {
                return;
            }
            for (BlockPos pos : list) {
                level2.explode(null, null, null, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), 1.0f, true, Level.ExplosionInteraction.BLOCK);
                toExplode.get(level2).remove(pos);
            }
        }
    }

    @SubscribeEvent
    public static void onEntityTick(EntityTickEvent event) {
        Entity entity = event.entity;
        if (!(entity instanceof ItemEntity)) {
            return;
        }
        ItemEntity itemEntity = (ItemEntity)entity;
        ItemStack item = itemEntity.getItem();
        if (item.is((Item)CDGItems.LIGHTER.get()) && ((Boolean)CDGConfig.COMBUSTIBLES_BLOW_UP.get()).booleanValue() && item.has(CDGDataComponents.LIGHTER_STATE) && (Integer)item.get(CDGDataComponents.LIGHTER_STATE) == 2) {
            boolean flammable;
            Vec3 entityPos = itemEntity.getPosition(1.0f);
            FluidState fState = itemEntity.level().getFluidState(new BlockPos((Vec3i)BlockPos.containing((Position)entityPos)));
            if (fState.is((Fluid)Fluids.WATER) || fState.is((Fluid)Fluids.FLOWING_WATER)) {
                item.set(CDGDataComponents.LIGHTER_STATE, (Object)1);
                itemEntity.level().playLocalSound(itemEntity.getPosition((float)1.0f).x, itemEntity.getPosition((float)1.0f).y, itemEntity.getPosition((float)1.0f).z, SoundEvents.CANDLE_EXTINGUISH, SoundSource.BLOCKS, 1.0f, 1.0f, false);
                return;
            }
            boolean bl = flammable = FuelType.getTypeFor((HolderLookup.RegistryLookup<FuelType>)itemEntity.level().registryAccess().lookupOrThrow(CDGRegistries.FUEL_TYPE), fState.getType()).normal().speed() != 0.0f;
            if (flammable) {
                itemEntity.level().explode(null, null, null, itemEntity.getPosition((float)1.0f).x, itemEntity.getPosition((float)1.0f).y, itemEntity.getPosition((float)1.0f).z, 1.0f, true, Level.ExplosionInteraction.BLOCK);
            }
        }
    }

    @SubscribeEvent
    public static void onExplosion(ExplosionEvent.Detonate event) {
        Level level = event.getLevel();
        if (((Boolean)CDGConfig.COMBUSTIBLES_BLOW_UP.get()).booleanValue() && !level.isClientSide) {
            for (int x = -2; x < 2; ++x) {
                for (int y = -2; y < 2; ++y) {
                    for (int z = -2; z < 2; ++z) {
                        boolean flammable;
                        BlockPos pos = new BlockPos((int)((double)x + event.getExplosion().center().x), (int)((double)y + event.getExplosion().center().y), (int)((double)z + event.getExplosion().center().z));
                        if (!level.isInWorldBounds(pos) || !(Math.abs(Math.sqrt(x * x + y * y + z * z)) < 2.0)) continue;
                        FluidState fluidState = level.getFluidState(pos);
                        boolean bl = flammable = FuelType.getTypeFor((HolderLookup.RegistryLookup<FuelType>)level.registryAccess().lookupOrThrow(CDGRegistries.FUEL_TYPE), fluidState.getType()).normal().speed() != 0.0f;
                        if (!flammable) continue;
                        level.setBlockAndUpdate(pos, Blocks.AIR.defaultBlockState());
                        if (!toExplode.containsKey(level)) {
                            toExplode.put(level, new HashSet());
                        }
                        toExplode.get(level).add(pos);
                        return;
                    }
                }
            }
        }
    }

    @SubscribeEvent
    public static void addTrade(VillagerTradesEvent event) {
        Int2ObjectMap trades = event.getTrades();
        if (event.getType() != VillagerProfession.TOOLSMITH) {
            return;
        }
        ((List)trades.get(2)).add((t, r) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 5), new ItemStack((ItemLike)CDGItems.LIGHTER.get()), 10, 8, 0.02f));
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public static void addToItemTooltip(ItemTooltipEvent event) {
        CKinetics config;
        BlockItem bi;
        List tooltip;
        block17: {
            block16: {
                if (!((Boolean)AllConfigs.client().tooltips.get()).booleanValue()) {
                    return;
                }
                if (event.getEntity() == null) {
                    return;
                }
                tooltip = event.getToolTip();
                Item item = event.getItemStack().getItem();
                if ((item instanceof BucketItem || item instanceof MilkBucketItem) && ((Boolean)CDGConfig.FUEL_TOOLTIPS.get()).booleanValue()) {
                    Fluid fluid = (Fluid)NeoForgeMod.MILK.get();
                    if (item instanceof BucketItem) {
                        bi = (BucketItem)item;
                        fluid = bi.content;
                    }
                    FuelType type = FuelType.getTypeFor((HolderLookup.RegistryLookup<FuelType>)Minecraft.getInstance().level.registryAccess().lookupOrThrow(CDGRegistries.FUEL_TYPE), fluid);
                    if (Screen.hasAltDown() && type.normal().speed() != 0.0f) {
                        tooltip.add(1, Component.translatable((String)"createdieselgenerators.tooltip.holdForFuelStats", (Object[])new Object[]{Component.translatable((String)"createdieselgenerators.tooltip.keyAlt").withStyle(ChatFormatting.WHITE)}).withStyle(ChatFormatting.DARK_GRAY));
                        tooltip.add(2, Component.empty());
                        byte enginesEnabled = (byte)((EngineTypes.NORMAL.enabled() ? 1 : 0) + (EngineTypes.MODULAR.enabled() ? 1 : 0) + (EngineTypes.HUGE.enabled() ? 1 : 0));
                        int currentEngineIndex = AnimationTickHolder.getTicks() % 120 / 20;
                        List<EngineTypes> enabledEngines = Arrays.stream(EngineTypes.values()).filter(EngineTypes::enabled).toList();
                        Object currentEngine = enabledEngines.get(currentEngineIndex % enginesEnabled);
                        float currentSpeed = type.getGenerated((EngineTypes)((Object)currentEngine)).speed();
                        float currentCapacity = type.getGenerated((EngineTypes)((Object)currentEngine)).strength();
                        float currentBurn = type.getGenerated((EngineTypes)((Object)currentEngine)).burn();
                        if (enginesEnabled != 1) {
                            tooltip.add(3, Component.translatable((String)("block.createdieselgenerators." + (currentEngine == EngineTypes.MODULAR ? "large_" : (currentEngine == EngineTypes.HUGE ? "huge_" : "")) + "diesel_engine")).withStyle(ChatFormatting.GRAY));
                        }
                        tooltip.add(enginesEnabled != 1 ? 4 : 3, Component.translatable((String)"createdieselgenerators.tooltip.fuelSpeed", (Object[])new Object[]{CreateLang.number((double)currentSpeed).component().withStyle(FontHelper.Palette.STANDARD_CREATE.primary())}).withStyle(ChatFormatting.DARK_GRAY));
                        tooltip.add(enginesEnabled != 1 ? 5 : 4, Component.translatable((String)"createdieselgenerators.tooltip.fuelStress", (Object[])new Object[]{CreateLang.number((double)currentCapacity).component().withStyle(FontHelper.Palette.STANDARD_CREATE.primary())}).withStyle(ChatFormatting.DARK_GRAY));
                        tooltip.add(enginesEnabled != 1 ? 6 : 5, Component.translatable((String)"createdieselgenerators.tooltip.fuelBurnRate", (Object[])new Object[]{CreateLang.number((double)(currentBurn * 20.0f)).component().withStyle(FontHelper.Palette.STANDARD_CREATE.primary())}).withStyle(ChatFormatting.DARK_GRAY));
                        tooltip.add(enginesEnabled != 1 ? 7 : 6, Component.empty());
                        tooltip.add(enginesEnabled != 1 ? 8 : 7, Component.translatable((String)"createdieselgenerators.tooltip.burnerStrength", (Object[])new Object[]{CreateLang.number((double)(type.burnerStrength() * 100.0f)).text(" %").component().withStyle(FontHelper.Palette.STANDARD_CREATE.primary())}).withStyle(ChatFormatting.DARK_GRAY));
                        tooltip.add(enginesEnabled != 1 ? 9 : 8, Component.empty());
                    } else if (type.normal().speed() != 0.0f) {
                        tooltip.add(1, Component.translatable((String)"createdieselgenerators.tooltip.holdForFuelStats", (Object[])new Object[]{Component.translatable((String)"createdieselgenerators.tooltip.keyAlt").withStyle(ChatFormatting.GRAY)}).withStyle(ChatFormatting.DARK_GRAY));
                    }
                }
                config = AllConfigs.server().kinetics;
                if (!(item instanceof BlockItem)) break block16;
                bi = (BlockItem)item;
                if (IRotate.StressImpact.isEnabled() && (CDGBlocks.DIESEL_ENGINE.is((Item)bi) || CDGBlocks.MODULAR_DIESEL_ENGINE.is((Item)bi) || CDGBlocks.HUGE_DIESEL_ENGINE.is((Item)bi))) break block17;
            }
            return;
        }
        tooltip.add(Component.empty());
        int highestRPM = 0;
        int highestCapacity = 0;
        int highestStressCapacity = 0;
        for (Holder.Reference r : Minecraft.getInstance().level.registryAccess().lookupOrThrow(CDGRegistries.FUEL_TYPE).listElements().toList()) {
            FuelType type = (FuelType)r.value();
            if (CDGBlocks.DIESEL_ENGINE.is((Item)bi)) {
                highestRPM = (int)Math.max((float)highestRPM, type.normal().speed());
                highestCapacity = (int)Math.max((float)highestCapacity, type.normal().strength() / type.normal().speed());
                highestStressCapacity = (int)Math.max((float)highestStressCapacity, type.normal().strength());
                continue;
            }
            if (CDGBlocks.MODULAR_DIESEL_ENGINE.is((Item)bi)) {
                highestRPM = (int)Math.max((float)highestRPM, type.modular().speed());
                highestCapacity = (int)Math.max((float)highestCapacity, type.modular().strength() / type.modular().speed());
                highestStressCapacity = (int)Math.max((float)highestStressCapacity, type.modular().strength());
                continue;
            }
            if (!CDGBlocks.HUGE_DIESEL_ENGINE.is((Item)bi)) continue;
            highestRPM = (int)Math.max((float)highestRPM, type.huge().speed());
            highestCapacity = (int)Math.max((float)highestCapacity, type.huge().strength() / type.huge().speed());
            highestStressCapacity = (int)Math.max((float)highestStressCapacity, type.huge().strength());
        }
        boolean hasGoggles = GogglesItem.isWearingGoggles((Player)event.getEntity());
        LangBuilder rpmUnit = CreateLang.translate((String)"generic.unit.rpm", (Object[])new Object[0]);
        LangBuilder suUnit = CreateLang.translate((String)"generic.unit.stress", (Object[])new Object[0]);
        CreateLang.translate((String)"tooltip.capacityProvided", (Object[])new Object[0]).style(ChatFormatting.GRAY).addTo(tooltip);
        IRotate.StressImpact impactId = (double)highestCapacity >= (Double)config.highCapacity.get() ? IRotate.StressImpact.HIGH : ((double)highestCapacity >= (Double)config.mediumCapacity.get() ? IRotate.StressImpact.MEDIUM : IRotate.StressImpact.LOW);
        IRotate.StressImpact opposite = IRotate.StressImpact.values()[IRotate.StressImpact.values().length - 2 - impactId.ordinal()];
        LangBuilder builder = CreateLang.builder().add(CreateLang.text((String)TooltipHelper.makeProgressBar((int)3, (int)(impactId.ordinal() + 1))).style(opposite.getAbsoluteColor()));
        if (hasGoggles) {
            builder.add(CreateLang.number((double)highestCapacity)).text("x ").add(rpmUnit).addTo(tooltip);
            LangBuilder amount = CreateLang.number((double)highestStressCapacity).add(suUnit);
            CreateLang.text((String)" -> ").add(CreateLang.translate((String)"tooltip.up_to", (Object[])new Object[]{amount})).style(ChatFormatting.DARK_GRAY).addTo(tooltip);
        } else {
            builder.translate("tooltip.capacityProvided." + Lang.asId((String)impactId.name()), new Object[0]).addTo(tooltip);
        }
    }
}

