/*
 * Decompiled with CFR 0.152.
 */
package com.jesz.createdieselgenerators.content.basin_lid;

import com.jesz.createdieselgenerators.CDGBlockEntityTypes;
import com.jesz.createdieselgenerators.content.basin_lid.BasinLidBlockEntity;
import com.mojang.logging.LogUtils;
import com.simibubi.create.AllItems;
import com.simibubi.create.AllSoundEvents;
import com.simibubi.create.content.equipment.wrench.IWrenchable;
import com.simibubi.create.content.processing.basin.BasinBlockEntity;
import com.simibubi.create.foundation.block.IBE;
import com.simibubi.create.foundation.block.ProperWaterloggedBlock;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockSetType;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class BasinLidBlock
extends Block
implements ProperWaterloggedBlock,
IBE<BasinLidBlockEntity>,
IWrenchable {
    public static final DirectionProperty FACING = BlockStateProperties.HORIZONTAL_FACING;
    public static final BooleanProperty ON_A_BASIN = BooleanProperty.create((String)"on_a_basin");
    public static final BooleanProperty OPEN = BlockStateProperties.OPEN;
    public static final BooleanProperty POWERED = BlockStateProperties.POWERED;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;

    public BasinLidBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)super.defaultBlockState().setValue((Property)ON_A_BASIN, (Comparable)Boolean.valueOf(false)));
        this.registerDefaultState((BlockState)super.defaultBlockState().setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
        this.registerDefaultState((BlockState)super.defaultBlockState().setValue((Property)OPEN, (Comparable)Boolean.valueOf(false)));
        this.registerDefaultState((BlockState)super.defaultBlockState().setValue((Property)POWERED, (Comparable)Boolean.valueOf(false)));
    }

    public VoxelShape getShape(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        if (!((Boolean)pState.getValue((Property)OPEN)).booleanValue()) {
            return Shapes.or((VoxelShape)Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0), (VoxelShape)Block.box((double)5.0, (double)2.0, (double)5.0, (double)11.0, (double)4.0, (double)11.0));
        }
        if (pState.getValue((Property)FACING) == Direction.SOUTH) {
            return Shapes.or((VoxelShape)Block.box((double)0.0, (double)0.0, (double)14.0, (double)16.0, (double)16.0, (double)16.0), (VoxelShape)Block.box((double)5.0, (double)5.0, (double)16.0, (double)11.0, (double)11.0, (double)18.0));
        }
        if (pState.getValue((Property)FACING) == Direction.WEST) {
            return Shapes.or((VoxelShape)Block.box((double)0.0, (double)0.0, (double)0.0, (double)2.0, (double)16.0, (double)16.0), (VoxelShape)Block.box((double)-2.0, (double)5.0, (double)5.0, (double)0.0, (double)11.0, (double)11.0));
        }
        if (pState.getValue((Property)FACING) == Direction.NORTH) {
            return Shapes.or((VoxelShape)Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)2.0), (VoxelShape)Block.box((double)5.0, (double)5.0, (double)-2.0, (double)11.0, (double)11.0, (double)0.0));
        }
        return Shapes.or((VoxelShape)Block.box((double)14.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), (VoxelShape)Block.box((double)16.0, (double)5.0, (double)5.0, (double)18.0, (double)11.0, (double)11.0));
    }

    public void onPlace(BlockState state, Level level, BlockPos pos, BlockState p_60569_, boolean p_60570_) {
        super.onPlace(state, level, pos, p_60569_, p_60570_);
        if (level.getBlockEntity(pos.below()) instanceof BasinBlockEntity) {
            level.setBlock(pos, (BlockState)state.setValue((Property)ON_A_BASIN, (Comparable)Boolean.valueOf(true)), 2);
        } else {
            level.setBlock(pos, (BlockState)state.setValue((Property)ON_A_BASIN, (Comparable)Boolean.valueOf(false)), 2);
        }
    }

    public void neighborChanged(BlockState state, Level level, BlockPos pos, Block block, BlockPos p_57551_, boolean p_57552_) {
        boolean flag = level.hasNeighborSignal(pos);
        if (flag != (Boolean)(state = level.getBlockEntity(pos.below()) instanceof BasinBlockEntity ? (BlockState)state.setValue((Property)ON_A_BASIN, (Comparable)Boolean.valueOf(true)) : (BlockState)state.setValue((Property)ON_A_BASIN, (Comparable)Boolean.valueOf(false))).getValue((Property)POWERED)) {
            BlockEntity blockEntity;
            if (flag != (Boolean)state.getValue((Property)OPEN)) {
                level.levelEvent(null, flag ? 1037 : 1036, pos, 0);
                level.playSound(null, pos, flag ? BlockSetType.IRON.trapdoorOpen() : BlockSetType.IRON.trapdoorClose(), SoundSource.BLOCKS, 1.0f, level.getRandom().nextFloat() * 0.1f + 0.9f);
            }
            level.setBlock(pos, (BlockState)((BlockState)state.setValue((Property)POWERED, (Comparable)Boolean.valueOf(flag))).setValue((Property)OPEN, (Comparable)Boolean.valueOf(flag)), 2);
            if (flag && (blockEntity = level.getBlockEntity(pos)) instanceof BasinLidBlockEntity) {
                BasinLidBlockEntity a = (BasinLidBlockEntity)blockEntity;
                if (a.steamInside) {
                    level.playSound(null, pos, AllSoundEvents.STEAM.getMainEvent(), SoundSource.BLOCKS, 1.1f, 0.3f);
                    a.steamInside = false;
                    for (int i = 0; i < 3; ++i) {
                        ((ServerLevel)level).sendParticles((ParticleOptions)ParticleTypes.CAMPFIRE_COSY_SMOKE, (double)((float)pos.getX() + 0.5f) + new Random().nextDouble(-0.3, 0.3), (double)pos.getY(), (double)((float)pos.getZ() + 0.5f) + new Random().nextDouble(-0.3, 0.3), 0, 0.0, 1.0, 0.0, 0.01);
                    }
                }
            }
        } else {
            level.setBlock(pos, state, 2);
        }
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        BlockEntity blockEntity;
        if (AllItems.WRENCH.isIn(stack)) {
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        boolean currentState = (Boolean)state.getValue((Property)OPEN);
        if (!currentState && (blockEntity = level.getBlockEntity(pos)) instanceof BasinLidBlockEntity) {
            BasinLidBlockEntity a = (BasinLidBlockEntity)blockEntity;
            if (a.steamInside) {
                for (int i = 0; i < 3; ++i) {
                    if (!(level instanceof ServerLevel)) continue;
                    ServerLevel sl = (ServerLevel)level;
                    sl.sendParticles((ParticleOptions)ParticleTypes.CAMPFIRE_COSY_SMOKE, (double)((float)pos.getX() + 0.5f) + new Random().nextDouble(-0.3, 0.3), (double)pos.getY(), (double)((float)pos.getZ() + 0.5f) + new Random().nextDouble(-0.3, 0.3), 0, 0.0, 1.0, 0.0, 0.01);
                    sl.playSound(null, pos, AllSoundEvents.STEAM.getMainEvent(), SoundSource.BLOCKS, 0.1f, 0.3f);
                    a.steamInside = false;
                }
            }
        }
        if (!level.isClientSide() && hand == InteractionHand.MAIN_HAND) {
            LogUtils.getLogger().debug(String.valueOf(level));
            level.setBlock(pos, (BlockState)state.setValue((Property)OPEN, (Comparable)Boolean.valueOf(!currentState)), 3);
            level.levelEvent(null, currentState ? 1037 : 1036, pos, 0);
        }
        level.playSound(null, pos, !currentState ? BlockSetType.IRON.trapdoorOpen() : BlockSetType.IRON.trapdoorClose(), SoundSource.BLOCKS, 1.0f, level.getRandom().nextFloat() * 0.1f + 0.9f);
        return ItemInteractionResult.SUCCESS;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{ON_A_BASIN});
        builder.add(new Property[]{FACING});
        builder.add(new Property[]{OPEN});
        builder.add(new Property[]{WATERLOGGED});
        builder.add(new Property[]{POWERED});
        super.createBlockStateDefinition(builder);
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        if (context.getPlayer().isShiftKeyDown()) {
            return (BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)context.getHorizontalDirection().getOpposite())).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(context.getLevel().getFluidState(context.getClickedPos()).is((Fluid)Fluids.WATER)));
        }
        return (BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)context.getHorizontalDirection())).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(context.getLevel().getFluidState(context.getClickedPos()).is((Fluid)Fluids.WATER)));
    }

    public FluidState getFluidState(BlockState pState) {
        return this.fluidState(pState);
    }

    public BlockState updateShape(BlockState pState, Direction pDirection, BlockState pNeighborState, LevelAccessor pLevel, BlockPos pCurrentPos, BlockPos pNeighborPos) {
        this.updateWater(pLevel, pState, pCurrentPos);
        return pState;
    }

    public Class<BasinLidBlockEntity> getBlockEntityClass() {
        return BasinLidBlockEntity.class;
    }

    public BlockEntityType<? extends BasinLidBlockEntity> getBlockEntityType() {
        return (BlockEntityType)CDGBlockEntityTypes.BASIN_LID.get();
    }
}

