/*
 * Decompiled with CFR 0.152.
 */
package com.jesz.createdieselgenerators.commands;

import com.jesz.createdieselgenerators.world.OilChunksSavedData;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.ChunkPos;

public class CDGCommands {
    public CDGCommands(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)Commands.literal((String)"cdg").then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"oil").then(Commands.literal((String)"get").executes(command -> this.getOilChunk((CommandSourceStack)command.getSource())))).then(Commands.literal((String)"locate").executes(command -> this.locateOilChunk((CommandSourceStack)command.getSource())))).then(Commands.literal((String)"regenerate").executes(command -> this.refreshOilChunk((CommandSourceStack)command.getSource())))).then(((LiteralArgumentBuilder)Commands.literal((String)"set").then(Commands.literal((String)"infinity").executes(command -> this.setOilChunkInfinite((CommandSourceStack)command.getSource(), (CommandContext<CommandSourceStack>)command)))).then(Commands.argument((String)"amount", (ArgumentType)IntegerArgumentType.integer((int)0, (int)Integer.MAX_VALUE)).executes(command -> this.setOilChunk((CommandSourceStack)command.getSource(), (CommandContext<CommandSourceStack>)command))))));
    }

    private int getOilChunk(CommandSourceStack source) throws CommandSyntaxException {
        if (!source.hasPermission(2)) {
            return 0;
        }
        ChunkPos chunkPos = new ChunkPos(new BlockPos((int)source.getPosition().x, (int)source.getPosition().y, (int)source.getPosition().z));
        int amount = OilChunksSavedData.getChunkOilAmount(source.getLevel(), chunkPos);
        if (amount == Integer.MAX_VALUE) {
            source.sendSuccess(() -> Component.literal((String)"This oil chunk is infinite.").withStyle(ChatFormatting.GRAY), false);
        } else {
            source.sendSuccess(() -> Component.literal((String)"There is ").withStyle(ChatFormatting.GRAY).append((Component)Component.literal((String)(String.format("%,1d", amount) + "mB")).withStyle(ChatFormatting.GOLD)).append(" of Oil in this Chunk.").withStyle(ChatFormatting.GRAY), false);
        }
        return 1;
    }

    private int refreshOilChunk(CommandSourceStack source) throws CommandSyntaxException {
        if (!source.hasPermission(2)) {
            return 0;
        }
        ChunkPos chunkPos = new ChunkPos(new BlockPos((int)source.getPosition().x, (int)source.getPosition().y, (int)source.getPosition().z));
        OilChunksSavedData.removeChunk(source.getLevel(), chunkPos);
        source.sendSuccess(() -> Component.literal((String)"Refreshed this chunks oil contents").withStyle(ChatFormatting.GRAY), false);
        return 1;
    }

    private int setOilChunk(CommandSourceStack source, CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        if (!source.hasPermission(2)) {
            return 0;
        }
        ChunkPos chunkPos = new ChunkPos(new BlockPos((int)source.getPosition().x, (int)source.getPosition().y, (int)source.getPosition().z));
        int amount = IntegerArgumentType.getInteger(ctx, (String)"amount");
        OilChunksSavedData.setChunkOilAmount(source.getLevel(), chunkPos, amount);
        source.sendSuccess(() -> Component.literal((String)"Set this chunk's oil deposits to ").withStyle(ChatFormatting.GRAY).append((Component)Component.literal((String)(String.format("%,1d", amount) + "mB")).withStyle(ChatFormatting.GOLD)), false);
        return 1;
    }

    private int setOilChunkInfinite(CommandSourceStack source, CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        if (!source.hasPermission(2)) {
            return 0;
        }
        ChunkPos chunkPos = new ChunkPos(new BlockPos((int)source.getPosition().x, (int)source.getPosition().y, (int)source.getPosition().z));
        OilChunksSavedData.setChunkOilAmount(source.getLevel(), chunkPos, Integer.MAX_VALUE);
        source.sendSuccess(() -> Component.literal((String)"This chunk is now infinite").withStyle(ChatFormatting.GRAY), false);
        return 1;
    }

    private int locateOilChunk(CommandSourceStack source) throws CommandSyntaxException {
        if (!source.hasPermission(2)) {
            return 0;
        }
        BlockPos sourcePos = BlockPos.containing((Position)source.getPosition());
        ChunkPos centerChunk = new ChunkPos(sourcePos);
        int radius = 10;
        int dx = 0;
        int dz = -1;
        for (int i = 0; i < (radius * 2 + 1) * (radius * 2 + 1); ++i) {
            int cx = centerChunk.x + dx;
            int cz = centerChunk.z + dz;
            ChunkPos currentChunk = new ChunkPos(cx, cz);
            int amount = OilChunksSavedData.getChunkOilAmount(source.getLevel(), currentChunk);
            if (amount != 0) {
                int blockX = cx * 16 + 8;
                int blockZ = cz * 16 + 8;
                source.sendSuccess(() -> Component.literal((String)"There is oil in chunk ").withStyle(ChatFormatting.GRAY).append((Component)Component.literal((String)(cx + " " + cz)).withStyle(ChatFormatting.GOLD).withStyle(style -> style.withClickEvent(new ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, "/tp @s " + blockX + " ~ " + blockZ)))).append(" with ").withStyle(ChatFormatting.GRAY).append((Component)Component.literal((String)(String.format("%,1d", amount) + "mB ")).withStyle(ChatFormatting.GOLD)).append((Component)Component.literal((String)"of oil.").withStyle(ChatFormatting.GRAY)), false);
                return 1;
            }
            if (dx == dz || dx < 0 && dx == -dz || dx > 0 && dx == 1 - dz) {
                int temp = dx;
                dx = -dz;
                dz = temp;
            }
            dx += Integer.signum(dx);
            dz += Integer.signum(dz);
        }
        source.sendFailure((Component)Component.literal((String)"There is no oil chunk nearby").withStyle(ChatFormatting.RED));
        return 1;
    }
}

