/*
 * Decompiled with CFR 0.152.
 */
package net.myr.createmechanicalcompanion.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.myr.createmechanicalcompanion.screen.WolfMenu;

public class WolfScreen
extends AbstractContainerScreen<WolfMenu> {
    private static final ResourceLocation BACKGROUND_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"createmechanicalcompanion", (String)"textures/gui/inventory.png");
    private WolfMenu wolfMenu;

    public WolfScreen(WolfMenu pMenu, Inventory pPlayerInventory, Component pTitle) {
        super((AbstractContainerMenu)pMenu, pPlayerInventory, pTitle);
        this.wolfMenu = pMenu;
        this.imageWidth = 176;
        this.imageHeight = 172;
        this.titleLabelX = 10000;
        this.inventoryLabelX = 10000;
    }

    protected void renderBg(GuiGraphics pGuiGraphics, float pPartialTick, int pMouseX, int pMouseY) {
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)BACKGROUND_TEXTURE);
        int x = (this.width - this.imageWidth) / 2;
        int y = (this.height - this.imageHeight) / 2;
        pGuiGraphics.blit(BACKGROUND_TEXTURE, x, y, 0, 0, this.imageWidth, this.imageHeight);
        for (int i = 0; i < 9; ++i) {
            Slot currentSlot;
            if (i >= this.wolfMenu.slots.size() || !(currentSlot = (Slot)this.wolfMenu.slots.get(i)).hasItem()) continue;
            pGuiGraphics.blit(BACKGROUND_TEXTURE, x + currentSlot.x - 2, y + currentSlot.y - 2, 190, 20, 20, 20);
        }
        int xOffset = 51;
        int yOffset = 61;
        int renderX = (this.width - this.imageWidth) / 2 + xOffset;
        int renderY = (this.height - this.imageHeight) / 2 + yOffset;
        int scale = 25;
        InventoryScreen.renderEntityInInventoryFollowsMouse((GuiGraphics)pGuiGraphics, (int)(renderX - 25), (int)(renderY - 50), (int)(renderX + 25), (int)(renderY + 10), (int)scale, (float)0.0625f, (float)pMouseX, (float)pMouseY, (LivingEntity)((WolfMenu)this.menu).wolf);
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float delta) {
        this.renderBackground(guiGraphics, mouseX, mouseY, delta);
        super.render(guiGraphics, mouseX, mouseY, delta);
        this.renderTooltip(guiGraphics, mouseX, mouseY);
    }
}

