/*
 * Decompiled with CFR 0.152.
 */
package net.myr.createmechanicalcompanion.item;

import java.util.List;
import java.util.UUID;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.myr.createmechanicalcompanion.entity.CustomWolf;
import net.myr.createmechanicalcompanion.entity.ModEntity;
import net.neoforged.neoforge.items.ItemStackHandler;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.type.capability.ICurioItem;
import top.theillusivec4.curios.api.type.capability.ICuriosItemHandler;
import top.theillusivec4.curios.api.type.inventory.ICurioStacksHandler;

public class MechanicalWolfLink
extends Item
implements ICurioItem {
    private CompoundTag previousModuleTag;

    public MechanicalWolfLink(Item.Properties properties) {
        super(properties);
    }

    private CompoundTag getCustomTag(ItemStack stack) {
        CustomData customData = (CustomData)stack.get(DataComponents.CUSTOM_DATA);
        if (customData != null) {
            return customData.copyTag();
        }
        return new CompoundTag();
    }

    private void setCustomTag(ItemStack stack, CompoundTag tag) {
        stack.set(DataComponents.CUSTOM_DATA, (Object)CustomData.of((CompoundTag)tag));
    }

    public boolean canEquip(SlotContext slotContext, ItemStack stack) {
        LivingEntity playerEntity = slotContext.entity();
        if (!(playerEntity instanceof Player)) {
            return false;
        }
        Player player = (Player)playerEntity;
        ICuriosItemHandler curiosInventory = CuriosApi.getCuriosInventory((LivingEntity)playerEntity).orElse(null);
        if (curiosInventory == null) {
            return true;
        }
        ICurioStacksHandler headSlotHandler = (ICurioStacksHandler)curiosInventory.getCurios().get("head");
        if (headSlotHandler == null) {
            return true;
        }
        for (int i = 0; i < headSlotHandler.getSlots(); ++i) {
            ItemStack itemStack = headSlotHandler.getStacks().getStackInSlot(i);
            if (!(itemStack.getItem() instanceof MechanicalWolfLink)) continue;
            player.displayClientMessage((Component)Component.translatable((String)"item.createmechanicalcompanion.mechanical_wolf_link.duplicate_warning"), true);
            return false;
        }
        return true;
    }

    public void onUnequip(SlotContext slotContext, ItemStack newStack, ItemStack stack) {
        LivingEntity entity = slotContext.entity();
        Level level = entity.level();
        CompoundTag tag = this.getCustomTag(stack);
        if (!level.isClientSide && tag.contains("WolfUUID") && newStack.getItem().equals(Items.AIR)) {
            this.dismissWolf(level, tag);
            this.setCustomTag(stack, tag);
        }
    }

    public void curioTick(SlotContext slotContext, ItemStack stack) {
        LivingEntity livingEntity;
        Level level = slotContext.entity().level();
        if (level.isClientSide || !((livingEntity = slotContext.entity()) instanceof Player)) {
            return;
        }
        Player player = (Player)livingEntity;
        CompoundTag tag = this.getCustomTag(stack);
        if (tag.contains("WolfUUID")) {
            UUID wolfUUID = tag.getUUID("WolfUUID");
            Entity entity = ((ServerLevel)level).getEntity(wolfUUID);
            if (entity == null || !(entity instanceof CustomWolf)) {
                this.summonWolf(level, player, tag);
                this.setCustomTag(stack, tag);
                return;
            }
            CustomWolf wolf = (CustomWolf)entity;
            if (wolf.getHealth() <= 0.0f) {
                tag.putInt("SpawnCooldown", 200);
                this.setCustomTag(stack, tag);
            }
            if (wolf.getCustomName() != null) {
                String wolfName = wolf.getCustomName().getString();
                tag.putString("Nametag", wolfName);
                this.setCustomTag(stack, tag);
            }
            this.saveWolfModulesToTrinket(stack, wolf.getItemHandler());
        } else {
            this.summonWolf(level, player, tag);
            this.setCustomTag(stack, tag);
        }
    }

    private void summonWolf(Level level, Player player, CompoundTag tag) {
        if (tag.contains("SpawnCooldown")) {
            int spawnCooldown = tag.getInt("SpawnCooldown");
            if (--spawnCooldown == 0) {
                tag.remove("SpawnCooldown");
            } else {
                tag.putInt("SpawnCooldown", spawnCooldown);
            }
            return;
        }
        CustomWolf newWolf = new CustomWolf(ModEntity.CUSTOM_WOLF.get(), level);
        newWolf.tameToPlayer(player);
        newWolf.setPos(player.getX(), player.getY(), player.getZ());
        level.addFreshEntity((Entity)newWolf);
        if (tag.contains("Nametag")) {
            newWolf.setCustomName((Component)Component.literal((String)tag.getString("Nametag")));
        }
        ItemStackHandler wolfInventory = this.loadWolfModulesFromTrinket(tag, newWolf.getItemHandler().getSlots());
        newWolf.setItemHandler(wolfInventory);
        tag.putUUID("WolfUUID", newWolf.getUUID());
    }

    private void dismissWolf(Level level, CompoundTag tag) {
        if (tag != null && tag.hasUUID("WolfUUID")) {
            UUID wolfUUID = tag.getUUID("WolfUUID");
            Entity entity = ((ServerLevel)level).getEntity(wolfUUID);
            if (entity instanceof CustomWolf) {
                CustomWolf wolf = (CustomWolf)entity;
                this.saveWolfModulesToTrinketTag(tag, wolf.getItemHandler());
                wolf.discard();
            }
            tag.remove("WolfUUID");
        }
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        CompoundTag tag = this.getCustomTag(stack);
        if (Screen.hasShiftDown()) {
            tooltipComponents.add((Component)Component.translatable((String)"item.createmechanicalcompanion.shift2"));
            tooltipComponents.add((Component)Component.translatable((String)"item.createmechanicalcompanion.mechanical_wolf_link.tooltip"));
        } else {
            tooltipComponents.add((Component)Component.translatable((String)"item.createmechanicalcompanion.shift"));
        }
        if (tag.contains("SpawnCooldown")) {
            int cooldownTicks = tag.getInt("SpawnCooldown");
            int seconds = cooldownTicks / 20;
            tooltipComponents.add((Component)Component.literal((String)("\u00a77Spawn Cooldown: \u00a7c" + seconds + "s")));
        }
        super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
    }

    public void saveWolfModulesToTrinket(ItemStack stack, ItemStackHandler handler) {
        if (handler == null) {
            return;
        }
        CompoundTag tag = this.getCustomTag(stack);
        CompoundTag serialized = this.serializeHandler(handler);
        if (serialized.equals((Object)this.previousModuleTag)) {
            return;
        }
        tag.put("WolfModules", (Tag)serialized);
        this.previousModuleTag = serialized;
        this.setCustomTag(stack, tag);
    }

    private void saveWolfModulesToTrinketTag(CompoundTag tag, ItemStackHandler handler) {
        if (tag == null || handler == null) {
            return;
        }
        tag.put("WolfModules", (Tag)this.serializeHandler(handler));
    }

    private CompoundTag serializeHandler(ItemStackHandler handler) {
        CompoundTag tag = new CompoundTag();
        tag.putInt("Size", handler.getSlots());
        ListTag items = new ListTag();
        for (int i = 0; i < handler.getSlots(); ++i) {
            ItemStack slotStack = handler.getStackInSlot(i);
            if (slotStack.isEmpty()) continue;
            CompoundTag itemTag = new CompoundTag();
            itemTag.putInt("Slot", i);
            itemTag.putString("id", BuiltInRegistries.ITEM.getKey((Object)slotStack.getItem()).toString());
            itemTag.putInt("count", slotStack.getCount());
            items.add((Object)itemTag);
        }
        tag.put("Items", (Tag)items);
        return tag;
    }

    public ItemStackHandler loadWolfModulesFromTrinket(CompoundTag tag, int size) {
        CompoundTag modulesTag;
        ItemStackHandler handler = new ItemStackHandler(size);
        if (tag != null && tag.contains("WolfModules") && (modulesTag = tag.getCompound("WolfModules")).contains("Items")) {
            ListTag items = modulesTag.getList("Items", 10);
            for (int i = 0; i < items.size(); ++i) {
                Item item;
                ResourceLocation itemId;
                CompoundTag itemTag = items.getCompound(i);
                int slot = itemTag.getInt("Slot");
                if (slot < 0 || slot >= size || (itemId = ResourceLocation.tryParse((String)itemTag.getString("id"))) == null || (item = (Item)BuiltInRegistries.ITEM.get(itemId)) == Items.AIR) continue;
                handler.setStackInSlot(slot, new ItemStack((ItemLike)item, itemTag.getInt("count")));
            }
        }
        return handler;
    }
}

