/*
 * Decompiled with CFR 0.152.
 */
package net.myr.createmechanicalcompanion.item;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.decoration.PaintingVariant;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.myr.createmechanicalcompanion.entity.BlueprintPaintingEntity;
import net.myr.createmechanicalcompanion.entity.ModEntity;
import net.myr.createmechanicalcompanion.item.BlueprintPaintingVariants;

public class BlueprintPaintingItem
extends Item {
    public BlueprintPaintingItem(Item.Properties properties) {
        super(properties);
    }

    public void appendHoverText(ItemStack pStack, Item.TooltipContext pContext, List<Component> pTooltipComponents, TooltipFlag pIsAdvanced) {
        pTooltipComponents.add((Component)Component.translatable((String)"item.createmechanicalcompanion.blueprint_painting_tooltip"));
        super.appendHoverText(pStack, pContext, pTooltipComponents, pIsAdvanced);
    }

    public InteractionResult useOn(UseOnContext pContext) {
        Level level = pContext.getLevel();
        BlockPos pos = pContext.getClickedPos();
        Direction face = pContext.getClickedFace();
        if (face == Direction.DOWN || face == Direction.UP) {
            return InteractionResult.FAIL;
        }
        if (!level.isClientSide) {
            BlockPos placePos = pos.relative(face);
            List<Holder<PaintingVariant>> variants = BlueprintPaintingVariants.getAllVariants(level);
            for (Holder<PaintingVariant> variant : variants) {
                BlueprintPaintingEntity painting = (BlueprintPaintingEntity)ModEntity.BLUEPRINT_ENTITY.get().create(level);
                if (painting == null) continue;
                painting.setVariant(variant);
                painting.setDirectionPublic(face);
                painting.moveTo((double)placePos.getX() + 0.5, (double)placePos.getY() + 0.5, (double)placePos.getZ() + 0.5, face.toYRot(), 0.0f);
                if (!painting.survives()) continue;
                level.addFreshEntity((Entity)painting);
                if (pContext.getPlayer() != null && !pContext.getPlayer().getAbilities().instabuild) {
                    pContext.getItemInHand().shrink(1);
                }
                return InteractionResult.SUCCESS;
            }
            return InteractionResult.FAIL;
        }
        return InteractionResult.CONSUME;
    }
}

