/*
 * Decompiled with CFR 0.152.
 */
package net.myr.createmechanicalcompanion.entity;

import com.simibubi.create.AllEntityTypes;
import com.simibubi.create.content.equipment.potatoCannon.PotatoProjectileEntity;
import java.util.EnumSet;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.phys.Vec3;

public class PotatoCannonAttackGoal
extends Goal {
    private final Mob mob;
    private int cooldown = 0;
    private final double speed = 1.0;
    private final double attackRange = 10.0;
    private ItemStack[] projectileList = new ItemStack[]{new ItemStack((ItemLike)Items.POTATO), new ItemStack((ItemLike)Items.CARROT), new ItemStack((ItemLike)Items.COD), new ItemStack((ItemLike)Items.MELON_SLICE), new ItemStack((ItemLike)Items.POISONOUS_POTATO), new ItemStack((ItemLike)Items.BAKED_POTATO), new ItemStack((ItemLike)Items.SWEET_BERRIES), new ItemStack((ItemLike)Items.MELON), new ItemStack((ItemLike)Items.PUMPKIN), new ItemStack((ItemLike)Items.BEETROOT), new ItemStack((ItemLike)Items.APPLE)};

    public PotatoCannonAttackGoal(Mob mob) {
        this.mob = mob;
        this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean canUse() {
        return this.mob.getTarget() != null && this.mob.getTarget().isAlive();
    }

    public void tick() {
        LivingEntity target = this.mob.getTarget();
        if (target == null) {
            return;
        }
        double distance = this.mob.distanceTo((Entity)target);
        this.mob.getLookControl().setLookAt((Entity)target, 30.0f, 30.0f);
        if (distance > 10.0 || !this.mob.getSensing().hasLineOfSight((Entity)target)) {
            this.mob.getNavigation().moveTo((Entity)target, 1.0);
            return;
        }
        this.mob.getNavigation().stop();
        if (this.cooldown > 0) {
            --this.cooldown;
            return;
        }
        this.mob.getLookControl().setLookAt((Entity)target, 30.0f, 30.0f);
        this.cooldown = 20 + this.mob.getRandom().nextInt(20);
        Vec3 from = this.mob.position().add(0.0, (double)this.mob.getEyeHeight(), 0.0);
        Vec3 to = target.position().add(0.0, (double)target.getEyeHeight() + (double)this.mob.distanceTo((Entity)target) * 0.1, 0.0);
        Vec3 dir = to.subtract(from).normalize().scale(1.5);
        PotatoProjectileEntity proj = (PotatoProjectileEntity)AllEntityTypes.POTATO_PROJECTILE.create(this.mob.level());
        if (proj != null) {
            proj.setItem(this.getRandomProjectile());
            proj.setPos(from.x, from.y, from.z);
            proj.setDeltaMovement(dir);
            this.mob.level().addFreshEntity((Entity)proj);
        }
    }

    private ItemStack getRandomProjectile() {
        int rand = this.mob.getRandom().nextInt(this.projectileList.length);
        return this.projectileList[rand];
    }
}

