/*
 * Decompiled with CFR 0.152.
 */
package net.myr.createmechanicalcompanion.entity;

import java.util.EnumSet;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.phys.Vec3;

public class CustomLeapAtTargetGoal
extends Goal {
    private final Mob mob;
    private LivingEntity target;
    private final float yd;

    public CustomLeapAtTargetGoal(Mob pMob, float pYd) {
        this.mob = pMob;
        this.yd = pYd;
        this.setFlags(EnumSet.of(Goal.Flag.JUMP, Goal.Flag.MOVE));
    }

    public boolean canUse() {
        if (this.mob.isVehicle()) {
            return false;
        }
        this.target = this.mob.getTarget();
        if (this.target == null) {
            return false;
        }
        double d0 = this.mob.distanceToSqr((Entity)this.target);
        if (!(d0 < 4.0) && !(d0 > 16.0)) {
            if (!this.mob.onGround()) {
                return false;
            }
            return this.mob.getRandom().nextInt(CustomLeapAtTargetGoal.reducedTickDelay((int)5)) == 0;
        }
        return false;
    }

    public boolean canContinueToUse() {
        return !this.mob.onGround();
    }

    public void start() {
        this.mob.lookAt((Entity)this.target, 360.0f, 360.0f);
        Vec3 vec3 = this.mob.getDeltaMovement();
        Vec3 vec31 = new Vec3(this.target.getX() - this.mob.getX(), 0.0, this.target.getZ() - this.mob.getZ());
        if (vec31.lengthSqr() > 1.0E-7) {
            vec31 = vec31.normalize().scale(0.8).add(vec3.scale(0.2));
        }
        this.mob.setDeltaMovement(vec31.x, (double)this.yd, vec31.z);
    }
}

