/*
 * Decompiled with CFR 0.152.
 */
package net.myr.createmechanicalcompanion.client;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.client.ICurioRenderer;

public class MechanicalWolfLinkRenderer
implements ICurioRenderer {
    private static final ResourceLocation TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"createmechanicalcompanion", (String)"textures/item/mechanical_wolf_link_model.png");
    private final HumanoidModel<LivingEntity> model;

    public MechanicalWolfLinkRenderer(ModelPart part) {
        this.model = new HumanoidModel(part);
    }

    public <T extends LivingEntity, M extends EntityModel<T>> void render(ItemStack stack, SlotContext slotContext, PoseStack poseStack, RenderLayerParent<T, M> renderLayerParent, MultiBufferSource buffer, int light, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        LivingEntity entity = slotContext.entity();
        poseStack.pushPose();
        this.model.head.visible = true;
        this.model.hat.visible = false;
        this.model.body.visible = false;
        this.model.rightArm.visible = false;
        this.model.leftArm.visible = false;
        this.model.rightLeg.visible = false;
        this.model.leftLeg.visible = false;
        this.model.young = entity.isBaby();
        this.model.crouching = entity.isCrouching();
        this.model.riding = entity.isPassenger();
        EntityModel parentModel = renderLayerParent.getModel();
        if (parentModel instanceof HumanoidModel) {
            HumanoidModel humanoidModel = (HumanoidModel)parentModel;
            this.model.head.copyFrom(humanoidModel.head);
        }
        VertexConsumer vertexConsumer = ItemRenderer.getArmorFoilBuffer((MultiBufferSource)buffer, (RenderType)RenderType.armorCutoutNoCull((ResourceLocation)TEXTURE), (boolean)stack.hasFoil());
        this.model.head.render(poseStack, vertexConsumer, light, OverlayTexture.NO_OVERLAY);
        poseStack.popPose();
    }
}

