/*
 * Decompiled with CFR 0.152.
 */
package net.myr.createmechanicalcompanion.client;

import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.myr.createmechanicalcompanion.entity.CustomWolf;
import net.myr.createmechanicalcompanion.item.ModItems;
import org.jetbrains.annotations.NotNull;

public class CustomWolfModel
extends HierarchicalModel<CustomWolf> {
    private final ModelPart head;
    private final ModelPart body;
    private final ModelPart rightHindLeg;
    private final ModelPart leftHindLeg;
    private final ModelPart rightFrontLeg;
    private final ModelPart leftFrontLeg;
    private final ModelPart tail;
    private final ModelPart upperBody;
    private static final int LEG_SIZE = 8;
    private final ModelPart root;
    private final ModelPart reinforcedPlates0;
    private final ModelPart reinforcedPlates1;
    private final ModelPart reinforcedPlates2;
    private final ModelPart reinforcedPlates3;
    private final ModelPart netheritePlates0;
    private final ModelPart netheritePlates1;
    private final ModelPart netheritePlates2;
    private final ModelPart netheritePlates3;
    private final ModelPart mountedCrossbow;
    private final ModelPart teslaTail;
    private final ModelPart smeltingFangs;
    private final ModelPart boosterRocket;
    private final ModelPart quantumDrive;
    private final ModelPart mountedLight;
    private final ModelPart radar;
    private final ModelPart radarSpinner;
    private final ModelPart radarSpinner2;

    public CustomWolfModel(ModelPart root) {
        this.root = root;
        this.head = root.getChild("head");
        this.body = root.getChild("body");
        this.upperBody = root.getChild("upperBody");
        this.rightHindLeg = root.getChild("leg0");
        this.leftHindLeg = root.getChild("leg1");
        this.rightFrontLeg = root.getChild("leg2");
        this.leftFrontLeg = root.getChild("leg3");
        this.tail = root.getChild("tail");
        this.reinforcedPlates0 = this.rightHindLeg.getChild("reinforcedPlate0");
        this.reinforcedPlates1 = this.leftHindLeg.getChild("reinforcedPlate1");
        this.reinforcedPlates2 = this.rightFrontLeg.getChild("reinforcedPlate2");
        this.reinforcedPlates3 = this.leftFrontLeg.getChild("reinforcedPlate3");
        this.netheritePlates0 = this.rightHindLeg.getChild("netheritePlate0");
        this.netheritePlates1 = this.leftHindLeg.getChild("netheritePlate1");
        this.netheritePlates2 = this.rightFrontLeg.getChild("netheritePlate2");
        this.netheritePlates3 = this.leftFrontLeg.getChild("netheritePlate3");
        this.mountedCrossbow = this.body.getChild("crossbow");
        this.teslaTail = this.tail.getChild("teslaTail");
        this.smeltingFangs = this.head.getChild("smeltingFangs");
        this.boosterRocket = this.body.getChild("boosterRocket");
        this.quantumDrive = this.upperBody.getChild("quantumDrive");
        this.mountedLight = root.getChild("torch");
        this.radar = this.head.getChild("radar");
        this.radarSpinner = this.radar.getChild("radarSpinner");
        this.radarSpinner2 = this.radar.getChild("radarSpinner2");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition head = partdefinition.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 22).mirror().addBox(-3.0f, -3.0f, -2.0f, 6.0f, 6.0f, 4.0f, new CubeDeformation(0.0f)).mirror(false).texOffs(20, 29).addBox(-3.0f, -5.0f, 0.0f, 2.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(20, 29).addBox(1.0f, -5.0f, 0.0f, 2.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(18, 17).addBox(-2.0f, -0.0156f, -5.0f, 4.0f, 2.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-1.0f, (float)13.5f, (float)-7.0f));
        PartDefinition cube_r1 = head.addOrReplaceChild("cube_r1", CubeListBuilder.create().texOffs(26, 10).addBox(-1.5f, -2.0f, -0.5f, 3.0f, 1.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)4.0f, (float)-4.0f, (float)0.1745f, (float)0.0f, (float)0.0f));
        PartDefinition smeltingFangs = head.addOrReplaceChild("smeltingFangs", CubeListBuilder.create(), PartPose.offset((float)-1.3f, (float)2.4962f, (float)-3.6082f));
        PartDefinition fangs2_r1 = smeltingFangs.addOrReplaceChild("fangs2_r1", CubeListBuilder.create().texOffs(40, 60).addBox(-0.5f, -1.5f, -1.1918f, 1.0f, 3.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.1309f, (float)0.0f, (float)0.0f));
        PartDefinition fangs1_r1 = smeltingFangs.addOrReplaceChild("fangs1_r1", CubeListBuilder.create().texOffs(40, 60).addBox(-0.5f, -1.5f, -0.1918f, 1.0f, 3.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)2.6f, (float)0.0f, (float)-1.0f, (float)0.1309f, (float)0.0f, (float)0.0f));
        PartDefinition visor = head.addOrReplaceChild("visor", CubeListBuilder.create().texOffs(0, 14).addBox(-3.5f, -2.0f, 0.0f, 7.0f, 3.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-0.5f, (float)-3.0f));
        PartDefinition radar = head.addOrReplaceChild("radar", CubeListBuilder.create().texOffs(40, 52).addBox(-0.5f, -7.0f, 0.0f, 1.0f, 7.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(48, 54).addBox(-1.0f, -1.5f, -0.5f, 2.0f, 1.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-4.0f, (float)0.0f, (float)-1.0f));
        PartDefinition radarSpinner = radar.addOrReplaceChild("radarSpinner", CubeListBuilder.create().texOffs(44, 54).addBox(-2.0f, -0.5f, -1.0f, 4.0f, 1.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-7.5f, (float)0.5f));
        PartDefinition radarSpinner2 = radar.addOrReplaceChild("radarSpinner2", CubeListBuilder.create().texOffs(44, 54).addBox(-2.0f, -0.5f, -1.0f, 4.0f, 1.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-6.0f, (float)0.5f));
        PartDefinition body = partdefinition.addOrReplaceChild("body", CubeListBuilder.create(), PartPose.offsetAndRotation((float)0.0f, (float)14.0f, (float)2.0f, (float)1.5708f, (float)0.0f, (float)0.0f));
        PartDefinition body_r1 = body.addOrReplaceChild("body_r1", CubeListBuilder.create().texOffs(26, 17).addBox(-4.0f, -12.0f, -1.0f, 6.0f, 9.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)10.0f, (float)-3.0f, (float)-0.0873f, (float)0.0f, (float)0.0f));
        PartDefinition crossbow = body.addOrReplaceChild("crossbow", CubeListBuilder.create().texOffs(16, 58).addBox(-0.5f, -0.5f, -6.0f, 1.0f, 1.0f, 5.0f, new CubeDeformation(0.0f)).texOffs(16, 50).addBox(-1.5f, -5.5f, -1.0f, 3.0f, 11.0f, 3.0f, new CubeDeformation(0.0f)).texOffs(25, 50).addBox(-2.5f, 3.5f, 0.0f, 5.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-1.0f, (float)2.5f, (float)8.0f));
        PartDefinition cube_r2 = crossbow.addOrReplaceChild("cube_r2", CubeListBuilder.create().texOffs(16, 39).mirror().addBox(-0.5f, -4.5f, -1.0f, 1.0f, 9.0f, 2.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)2.0f, (float)0.0f, (float)0.5f, (float)0.0f, (float)0.0f, (float)-0.2182f));
        PartDefinition cube_r3 = crossbow.addOrReplaceChild("cube_r3", CubeListBuilder.create().texOffs(22, 39).addBox(-0.5f, -4.5f, -1.0f, 1.0f, 9.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-2.0f, (float)0.0f, (float)0.5f, (float)0.0f, (float)0.0f, (float)0.2182f));
        PartDefinition arrow = crossbow.addOrReplaceChild("arrow", CubeListBuilder.create().texOffs(8, 60).addBox(0.5f, -0.5f, -0.5f, 1.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-1.0f, (float)-7.0f, (float)0.5f));
        PartDefinition cube_r4 = arrow.addOrReplaceChild("cube_r4", CubeListBuilder.create().texOffs(28, 47).addBox(-0.5f, -0.5f, -1.0f, 2.0f, 1.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.7854f));
        PartDefinition cube_r5 = arrow.addOrReplaceChild("cube_r5", CubeListBuilder.create().texOffs(28, 47).addBox(-1.5f, -0.5f, -1.0f, 2.0f, 1.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)2.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.7854f));
        PartDefinition boosterRocket = body.addOrReplaceChild("boosterRocket", CubeListBuilder.create().texOffs(52, 0).addBox(4.5f, -4.5f, 0.5f, 3.0f, 3.0f, 3.0f, new CubeDeformation(0.0f)).texOffs(56, 0).addBox(5.0f, -3.5f, 1.0f, 2.0f, 9.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(52, 0).addBox(4.5f, 4.5f, 0.5f, 3.0f, 2.0f, 3.0f, new CubeDeformation(0.0f)).texOffs(54, 0).addBox(5.0f, -0.5f, -2.0f, 1.0f, 1.0f, 3.0f, new CubeDeformation(0.0f)).texOffs(52, 2).addBox(-1.5f, 4.5f, 0.5f, 3.0f, 2.0f, 3.0f, new CubeDeformation(0.0f)).texOffs(53, 0).addBox(-1.0f, -3.5f, 1.0f, 2.0f, 9.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(52, 4).addBox(-1.5f, -4.5f, 0.5f, 3.0f, 3.0f, 3.0f, new CubeDeformation(0.0f)).texOffs(55, 0).addBox(0.0f, -0.5f, -2.0f, 1.0f, 1.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-4.0f, (float)5.5f, (float)3.0f));
        PartDefinition upperBody = partdefinition.addOrReplaceChild("upperBody", CubeListBuilder.create().texOffs(0, 0).addBox(-4.0f, -3.0f, -3.0f, 8.0f, 7.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-1.0f, (float)14.0f, (float)-3.0f, (float)1.5708f, (float)0.0f, (float)0.0f));
        PartDefinition quantumDrive = upperBody.addOrReplaceChild("quantumDrive", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)1.485f, (float)4.1556f));
        PartDefinition quantumDrive2_r1 = quantumDrive.addOrReplaceChild("quantumDrive2_r1", CubeListBuilder.create().texOffs(37, 35).addBox(-3.0f, -3.985f, -0.9556f, 6.0f, 6.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)-0.0873f, (float)0.0f, (float)0.0f));
        PartDefinition quantumDrive1_r1 = quantumDrive.addOrReplaceChild("quantumDrive1_r1", CubeListBuilder.create().texOffs(52, 36).addBox(-3.5f, -10.0f, -1.0f, 5.0f, 5.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)1.0f, (float)6.515f, (float)-0.1556f, (float)-0.0873f, (float)0.0f, (float)0.0f));
        PartDefinition leg0 = partdefinition.addOrReplaceChild("leg0", CubeListBuilder.create().texOffs(50, 26).addBox(-2.0f, 7.0f, -2.0f, 3.0f, 2.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-3.5f, (float)15.0f, (float)7.0f));
        PartDefinition cube_r6 = leg0.addOrReplaceChild("cube_r6", CubeListBuilder.create().texOffs(52, 11).addBox(-2.0f, -3.0f, -0.5f, 3.0f, 3.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)6.0f, (float)1.0f, (float)0.0436f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r7 = leg0.addOrReplaceChild("cube_r7", CubeListBuilder.create().texOffs(50, 17).addBox(-1.0f, -4.0f, -2.0f, 3.0f, 5.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-1.0f, (float)1.0f, (float)0.0f, (float)0.1745f, (float)0.0f, (float)0.0f));
        PartDefinition leg1_r1 = leg0.addOrReplaceChild("leg1_r1", CubeListBuilder.create().texOffs(37, 44).addBox(0.0f, -4.0f, 6.0f, 2.0f, 4.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-1.5f, (float)8.0f, (float)-3.0f, (float)0.6545f, (float)0.0f, (float)0.0f));
        PartDefinition leg1_r2 = leg0.addOrReplaceChild("leg1_r2", CubeListBuilder.create().texOffs(37, 44).addBox(0.0f, -5.0f, 6.0f, 2.0f, 5.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-1.5f, (float)5.0f, (float)-6.0f, (float)-0.5236f, (float)0.0f, (float)0.0f));
        PartDefinition reinforcedPlate0 = leg0.addOrReplaceChild("reinforcedPlate0", CubeListBuilder.create(), PartPose.offset((float)-2.0f, (float)1.0f, (float)0.0f));
        PartDefinition cube_r8 = reinforcedPlate0.addOrReplaceChild("cube_r8", CubeListBuilder.create().texOffs(0, 51).addBox(-1.0f, -5.0f, -2.5f, 1.0f, 7.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.1705f, (float)-0.0376f, (float)0.215f));
        PartDefinition netheritePlate0 = leg0.addOrReplaceChild("netheritePlate0", CubeListBuilder.create(), PartPose.offset((float)-2.0f, (float)1.0f, (float)0.0f));
        PartDefinition cube_r9 = netheritePlate0.addOrReplaceChild("cube_r9", CubeListBuilder.create().texOffs(0, 38).addBox(-1.0f, -5.0f, -2.5f, 1.0f, 7.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.1705f, (float)-0.0376f, (float)0.215f));
        PartDefinition leg1 = partdefinition.addOrReplaceChild("leg1", CubeListBuilder.create().texOffs(50, 26).addBox(-3.0f, 7.0f, -2.0f, 3.0f, 2.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)3.5f, (float)15.0f, (float)7.0f));
        PartDefinition cube_r10 = leg1.addOrReplaceChild("cube_r10", CubeListBuilder.create().texOffs(52, 11).addBox(-2.0f, -3.0f, -0.5f, 3.0f, 3.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-1.0f, (float)6.0f, (float)1.0f, (float)0.0436f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r11 = leg1.addOrReplaceChild("cube_r11", CubeListBuilder.create().texOffs(50, 17).addBox(-2.0f, -4.0f, -2.0f, 3.0f, 5.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-1.0f, (float)1.0f, (float)0.0f, (float)0.1745f, (float)0.0f, (float)0.0f));
        PartDefinition leg1_r3 = leg1.addOrReplaceChild("leg1_r3", CubeListBuilder.create().texOffs(37, 43).addBox(0.0f, -4.0f, 6.0f, 2.0f, 4.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-2.5f, (float)8.0f, (float)-3.0f, (float)0.6545f, (float)0.0f, (float)0.0f));
        PartDefinition leg1_r4 = leg1.addOrReplaceChild("leg1_r4", CubeListBuilder.create().texOffs(37, 42).addBox(0.0f, -5.0f, 6.0f, 2.0f, 5.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-2.5f, (float)5.0f, (float)-6.0f, (float)-0.5236f, (float)0.0f, (float)0.0f));
        PartDefinition reinforcedPlate1 = leg1.addOrReplaceChild("reinforcedPlate1", CubeListBuilder.create(), PartPose.offset((float)-1.0f, (float)1.0f, (float)0.0f));
        PartDefinition cube_r12 = reinforcedPlate1.addOrReplaceChild("cube_r12", CubeListBuilder.create().texOffs(0, 51).addBox(1.0f, -5.0f, -2.5f, 1.0f, 7.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.1705f, (float)0.0376f, (float)-0.215f));
        PartDefinition netheritePlate1 = leg1.addOrReplaceChild("netheritePlate1", CubeListBuilder.create(), PartPose.offset((float)-1.0f, (float)1.0f, (float)0.0f));
        PartDefinition netheritePlate1_r1 = netheritePlate1.addOrReplaceChild("netheritePlate1_r1", CubeListBuilder.create().texOffs(0, 38).addBox(1.0f, -5.0f, -2.5f, 1.0f, 7.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.1705f, (float)0.0376f, (float)-0.215f));
        PartDefinition leg2 = partdefinition.addOrReplaceChild("leg2", CubeListBuilder.create().texOffs(50, 26).addBox(-4.0f, 8.0f, -4.5f, 3.0f, 2.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-2.5f, (float)14.0f, (float)-3.0f));
        PartDefinition cube_r13 = leg2.addOrReplaceChild("cube_r13", CubeListBuilder.create().texOffs(30, 0).addBox(-2.1f, -5.2f, -1.0f, 4.0f, 5.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-1.5f, (float)2.0f, (float)-1.0f, (float)0.1309f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r14 = leg2.addOrReplaceChild("cube_r14", CubeListBuilder.create().texOffs(52, 11).addBox(-4.0f, -3.0f, -0.1f, 3.0f, 3.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)5.0f, (float)-1.0f, (float)-0.0873f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r15 = leg2.addOrReplaceChild("cube_r15", CubeListBuilder.create().texOffs(37, 45).addBox(-1.5f, -3.0f, -1.0f, 2.0f, 3.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-2.0f, (float)3.0f, (float)0.0f, (float)0.0873f, (float)0.0f, (float)0.0f));
        PartDefinition leg3_r1 = leg2.addOrReplaceChild("leg3_r1", CubeListBuilder.create().texOffs(37, 42).addBox(1.0f, -8.0f, -5.0f, 2.0f, 7.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-4.5f, (float)12.0f, (float)1.0f, (float)-0.4363f, (float)0.0f, (float)0.0f));
        PartDefinition reinforcedPlate2 = leg2.addOrReplaceChild("reinforcedPlate2", CubeListBuilder.create(), PartPose.offset((float)-1.5f, (float)2.0f, (float)-1.0f));
        PartDefinition cube_r16 = reinforcedPlate2.addOrReplaceChild("cube_r16", CubeListBuilder.create().texOffs(0, 51).addBox(-2.1f, -6.2f, -1.0f, 1.0f, 7.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-1.0f, (float)0.0f, (float)-1.0f, (float)0.0853f, (float)-0.0227f, (float)0.1731f));
        PartDefinition netheritePlate2 = leg2.addOrReplaceChild("netheritePlate2", CubeListBuilder.create(), PartPose.offset((float)-2.5f, (float)2.0f, (float)-2.0f));
        PartDefinition cube_r17 = netheritePlate2.addOrReplaceChild("cube_r17", CubeListBuilder.create().texOffs(0, 38).addBox(-2.1f, -6.2f, -1.0f, 1.0f, 7.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0853f, (float)-0.0227f, (float)0.1731f));
        PartDefinition leg3 = partdefinition.addOrReplaceChild("leg3", CubeListBuilder.create().texOffs(50, 26).addBox(-1.0f, 8.0f, -4.5f, 3.0f, 2.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)2.5f, (float)14.0f, (float)-3.0f));
        PartDefinition cube_r18 = leg3.addOrReplaceChild("cube_r18", CubeListBuilder.create().texOffs(30, 0).addBox(-3.9f, -5.2f, -1.0f, 4.0f, 5.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)1.5f, (float)2.0f, (float)-1.0f, (float)0.1309f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r19 = leg3.addOrReplaceChild("cube_r19", CubeListBuilder.create().texOffs(52, 11).addBox(-4.0f, -3.0f, -0.1f, 3.0f, 3.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)3.0f, (float)5.0f, (float)-1.0f, (float)-0.0873f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r20 = leg3.addOrReplaceChild("cube_r20", CubeListBuilder.create().texOffs(37, 45).addBox(-1.5f, -3.0f, -1.0f, 2.0f, 3.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)1.0f, (float)3.0f, (float)0.0f, (float)0.0873f, (float)0.0f, (float)0.0f));
        PartDefinition leg3_r2 = leg3.addOrReplaceChild("leg3_r2", CubeListBuilder.create().texOffs(37, 42).addBox(1.0f, -8.0f, -4.0f, 2.0f, 7.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-1.5f, (float)12.0f, (float)0.0f, (float)-0.4363f, (float)0.0f, (float)0.0f));
        PartDefinition reinforcedPlate3 = leg3.addOrReplaceChild("reinforcedPlate3", CubeListBuilder.create(), PartPose.offset((float)1.5f, (float)2.0f, (float)-1.0f));
        PartDefinition cube_r21 = reinforcedPlate3.addOrReplaceChild("cube_r21", CubeListBuilder.create().texOffs(0, 51).addBox(-0.9f, -6.2f, -2.0f, 1.0f, 7.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)1.0f, (float)0.0f, (float)0.0f, (float)0.0853f, (float)0.0227f, (float)-0.1731f));
        PartDefinition netheritePlate3 = leg3.addOrReplaceChild("netheritePlate3", CubeListBuilder.create(), PartPose.offset((float)2.5f, (float)2.0f, (float)-1.0f));
        PartDefinition cube_r22 = netheritePlate3.addOrReplaceChild("cube_r22", CubeListBuilder.create().texOffs(0, 38).addBox(-0.9f, -6.2f, -2.0f, 1.0f, 7.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0853f, (float)0.0227f, (float)-0.1731f));
        PartDefinition tail = partdefinition.addOrReplaceChild("tail", CubeListBuilder.create().texOffs(44, 10).addBox(-1.0f, -0.5f, -1.0f, 2.0f, 9.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-1.0f, (float)14.4f, (float)8.3f));
        PartDefinition teslaTail = tail.addOrReplaceChild("teslaTail", CubeListBuilder.create().texOffs(28, 60).addBox(-2.5f, -9.1f, 5.8f, 3.0f, 1.0f, 3.0f, new CubeDeformation(0.0f)).texOffs(28, 60).addBox(-2.5f, -7.1f, 5.8f, 3.0f, 1.0f, 3.0f, new CubeDeformation(0.0f)).texOffs(28, 55).addBox(-2.5f, -5.1f, 5.8f, 3.0f, 2.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offset((float)1.0f, (float)13.6f, (float)-7.3f));
        PartDefinition torch = partdefinition.addOrReplaceChild("torch", CubeListBuilder.create(), PartPose.offset((float)-5.0f, (float)16.0f, (float)2.0f));
        PartDefinition torch1 = torch.addOrReplaceChild("torch1", CubeListBuilder.create().texOffs(56, 52).addBox(-1.0f, -11.0f, -1.0f, 2.0f, 10.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(44, 60).addBox(-1.5f, -5.0f, -1.5f, 3.0f, 1.0f, 3.0f, new CubeDeformation(0.0f)).texOffs(44, 60).addBox(-1.5f, -1.0f, -1.5f, 3.0f, 1.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)1.0f, (float)0.0f));
        PartDefinition torch2 = torch.addOrReplaceChild("torch2", CubeListBuilder.create().texOffs(56, 52).addBox(-1.0f, -10.0f, -1.0f, 2.0f, 10.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(44, 60).addBox(-1.5f, -4.0f, -1.5f, 3.0f, 1.0f, 3.0f, new CubeDeformation(0.0f)).texOffs(44, 60).addBox(-1.5f, 0.0f, -1.5f, 3.0f, 1.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offset((float)8.0f, (float)0.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public void setupAnim(CustomWolf entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        boolean hasNetheritePlates;
        boolean hasReinforcedPlates;
        this.head.yRot = netHeadYaw * ((float)Math.PI / 180);
        this.head.xRot = headPitch * ((float)Math.PI / 180);
        this.body.xRot = 1.5707964f;
        this.rightHindLeg.xRot = Mth.cos((float)(limbSwing * 0.6662f)) * 1.2f * limbSwingAmount;
        this.leftHindLeg.xRot = Mth.cos((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.2f * limbSwingAmount;
        this.rightFrontLeg.xRot = Mth.cos((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.2f * limbSwingAmount;
        this.leftFrontLeg.xRot = Mth.cos((float)(limbSwing * 0.6662f)) * 1.2f * limbSwingAmount;
        float healthPercentage = entity.getHealth() / entity.getMaxHealth();
        float tailAngle = healthPercentage * 70.0f;
        this.tail.xRot = (float)Math.toRadians(tailAngle);
        this.reinforcedPlates0.visible = hasReinforcedPlates = entity.isModuleEquipped(ModItems.REINFORCED_PLATES.get());
        this.reinforcedPlates1.visible = hasReinforcedPlates;
        this.reinforcedPlates2.visible = hasReinforcedPlates;
        this.reinforcedPlates3.visible = hasReinforcedPlates;
        this.netheritePlates0.visible = hasNetheritePlates = entity.isModuleEquipped(ModItems.NETHERITE_PLATES.get());
        this.netheritePlates1.visible = hasNetheritePlates;
        this.netheritePlates2.visible = hasNetheritePlates;
        this.netheritePlates3.visible = hasNetheritePlates;
        this.mountedLight.visible = entity.isModuleEquipped(ModItems.MOUNTED_LIGHT.get());
        this.teslaTail.visible = entity.isModuleEquipped(ModItems.TESLA_TAIL.get());
        this.radar.visible = entity.isModuleEquipped(ModItems.MOB_RADAR.get());
        this.quantumDrive.visible = entity.isModuleEquipped(ModItems.QUANTUM_DRIVE.get());
        this.smeltingFangs.visible = entity.isModuleEquipped(ModItems.SMELTING_FANGS.get());
        this.boosterRocket.visible = entity.isModuleEquipped(ModItems.BOOSTER_ROCKET.get());
        this.mountedCrossbow.visible = entity.isModuleEquipped(ModItems.MOUNTED_CROSSBOW.get());
        this.radarSpinner.yRot += 0.01f;
        this.radarSpinner2.yRot -= 0.01f;
    }

    @NotNull
    public ModelPart root() {
        return this.root;
    }
}

