/*
 * Decompiled with CFR 0.152.
 */
package com.pedrorok.hypertube.blocks;

import com.pedrorok.hypertube.blocks.HypertubeBlock;
import com.pedrorok.hypertube.core.connection.interfaces.ITubeConnection;
import com.pedrorok.hypertube.core.connection.interfaces.ITubeConnectionEntity;
import com.pedrorok.hypertube.registry.ModBlocks;
import com.simibubi.create.content.equipment.wrench.IWrenchable;
import com.simibubi.create.content.kinetics.base.KineticBlock;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.level.BlockEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class TubeBlock
extends KineticBlock
implements ITubeConnection,
SimpleWaterloggedBlock {
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;

    public TubeBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public abstract VoxelShape getShape(BlockState var1, @Nullable CollisionContext var2);

    @NotNull
    public VoxelShape getShape(@NotNull BlockState state, @NotNull BlockGetter worldIn, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        return this.getShape(state, context);
    }

    @NotNull
    public VoxelShape getCollisionShape(@NotNull BlockState state, @NotNull BlockGetter worldIn, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        return this.getShape(state, context);
    }

    @NotNull
    public VoxelShape getBlockSupportShape(@NotNull BlockState state, @NotNull BlockGetter reader, @NotNull BlockPos pos) {
        return this.getShape(state);
    }

    @NotNull
    public VoxelShape getInteractionShape(@NotNull BlockState state, @NotNull BlockGetter worldIn, @NotNull BlockPos pos) {
        return this.getShape(state);
    }

    @NotNull
    public RenderShape getRenderShape(@NotNull BlockState state) {
        return RenderShape.MODEL;
    }

    public VoxelShape getShape(BlockState state) {
        return this.getShape(state, null);
    }

    public Direction.Axis getRotationAxis(BlockState state) {
        return null;
    }

    @NotNull
    protected BlockState updateShape(BlockState p_313906_, @NotNull Direction p_313739_, @NotNull BlockState p_313829_, @NotNull LevelAccessor p_313692_, @NotNull BlockPos p_313842_, @NotNull BlockPos p_313843_) {
        if (((Boolean)p_313906_.getValue((Property)WATERLOGGED)).booleanValue()) {
            p_313692_.scheduleTick(p_313842_, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)p_313692_));
        }
        return super.updateShape(p_313906_, p_313739_, p_313829_, p_313692_, p_313842_, p_313843_);
    }

    @NotNull
    protected FluidState getFluidState(BlockState p_313789_) {
        return (Boolean)p_313789_.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(true) : super.getFluidState(p_313789_);
    }

    public abstract Item getItem();

    @NotNull
    public ItemStack getCloneItemStack(@NotNull LevelReader level, @NotNull BlockPos pos, @NotNull BlockState state) {
        return this.getItem().getDefaultInstance();
    }

    @NotNull
    public ItemStack getCloneItemStack(@NotNull BlockState state, @NotNull HitResult target, @NotNull LevelReader level, @NotNull BlockPos pos, @NotNull Player player) {
        return this.getItem().getDefaultInstance();
    }

    @NotNull
    public BlockState playerWillDestroy(@NotNull Level level, @NotNull BlockPos pos, @NotNull BlockState state, @NotNull Player player) {
        return this.playerWillDestroy(level, pos, state, player, false);
    }

    BlockState playerWillDestroy(@NotNull Level level, @NotNull BlockPos pos, @NotNull BlockState state, @NotNull Player player, boolean wrenched) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (!(blockEntity instanceof ITubeConnectionEntity)) {
            return super.playerWillDestroy(level, pos, state, player);
        }
        ITubeConnectionEntity tube = (ITubeConnectionEntity)blockEntity;
        int toDrop = tube.blockBroken();
        if (wrenched) {
            if (this instanceof HypertubeBlock) {
                ++toDrop;
            } else {
                player.getInventory().placeItemBackInInventory(this.getItem().getDefaultInstance());
            }
        }
        this.dropBlockToPlayer(wrenched, level, pos, player, blockEntity, toDrop);
        return super.playerWillDestroy(level, pos, state, player);
    }

    void dropBlockToPlayer(boolean isWrenched, Level level, BlockPos pos, Player player, BlockEntity blockEntity, int amount) {
        if (!player.isCreative() && (amount != 0 || isWrenched)) {
            ItemStack stack = new ItemStack((ItemLike)ModBlocks.HYPERTUBE.get(), amount);
            if (isWrenched) {
                player.getInventory().placeItemBackInInventory(stack);
            } else {
                Containers.dropItemStack((Level)level, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), (ItemStack)stack);
            }
        }
    }

    public InteractionResult onSneakWrenched(BlockState state, UseOnContext context) {
        if (context.getPlayer() == null) {
            return InteractionResult.PASS;
        }
        Level world = context.getLevel();
        BlockPos pos = context.getClickedPos();
        Player player = context.getPlayer();
        this.playerWillDestroy(world, context.getClickedPos(), state, context.getPlayer(), true);
        if (!(world instanceof ServerLevel)) {
            return InteractionResult.SUCCESS;
        }
        BlockEvent.BreakEvent event = new BlockEvent.BreakEvent(world, pos, world.getBlockState(pos), player);
        NeoForge.EVENT_BUS.post((Event)event);
        if (event.isCanceled()) {
            return InteractionResult.SUCCESS;
        }
        world.destroyBlock(pos, false);
        IWrenchable.playRemoveSound((Level)world, (BlockPos)pos);
        return InteractionResult.SUCCESS;
    }

    @Override
    public boolean canTravelConnect(LevelAccessor world, BlockPos posSelf, Direction facing) {
        TubeBlock hypertubeBlock;
        BlockPos relative = posSelf.relative(facing);
        BlockState otherState = world.getBlockState(relative);
        Block block = otherState.getBlock();
        return block instanceof ITubeConnection && (!(block instanceof TubeBlock) || this.canOtherConnectTo(otherState, hypertubeBlock = (TubeBlock)block, facing));
    }

    private boolean canOtherConnectTo(BlockState otherState, TubeBlock otherTube, Direction facing) {
        List connectedFaces = otherTube.getConnectedFaces(otherState);
        return connectedFaces.isEmpty() || connectedFaces.contains(facing);
    }
}

